/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpContainerNamespacesAPIService PulpContainerNamespacesAPI service
type PulpContainerNamespacesAPIService service

type PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
	nestedRole *NestedRole
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest) NestedRole(nestedRole NestedRole) PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesAddRoleExecute(r)
}

/*
PulpContainerNamespacesAddRole Method for PulpContainerNamespacesAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesAddRole(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesAddRoleExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespace *ContainerContainerNamespace
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest) ContainerContainerNamespace(containerContainerNamespace ContainerContainerNamespace) PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest {
	r.containerContainerNamespace = &containerContainerNamespace
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest) Execute() (*ContainerContainerNamespaceResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesCreateExecute(r)
}

/*
PulpContainerNamespacesCreate Create a container namespace

ViewSet for ContainerNamespaces.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesCreate(ctx context.Context) PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return ContainerContainerNamespaceResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesCreateExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesCreateRequest) (*ContainerContainerNamespaceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerNamespaceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/pulp_container/namespaces/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerNamespace == nil {
		return localVarReturnValue, nil, reportError("containerContainerNamespace is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerNamespace
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesDeleteExecute(r)
}

/*
PulpContainerNamespacesDelete Delete a container namespace

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesDelete(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesDeleteExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesListRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Limit(limit int32) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Name(name string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) NameContains(nameContains string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) NameIcontains(nameIcontains string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) NameIn(nameIn []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) NameStartswith(nameStartswith string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Offset(offset int32) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Ordering(ordering []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) PulpHrefIn(pulpHrefIn []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) PulpIdIn(pulpIdIn []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Fields(fields []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) ExcludeFields(excludeFields []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) Execute() (*PaginatedcontainerContainerNamespaceResponseList, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesListExecute(r)
}

/*
PulpContainerNamespacesList List container namespaces

ViewSet for ContainerNamespaces.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpContainerNamespacesAPIPulpContainerNamespacesListRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesList(ctx context.Context) PulpContainerNamespacesAPIPulpContainerNamespacesListRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerContainerNamespaceResponseList
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesListExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesListRequest) (*PaginatedcontainerContainerNamespaceResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerContainerNamespaceResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/pulp_container/namespaces/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest) Fields(fields []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest) ExcludeFields(excludeFields []string) PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesListRolesExecute(r)
}

/*
PulpContainerNamespacesListRoles Method for PulpContainerNamespacesListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesListRoles(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesListRolesExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest) Fields(fields []string) PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest) ExcludeFields(excludeFields []string) PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesMyPermissionsExecute(r)
}

/*
PulpContainerNamespacesMyPermissions Method for PulpContainerNamespacesMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesMyPermissions(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesMyPermissionsExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest) Fields(fields []string) PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest) ExcludeFields(excludeFields []string) PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest) Execute() (*ContainerContainerNamespaceResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesReadExecute(r)
}

/*
PulpContainerNamespacesRead Inspect a container namespace

ViewSet for ContainerNamespaces.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesRead(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return ContainerContainerNamespaceResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesReadExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesReadRequest) (*ContainerContainerNamespaceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerNamespaceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest struct {
	ctx context.Context
	ApiService *PulpContainerNamespacesAPIService
	containerContainerNamespaceHref string
	nestedRole *NestedRole
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest) NestedRole(nestedRole NestedRole) PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.PulpContainerNamespacesRemoveRoleExecute(r)
}

/*
PulpContainerNamespacesRemoveRole Method for PulpContainerNamespacesRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerNamespaceHref
 @return PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest
*/
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesRemoveRole(ctx context.Context, containerContainerNamespaceHref string) PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest {
	return PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerNamespaceHref: containerContainerNamespaceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *PulpContainerNamespacesAPIService) PulpContainerNamespacesRemoveRoleExecute(r PulpContainerNamespacesAPIPulpContainerNamespacesRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpContainerNamespacesAPIService.PulpContainerNamespacesRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_namespace_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_namespace_href"+"}", parameterValueToString(r.containerContainerNamespaceHref, "containerContainerNamespaceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
