/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.authentication;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.authentication.AuthUIParameter;
import org.dogtagpki.server.tps.authentication.TPSAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationManager {
    public static Logger logger = LoggerFactory.getLogger(AuthenticationManager.class);
    private Hashtable<String, TPSAuthenticator> authInstances;

    public void initAuthInstances() throws EBaseException {
        logger.debug("AuthenticationManager: initAuthInstances(): begins.");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        AuthenticationConfig authConfig = conf.getAuthenticationConfig();
        AuthManagersConfig authInstSubstore = authConfig.getAuthManagersConfig();
        Enumeration auth_enu = authInstSubstore.getSubStoreNames().elements();
        this.authInstances = new Hashtable();
        while (auth_enu.hasMoreElements()) {
            String authInstID = (String)auth_enu.nextElement();
            logger.debug("AuthenticationManager: initAuthInstances(): initializing authentication instance " + authInstID);
            ConfigStore authInstSub = authInstSubstore.getSubStore(authInstID, ConfigStore.class);
            TPSAuthenticator authInst = this.createAuthentication(authInstSub, authInstID);
            this.authInstances.put(authInstID, authInst);
            logger.debug("AuthenticationManager: initAuthInstances(): authentication instance " + authInstID + " initialized.");
        }
        logger.debug("AuthenticationManager: initAuthInstances(): ends.");
    }

    private TPSAuthenticator createAuthentication(ConfigStore conf, String authInstID) throws EBaseException {
        logger.debug("AuthenticationManager: createAuthentication(): begins for " + authInstID);
        if (conf == null || conf.size() <= 0) {
            logger.error("AuthenticationManager: createAuthentication(): conf null or empty.");
            throw new EBaseException("called with null config store");
        }
        TPSAuthenticator auth = new TPSAuthenticator(authInstID);
        ConfigStore uiSub = conf.getSubStore("ui", ConfigStore.class);
        if (uiSub == null) {
            logger.error("AuthenticationManager: createAuthentication(): conf " + conf.getName() + ".ui null or empty.");
            throw new EBaseException("config " + conf.getName() + ".ui not found");
        }
        ConfigStore uiTitleSub = uiSub.getSubStore("title", ConfigStore.class);
        if (uiTitleSub == null) {
            logger.error("AuthenticationManager: createAuthentication(): conf " + uiSub.getName() + ".title null or empty.");
            throw new EBaseException("config " + uiSub.getName() + ".title not found");
        }
        Enumeration uiTitle_enu = uiTitleSub.getPropertyNames();
        while (uiTitle_enu.hasMoreElements()) {
            String locale = (String)uiTitle_enu.nextElement();
            String title = uiTitleSub.getString(locale);
            if (title.isEmpty()) {
                logger.debug("AuthenticationManager: createAuthentication(): title for locale " + locale + " not found");
                continue;
            }
            auth.setUiTitle(locale, title);
            logger.debug("AuthenticationManager: createAuthentication(): added title=" + title + ", locale= " + locale);
        }
        ConfigStore uiDescSub = uiSub.getSubStore("description", ConfigStore.class);
        if (uiDescSub == null) {
            logger.error("AuthenticationManager: createAuthentication(): conf " + uiSub.getName() + ".description null or empty.");
            throw new EBaseException("config " + uiSub.getName() + ".description not found");
        }
        Enumeration uiDesc_enu = uiDescSub.getPropertyNames();
        while (uiDesc_enu.hasMoreElements()) {
            String locale = (String)uiDesc_enu.nextElement();
            String description = uiDescSub.getString(locale);
            if (description.isEmpty()) {
                logger.debug("AuthenticationManager: createAuthentication(): description for locale " + locale + " not found");
                continue;
            }
            auth.setUiDescription(locale, description);
            logger.debug("AuthenticationManager: createAuthentication(): added description=" + description + ", locale= " + locale);
        }
        ConfigStore uiParamSub = uiSub.getSubStore("id", ConfigStore.class);
        if (uiParamSub == null) {
            logger.error("AuthenticationManager: createAuthentication(): conf " + uiSub.getName() + ".id null or empty.");
            throw new EBaseException("config " + uiSub.getName() + ".id not found");
        }
        Enumeration uiParam_enu = uiParamSub.getSubStoreNames().elements();
        while (uiParam_enu.hasMoreElements()) {
            String id = (String)uiParam_enu.nextElement();
            logger.debug("AuthenticationManager: createAuthentication(): id param=" + id);
            ConfigStore idNameSub = uiParamSub.getSubStore(id + ".name", ConfigStore.class);
            if (idNameSub == null) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + uiParamSub.getName() + ".name null or empty.");
                continue;
            }
            AuthUIParameter up = new AuthUIParameter(id);
            Enumeration idName_enu = idNameSub.getPropertyNames();
            while (idName_enu.hasMoreElements()) {
                String locale = (String)idName_enu.nextElement();
                String name = idNameSub.getString(locale);
                if (name.isEmpty()) {
                    logger.debug("AuthenticationManager: createAuthentication(): name for locale " + locale + " not found");
                    continue;
                }
                logger.debug("AuthenticationManager: createAuthentication(): name =" + name + " for locale " + locale);
                up.setParamName(locale, name);
            }
            ConfigStore idDescSub = uiParamSub.getSubStore(id + ".description", ConfigStore.class);
            if (idDescSub == null) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + uiParamSub.getName() + ".description null or empty.");
                continue;
            }
            Enumeration idDesc_enu = idDescSub.getPropertyNames();
            while (idDesc_enu.hasMoreElements()) {
                String locale = (String)idDesc_enu.nextElement();
                String desc = idDescSub.getString(locale);
                if (desc.isEmpty()) {
                    logger.debug("AuthenticationManager: createAuthentication(): description for locale " + locale + " not found");
                    continue;
                }
                logger.debug("AuthenticationManager: createAuthentication(): desc=" + desc);
                up.setParamDescription(locale, desc);
            }
            auth.setUiParam(id, up);
            logger.debug("AuthenticationManager: createAuthentication(): added param=" + id);
            ConfigStore credMapSub = uiParamSub.getSubStore(id + ".credMap", ConfigStore.class);
            if (credMapSub == null) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + uiParamSub.getName() + ".credMap null or empty.");
                continue;
            }
            String authCred = credMapSub.getString("authCred");
            if (authCred.isEmpty()) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + credMapSub.getName() + ".authCred null or empty.");
                continue;
            }
            ConfigStore msgCredSub = credMapSub.getSubStore("msgCred", ConfigStore.class);
            if (msgCredSub == null) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + uiParamSub.getName() + ".msgCred null or empty.");
                continue;
            }
            String msgCred_login = msgCredSub.getString("login");
            if (msgCred_login.isEmpty()) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + msgCredSub.getName() + ".login null or empty.");
                continue;
            }
            auth.setCredMap(authCred, msgCred_login, false);
            logger.debug("AuthenticationManager: createAuthentication(): added cred map_login=" + authCred + ":" + msgCred_login);
            String msgCred_extlogin = msgCredSub.getString("extlogin");
            if (msgCred_extlogin.isEmpty()) {
                logger.debug("AuthenticationManager: createAuthentication(): conf " + msgCredSub.getName() + ".extlogin null or empty.");
                continue;
            }
            auth.setCredMap(authCred, msgCred_extlogin, true);
            logger.debug("AuthenticationManager: createAuthentication(): added cred map_extlogin=" + authCred + ":" + msgCred_extlogin);
        }
        Integer retries = uiSub.getInteger("retries", 1);
        auth.setNumOfRetries(retries);
        logger.debug("AuthenticationManager: createAuthentication(): completed for " + authInstID);
        return auth;
    }

    public TPSAuthenticator getAuthInstance(String id) {
        return this.authInstances.get(id);
    }
}

