/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.cmscore.connector.HttpConnector;
import com.netscape.cmsutil.http.HttpResponse;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.List;
import org.dogtagpki.server.tps.TPSConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.cms.CAEnrollCertResponse;
import org.dogtagpki.server.tps.cms.CARenewCertResponse;
import org.dogtagpki.server.tps.cms.CARetrieveCertResponse;
import org.dogtagpki.server.tps.cms.CARevokeCertResponse;
import org.dogtagpki.server.tps.cms.RemoteRequestHandler;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CARemoteRequestHandler
extends RemoteRequestHandler {
    public static Logger logger = LoggerFactory.getLogger(CARemoteRequestHandler.class);

    public CARemoteRequestHandler(String connID) throws EBaseException {
        if (connID == null) {
            throw new EBaseException("CARemoteRequestHandler: CARemoteRequestHandler(): connID null.");
        }
        this.connid = connID;
    }

    public CAEnrollCertResponse enrollCertificate(TPSBuffer pubKeybuf, String uid, String cuid, String tokenType, String keyType) throws EBaseException {
        return this.enrollCertificate(pubKeybuf, uid, null, 0, null, cuid, tokenType, keyType);
    }

    public CAEnrollCertResponse enrollCertificate(TPSBuffer pubKeybuf, String uid, String subjectdn, int sanNum, String urlSANext, String cuid, String tokenType, String keyType) throws EBaseException {
        String method = "CARemoteRequestHandler: enrollCertificate()";
        logger.debug(method + ": begins.");
        if (pubKeybuf == null || uid == null || cuid == null) {
            throw new EBaseException(method + ": input parameter null.");
        }
        if (tokenType == null) {
            tokenType = "";
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        String profileId = conf.getString("op.enroll." + tokenType + ".keyGen." + keyType + ".ca.profileId");
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        if (conn == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": HttpConnector conn null.");
        }
        logger.debug(method + ": sending request to CA");
        String encodedPubKey = null;
        try {
            encodedPubKey = Util.uriEncode((String)Utils.base64encode((byte[])pubKeybuf.toBytesArray(), (boolean)true));
        }
        catch (Exception e) {
            logger.error(method + ": uriEncode of pubkey failed: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + ": uriEncode of pubkey failed: " + e);
        }
        String sendMsg = null;
        if (subjectdn == null) {
            logger.debug(method + ":subjectdn null");
        }
        if (sanNum == 0) {
            logger.debug(method + ":sanNum 0");
        }
        if (subjectdn == null && sanNum == 0) {
            sendMsg = "xml=true&tokencuid=" + cuid + "&screenname=" + uid + "&publickey=" + encodedPubKey + "&profileId=" + profileId + "&tokentype=" + tokenType;
        } else {
            String urlSubjectdn;
            logger.debug(method + ": before send() with subjectdn and/or url_SAN_ext");
            if (subjectdn != null && sanNum == 0) {
                try {
                    urlSubjectdn = Util.uriEncode((String)subjectdn);
                    sendMsg = "xml=true&tokencuid=" + cuid + "&screenname=" + uid + "&publickey=" + encodedPubKey + "&profileId=" + profileId + "&subject=" + urlSubjectdn + "&tokentype=" + tokenType;
                }
                catch (Exception e) {
                    logger.error(method + ": uriEncode of pubkey failed: " + e.getMessage(), (Throwable)e);
                    throw new EBaseException(method + ": uriEncode of subjectdn failed: " + e);
                }
            }
            if (subjectdn == null && sanNum != 0) {
                sendMsg = "xml=true&tokencuid=" + cuid + "&screenname=" + uid + "&publickey=" + encodedPubKey + "&profileId=" + profileId + "&tokentype=" + tokenType + "&" + urlSANext;
            } else if (subjectdn != null && sanNum != 0) {
                try {
                    urlSubjectdn = Util.uriEncode((String)subjectdn);
                    sendMsg = "xml=true&tokencuid=" + cuid + "&screenname=" + uid + "&publickey=" + encodedPubKey + "&profileId=" + profileId + "&subject=" + urlSubjectdn + "&tokentype=" + tokenType + "&" + urlSANext;
                }
                catch (Exception e) {
                    logger.error(method + ": uriEncode of pubkey failed: " + e.getMessage(), (Throwable)e);
                    throw new EBaseException(method + ": uriEncode of subjectdn failed: " + e);
                }
            }
        }
        HttpResponse resp = conn.send("enrollment", sendMsg);
        if (resp == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": response null.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error(method + ": no response content");
            throw new EBaseException(method + ": no response content.");
        }
        logger.debug(method + ": got content");
        XMLObject xmlResponse = this.getXMLparser(content);
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        Integer ist = -1;
        String value = xmlResponse.getValue("Status");
        if (value == null) {
            logger.debug(method + ": Status not found.");
            logger.debug(method + ": got content");
        } else {
            logger.debug(method + ": got Status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = xmlResponse.getValue("SubjectDN");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: SubjectDN");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_SubjectDN = " + value);
            response.put("SubjectDN", value);
        }
        value = xmlResponse.getValue("serialno");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: serialno");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_serial = 0x" + value);
            response.put("serialno", value);
        }
        value = xmlResponse.getValue("b64");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: b64");
        } else {
            try {
                logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_b64");
                response.put("b64", value);
                X509CertImpl newCert = new X509CertImpl(Utils.base64decode((String)value));
                response.put("X509Certificate", newCert);
                logger.debug(method + ": new cert parsed successfully");
            }
            catch (Exception e) {
                logger.warn(method + ": exception:" + e.getMessage(), (Throwable)e);
            }
        }
        logger.debug(method + ": ends.");
        return new CAEnrollCertResponse(this.connid, response);
    }

    public CARetrieveCertResponse retrieveCertificate(BigInteger serialno) throws EBaseException {
        String method = "CARemoteRequestHandler: retrieveCertificate()";
        logger.debug(method + ": begins.");
        if (serialno == null) {
            throw new EBaseException(method + ": input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig tpsEngineConfig = engine.getConfig();
        TPSConfig tpsConfig = tpsEngineConfig.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        if (conn == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": HttpConnector conn null.");
        }
        logger.debug(method + ": sending request to CA");
        HttpResponse resp = conn.send("getcert", "xml=true&b64CertOnly=true&serialNumber=" + serialno.toString());
        if (resp == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": response null.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error(method + ": no response content");
            throw new EBaseException(method + ": no response content.");
        }
        XMLObject xmlResponse = this.getXMLparser(content);
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        logger.debug(method + ": content received");
        Integer ist = -1;
        String value = xmlResponse.getValue("Status");
        if (value == null) {
            logger.debug(method + ": Status not found.");
            logger.debug(method + ": got content");
        } else {
            logger.debug(method + ": got Status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = xmlResponse.getValue("certChainBase64");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: certChainBase64");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_chain_b64");
            response.put("certChainBase64", value);
            try {
                X509CertImpl newCert = new X509CertImpl(Utils.base64decode((String)value));
                response.put("X509Certificate", newCert);
                logger.debug(method + ": retrieved cert parsed successfully");
            }
            catch (CertificateException e) {
                logger.warn(method + ": exception:" + e.getMessage(), (Throwable)e);
            }
        }
        value = xmlResponse.getValue("revocationReason");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: revocationReason");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_RevocationReason = " + value);
            response.put("revocationReason", value);
        }
        logger.debug(method + ": ends.");
        return new CARetrieveCertResponse(this.connid, response);
    }

    public CARenewCertResponse renewCertificate(BigInteger serialno, String tokenType, String keyType) throws EBaseException {
        String method = "CARemoteRequestHandler: renewCertificate()";
        logger.debug(method + ": begins.");
        if (serialno == null) {
            throw new EBaseException(method + ": input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        String profileId = conf.getString("op.enroll." + tokenType + ".renewal." + keyType + ".ca.profileId");
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        if (conn == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": HttpConnector conn null.");
        }
        logger.debug(method + ": sending request to CA");
        HttpResponse resp = conn.send("renewal", "xml=true&renewal=true&serial_num=" + serialno.toString() + "&profileId=" + profileId);
        if (resp == null) {
            throw new EBaseException(method + " to connid: " + this.connid + ": response null.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error(method + ": no response content");
            throw new EBaseException(method + ": no response content.");
        }
        XMLObject xmlResponse = this.getXMLparser(content);
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        logger.debug(method + ": received:" + content);
        Integer ist = -1;
        String value = xmlResponse.getValue("Status");
        if (value == null) {
            logger.debug(method + ": Status not found.");
            logger.debug(method + ": got content");
        } else {
            logger.debug(method + ": got Status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = xmlResponse.getValue("SubjectDN");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: SubjectDN");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_SubjectDN = " + value);
            response.put("SubjectDN", value);
        }
        value = xmlResponse.getValue("serialno");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: serialno");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_serial = 0x" + value);
            response.put("serialno", value);
        }
        value = xmlResponse.getValue("b64");
        if (value == null) {
            logger.debug(method + ": response missing name-value pair for: b64");
        } else {
            logger.debug(method + ": got IRemoteRequest.CA_RESPONSE_Certificate_b64");
            response.put("b64", value);
            try {
                X509CertImpl newCert = new X509CertImpl(Utils.base64decode((String)value));
                response.put("X509Certificate", newCert);
                logger.debug(method + ": new cert parsed successfully");
            }
            catch (CertificateException e) {
                logger.warn(method + ": exception:" + e.getMessage(), (Throwable)e);
            }
        }
        logger.debug(method + ": ends.");
        return new CARenewCertResponse(this.connid, response);
    }

    private CARevokeCertResponse revokeCertificate(String serialno, RevocationReason reason) throws EBaseException {
        return this.revokeCertificate(null, serialno, reason);
    }

    private CARevokeCertResponse revokeCertificate(String caConn, String serialno, RevocationReason reason) throws EBaseException {
        String method = "CARemoteRequestHandler: revokeCertificate";
        String revCAid = this.connid;
        if (caConn != null) {
            logger.debug(method + ": passed in ca ID: " + caConn);
            revCAid = caConn;
        } else {
            logger.debug(method + ": using default ca ID:" + this.connid);
        }
        logger.debug(method + ": begins");
        if (serialno == null || reason == null) {
            throw new EBaseException(method + ": input parameter null.");
        }
        logger.debug(method + ": revoking serial#:" + serialno + "; reason String:" + reason.toString() + "; reason code:" + reason.getCode());
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(revCAid);
        if (conn == null) {
            throw new EBaseException(method + " to connid: " + revCAid + ": HttpConnector conn null.");
        }
        logger.debug(method + ": sending request to CA");
        HttpResponse resp = conn.send("revoke", "op=revoke&revocationReason=" + reason.getCode() + "&revokeAll=(certRecordId=" + serialno + ")&totalRecordCount=1");
        if (resp == null) {
            throw new EBaseException(method + " to connid: " + revCAid + ": response null.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error(method + ": no response content.");
            throw new EBaseException(method + ": no response content.");
        }
        logger.debug(method + ": got content = " + content);
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        logger.debug(method + ": got status = " + value);
        ist = Integer.parseInt(value);
        if (ist != 0) {
            logger.debug(method + ": status not 0, getting error string... ");
            value = (String)response.get("error");
            if (value == null) {
                logger.debug(method + ": response missing name-value pair for: error");
            } else {
                logger.debug(method + ": got IRemoteRequest.RESPONSE_ERROR_STRING = " + value);
                response.put("error", value);
            }
        }
        response.put("status", ist);
        logger.debug(method + ": ends.");
        return new CARevokeCertResponse(revCAid, response);
    }

    private CARevokeCertResponse unrevokeCertificate(String serialno) throws EBaseException {
        return this.unrevokeCertificate(null, serialno);
    }

    private CARevokeCertResponse unrevokeCertificate(String caConn, String serialno) throws EBaseException {
        String method = "CARemoteRequestHandler: unrevokeCertificate()";
        String unrevCAid = this.connid;
        if (caConn != null) {
            logger.debug(method + ": passed in ca ID: " + caConn);
            unrevCAid = caConn;
        } else {
            logger.debug(method + ": using default ca ID:" + this.connid);
        }
        logger.debug(method + ": begins on serial#:" + serialno);
        if (serialno == null) {
            throw new EBaseException(method + ": input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(unrevCAid);
        if (conn == null) {
            throw new EBaseException(method + " to connid: " + unrevCAid + ": HttpConnector conn null.");
        }
        logger.debug(method + ": sending request to CA");
        HttpResponse resp = conn.send("unrevoke", "serialNumber=" + serialno);
        if (resp == null) {
            throw new EBaseException(method + " to connid: " + unrevCAid + ": response null.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error(method + ": no response content.");
            throw new EBaseException(method + ": no response content.");
        }
        logger.debug(method + ": got content = " + content);
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        logger.debug(method + ": got status = " + value);
        ist = Integer.parseInt(value);
        if (ist != 0) {
            logger.debug(method + ": status not 0, getting error string... ");
            value = (String)response.get("error");
            if (value == null) {
                logger.debug(method + ": response missing name-value pair for: error");
            } else {
                logger.debug(method + ": got IRemoteRequest.RESPONSE_ERROR_STRING = " + value);
                response.put("error", value);
            }
        }
        response.put("status", ist);
        logger.debug(method + ": ends.");
        return new CARevokeCertResponse(unrevCAid, response);
    }

    private CARevokeCertResponse revokeFromOtherCA(boolean revoke, X509CertImpl cert, RevocationReason reason) throws EBaseException, IOException {
        String method = "CARemoteRequestHandler: revokeFromOtherCA()";
        if (cert == null) {
            throw new EBaseException(method + ": input parameter cert null.");
        }
        String certAkiString = null;
        try {
            certAkiString = Util.getCertAkiString((X509CertImpl)cert);
        }
        catch (Exception e) {
            throw new EBaseException(method + ": getCertAkiString failed:" + e);
        }
        return this.revokeFromOtherCA(revoke, cert.getSerialNumber().toString(), certAkiString, reason);
    }

    private CARevokeCertResponse revokeFromOtherCA(boolean revoke, String serialno, String certAkiString, RevocationReason reason) throws EBaseException {
        String method = "CARemoteRequestHandler: revokeFromOtherCA()";
        logger.debug(method + ": begins");
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        List<String> caList = subsystem.getConnectionManager().getCAList();
        Throwable exception = null;
        for (String ca : caList) {
            logger.debug(method + ": processing caList: ca id:" + ca);
            try {
                String caSkiString = this.getCaSki(ca);
                if (certAkiString.equals(caSkiString)) {
                    logger.debug(method + " cert AKI and caCert SKI matched");
                    return revoke ? this.revokeCertificate(ca, serialno, reason) : this.unrevokeCertificate(ca, serialno);
                }
                logger.debug(method + " cert AKI and caCert SKI not matched");
            }
            catch (Exception e) {
                logger.warn(method + " issue found, iterate to next ca in list: " + e.getMessage(), (Throwable)e);
                exception = e;
            }
        }
        if (exception == null) {
            throw new EBaseException(method + ": signing ca not found");
        }
        throw new EBaseException(method + exception.toString());
    }

    private String getCaSki(String conn) throws EBaseException, IOException {
        String method = "CARemoteRequestHandler: getCaSki()";
        String caSkiString = null;
        if (conn == null) {
            throw new EBaseException(method + ": input parameter conn null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(conn);
        try {
            return connectorConfig.getString("caSKI");
        }
        catch (EPropertyNotFound e) {
            logger.warn(method + " caSKI not yet calculated:" + e.getMessage(), (Throwable)e);
        }
        catch (EBaseException e) {
            throw e;
        }
        try {
            String caNickname = connectorConfig.getString("caNickname");
            logger.debug(method + " Calculating caSKI...searching for ca cert in nss db:" + caNickname);
            CryptoManager cm = CryptoManager.getInstance();
            try {
                X509Certificate c = cm.findCertByNickname(caNickname);
                X509CertImpl caCert = new X509CertImpl(c.getEncoded());
                caSkiString = Util.getCertSkiString((X509CertImpl)caCert);
                logger.debug(method + " caSKI calculated. Saving it.");
                connectorConfig.putString("caSKI", caSkiString);
                conf.commit(false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception et) {
                logger.error(method + " caSKI calculation failure." + et.getMessage(), (Throwable)et);
                throw new EBaseException(method + ": skip match.");
            }
        }
        catch (EBaseException e) {
            logger.debug(method + " caSKI calculation failure." + e);
            throw e;
        }
        catch (NotInitializedException e) {
            logger.error(method + " caSKI calculation failure." + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + ": skip match.:" + e);
        }
        return caSkiString;
    }

    public CARevokeCertResponse revokeCertificate(boolean revoke, X509CertImpl cert, RevocationReason reason) throws EBaseException {
        String method = "CARemoteRequestHandler: revokeCertificate()";
        if (cert == null) {
            throw new EBaseException(method + ": input parameter cert null.");
        }
        String certAkiString = null;
        try {
            certAkiString = Util.getCertAkiString((X509CertImpl)cert);
        }
        catch (IOException e) {
            throw new EBaseException(method + ": getCertAkiString failed:" + e);
        }
        return this.revokeCertificate(revoke, cert.getSerialNumber().toString(), certAkiString, reason);
    }

    public CARevokeCertResponse revokeCertificate(boolean revoke, String serialno, String certAkiString, RevocationReason reason) throws EBaseException {
        String method = "CARemoteRequestHandler: revokeCertificate()";
        logger.debug(method + " begins with CA discovery");
        if (revoke && reason == null) {
            throw new EBaseException(method + ": input parameter reason null.");
        }
        boolean skipMatch = false;
        String caSkiString = null;
        try {
            caSkiString = this.getCaSki(this.connid);
        }
        catch (Exception e) {
            logger.warn(method + " exception: " + e.getMessage(), (Throwable)e);
            skipMatch = true;
        }
        if (skipMatch) {
            return revoke ? this.revokeCertificate(serialno, reason) : this.unrevokeCertificate(serialno);
        }
        logger.debug(method + " cert AKI and caCert SKI matching begins");
        if (certAkiString.equals(caSkiString)) {
            logger.debug(method + " cert AKI and caCert SKI matched");
            return revoke ? this.revokeCertificate(serialno, reason) : this.unrevokeCertificate(serialno);
        }
        logger.debug(method + " cert AKI and caCert SKI of the designated issuing ca do not match...calling revokeFromOtherCA to search for another ca");
        return this.revokeFromOtherCA(revoke, serialno, certAkiString, reason);
    }
}

