/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.mapping;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.util.HashMap;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.mapping.BaseMappingResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingResolverManager {
    public static Logger logger = LoggerFactory.getLogger(MappingResolverManager.class);
    private static final String TOKEN_MAPPING_RESOLVER_TYPE = "tpsMappingResolver";
    public static final String PROP_RESOLVER_LIST = "list";
    public static final String PROP_RESOLVER_CLASS_ID = "class_id";
    protected static final String MAPPING_RESOLVER_CFG = "mappingResolver";
    protected PluginRegistry registry;
    protected HashMap<String, BaseMappingResolver> mappingResolvers = new HashMap();

    public void initMappingResolverInstances() throws EBaseException {
        String method = "mappingResolverManager.initMappingResolverInstance:";
        logger.debug(method + " begins");
        TPSEngine engine = TPSEngine.getInstance();
        this.registry = engine.getPluginRegistry();
        if (this.registry == null) {
            logger.warn(method + " registry null");
            return;
        }
        TPSEngineConfig conf = engine.getConfig();
        ConfigStore prConf = conf.getSubStore(MAPPING_RESOLVER_CFG, ConfigStore.class);
        String profileList = prConf.getString(PROP_RESOLVER_LIST, "");
        for (String prInst : profileList.split(",")) {
            String classID = prConf.getString(prInst + ".class_id");
            logger.debug(method + " initializing classID=" + classID);
            PluginInfo resolverInfo = this.registry.getPluginInfo(TOKEN_MAPPING_RESOLVER_TYPE, classID);
            String resolverClass = resolverInfo.getClassName();
            BaseMappingResolver resolver = null;
            try {
                resolver = (BaseMappingResolver)Class.forName(resolverClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error(method + " resolver plugin Class.forName " + resolverClass + ": " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
            resolver.init(prInst);
            this.addResolver(prInst, resolver);
            logger.debug(method + " resolver instance added: " + prInst);
        }
    }

    public BaseMappingResolver getResolverInstance(String name) {
        return this.mappingResolvers.get(name);
    }

    public void addResolver(String instName, BaseMappingResolver resolver) {
        this.mappingResolvers.put(instName, resolver);
    }
}

