/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.util.JSONSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.dogtagpki.acme.scheduler.ACMETask;
import org.dogtagpki.acme.scheduler.ACMETaskConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMESchedulerConfig
implements JSONSerializer {
    private Integer threads;
    private Map<String, ACMETaskConfig> tasks = new HashMap<String, ACMETaskConfig>();

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public ACMETaskConfig getTask(String name) {
        return this.tasks.get(name);
    }

    public void addTask(String name, ACMETaskConfig taskConfig) {
        this.tasks.put(name, taskConfig);
    }

    @JsonIgnore
    public Collection<String> getTaskNames() {
        return this.tasks.keySet();
    }

    public Map<String, ACMETaskConfig> getTasks() {
        return this.tasks;
    }

    public static ACMESchedulerConfig fromProperties(Properties props) throws Exception {
        ACMESchedulerConfig schedulerConfig = new ACMESchedulerConfig();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.equals("threads")) {
                schedulerConfig.setThreads(Integer.valueOf(value));
                continue;
            }
            String[] parts = key.split("\\.");
            String name = parts[0];
            String param = parts[1];
            ACMETaskConfig taskConfig = schedulerConfig.getTask(name);
            if (taskConfig == null) {
                taskConfig = new ACMETaskConfig();
                schedulerConfig.addTask(name, taskConfig);
            }
            if (param.equals("class")) {
                taskConfig.setClassName(value);
                continue;
            }
            if (param.equals("initialDelay")) {
                taskConfig.setInitialDelay(Integer.valueOf(value));
                continue;
            }
            if (param.equals("delay")) {
                taskConfig.setDelay(Integer.valueOf(value));
                continue;
            }
            if (param.equals("interval")) {
                taskConfig.setInterval(Integer.valueOf(value));
                continue;
            }
            if (param.equals("unit")) {
                taskConfig.setUnit(TimeUnit.valueOf(value));
                continue;
            }
            taskConfig.setParameter(param, value);
        }
        return schedulerConfig;
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ACMESchedulerConfig schedulerConfig = new ACMESchedulerConfig();
        schedulerConfig.setThreads(1);
        ACMETaskConfig taskConfig = new ACMETaskConfig();
        taskConfig.setClassName(ACMETask.class.getName());
        taskConfig.setInitialDelay(5);
        taskConfig.setDelay(5);
        taskConfig.setUnit(TimeUnit.MINUTES);
        schedulerConfig.addTask("task", taskConfig);
        System.out.println(schedulerConfig);
    }
}

