/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.evaluators;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cmscore.usrgrp.User;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserOrigReqAccessEvaluator
extends AccessEvaluator {
    public static Logger logger = LoggerFactory.getLogger(UserOrigReqAccessEvaluator.class);
    private static final String ANYBODY = "anybody";
    private static final String EVERYBODY = "everybody";

    public UserOrigReqAccessEvaluator() {
        this.type = "user_origreq";
        this.description = "user origreq matching evaluator";
    }

    @Override
    public void init() {
        logger.debug("UserOrigReqAccessEvaluator: init");
    }

    @Override
    public String[] getSupportedOperators() {
        String[] s = new String[]{"=", "!="};
        return s;
    }

    @Override
    public boolean evaluate(AuthToken authToken, String type, String op, String value) {
        logger.debug("UserOrigReqAccessEvaluator: evaluate() begins");
        if (type.equals(this.type)) {
            String s = Utils.stripQuotes((String)value);
            if ((s.equals(ANYBODY) || s.equals(EVERYBODY)) && op.equals("=")) {
                return true;
            }
            String userid = null;
            userid = authToken.getInString("userid");
            if (userid == null) {
                logger.warn("UserOrigReqAccessEvaluator: evaluate() userid in authtoken null");
                return false;
            }
            logger.debug("UserOrigReqAccessEvaluator: evaluate() userid in authtoken =" + userid);
            SessionContext mSC = SessionContext.getContext();
            logger.debug("UserOrigReqAccessEvaluator: evaluate() getting orig_req." + s + " in SessionContext");
            String orig_id = (String)mSC.get((Object)("orig_req." + s));
            if (orig_id == null) {
                logger.warn("UserOrigReqAccessEvaluator: evaluate() orig_id null");
                return false;
            }
            logger.debug("UserOrigReqAccessEvaluator: evaluate() orig_id =" + orig_id);
            if (op.equals("=")) {
                return userid.equalsIgnoreCase(orig_id);
            }
            if (op.equals("!=")) {
                return !userid.equalsIgnoreCase(orig_id);
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(String type, String op, String value) {
        SessionContext mSC = SessionContext.getContext();
        if (type.equals(this.type)) {
            String s = Utils.stripQuotes((String)value);
            if (s.equals(ANYBODY) && op.equals("=")) {
                return true;
            }
            User id = (User)mSC.get((Object)"user");
            String orig_id = (String)mSC.get((Object)("orig_req" + s));
            if (op.equals("=")) {
                return id.getUserID().equalsIgnoreCase(orig_id);
            }
            if (op.equals("!=")) {
                return !id.getUserID().equalsIgnoreCase(orig_id);
            }
        }
        return false;
    }
}

