/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cms.servlet.csadmin.SecurityDomainProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class UpdateDomainXML
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(UpdateDomainXML.class);
    private static final long serialVersionUID = 4059169588555717548L;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        logger.debug("UpdateDomainXML: initializing...");
        super.init(sc);
        logger.debug("UpdateDomainXML: done initializing...");
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.info("UpdateDomainXML: Updating security domain");
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        logger.info("UpdateDomainXML: Authenticating request");
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        AuthToken authToken = null;
        try {
            authToken = this.authenticate(cmsReq);
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", e.toString()), (Throwable)e);
            this.outputError(httpResp, "2", "Not authenticated", null);
            return;
        }
        if (authToken == null) {
            logger.error("UpdateDomainXML process: authToken is null");
            this.outputError(httpResp, "2", "Not authenticated", null);
            return;
        }
        logger.info("UpdateDomainXML: Authorizing request");
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "modify");
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Not authorized");
            return;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            logger.error("UpdateDomainXML process: authorization error");
            this.outputError(httpResp, "Not authorized");
            return;
        }
        String list = httpReq.getParameter("list");
        String type = httpReq.getParameter("type");
        String host = httpReq.getParameter("host");
        String name = httpReq.getParameter("name");
        String sport = httpReq.getParameter("sport");
        String agentsport = httpReq.getParameter("agentsport");
        String adminsport = httpReq.getParameter("adminsport");
        String eecaport = httpReq.getParameter("eeclientauthsport");
        String httpport = httpReq.getParameter("httpport");
        String domainmgr = httpReq.getParameter("dm");
        String clone = httpReq.getParameter("clone");
        String operation = httpReq.getParameter("operation");
        logger.info("UpdateDomainXML: Operation: " + operation);
        Object missing = "";
        if (host == null || host.equals("")) {
            missing = (String)missing + " host ";
        }
        if (name == null || name.equals("")) {
            missing = (String)missing + " name ";
        }
        if (sport == null || sport.equals("")) {
            missing = (String)missing + " sport ";
        }
        if (type == null || type.equals("")) {
            missing = (String)missing + " type ";
        }
        if (clone == null || clone.equals("")) {
            clone = "false";
        }
        if (!((String)missing).equals("")) {
            logger.error("UpdateDomainXML: Missing required parameters: " + (String)missing);
            this.outputError(httpResp, "Missing required parameters: " + (String)missing);
            return;
        }
        String basedn = null;
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        try {
            basedn = ldapConfig.getBaseDN();
        }
        catch (Exception e) {
            logger.warn("Unable to determine security domain name or basedn. Please run the domaininfo migration script: " + e.getMessage(), (Throwable)e);
        }
        logger.info("UpdateDomainXML: Base DN: " + basedn);
        SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(cmsReq.getHttpReq()));
        processor.setCMSEngine(engine);
        processor.init();
        String status = operation != null && operation.equals("remove") ? processor.removeHost(name, type, host, sport) : processor.addHost(name, type, host, sport, httpport, eecaport, adminsport, agentsport, domainmgr, clone);
        logger.info("UpdateDomainXML: Status: " + status);
        try {
            logger.debug("UpdateDomainXML: Sending response");
            XMLObject xmlObj = new XMLObject();
            Node root = xmlObj.createRoot("XMLResponse");
            xmlObj.addItemToContainer(root, "Status", status);
            byte[] cb = xmlObj.toByteArray();
            this.outputResult(httpResp, "application/xml", cb);
        }
        catch (Exception e) {
            logger.warn("UpdateDomainXML: Failed to send the XML output" + e.getMessage(), (Throwable)e);
        }
    }

    protected String securityDomainXMLtoLDAP(String xmltag) {
        return xmltag.equals("Host") ? "host" : xmltag;
    }

    @Override
    protected void setDefaultTemplates(ServletConfig sc) {
    }

    @Override
    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

