/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.apps;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerConfig {
    public static Logger logger = LoggerFactory.getLogger(ServerConfig.class);
    String unsecurePort;
    String securePort;

    public static ServerConfig load(String filename) throws Exception {
        logger.debug("ServerConfig: Parsing " + filename);
        ServerConfig serverConfig = new ServerConfig();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(filename);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        NodeList connectors = (NodeList)xpath.evaluate("/Server/Service[@name='Catalina']/Connector", document, XPathConstants.NODESET);
        int length = connectors.getLength();
        for (int i = 0; i < length; ++i) {
            Element connector = (Element)connectors.item(i);
            String protocol = connector.getAttribute("protocol");
            if (protocol.startsWith("AJP/")) continue;
            String scheme = connector.getAttribute("scheme");
            String port = connector.getAttribute("port");
            if (scheme != null && scheme.equals("https")) {
                logger.debug("ServerConfig: - secure port: " + port);
                serverConfig.setSecurePort(port);
                continue;
            }
            logger.debug("ServerConfig: - unsecure port: " + port);
            serverConfig.setUnsecurePort(port);
        }
        return serverConfig;
    }

    public String getUnsecurePort() {
        return this.unsecurePort;
    }

    public void setUnsecurePort(String unsecurePort) {
        this.unsecurePort = unsecurePort;
    }

    public String getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(String securePort) {
        this.securePort = securePort;
    }
}

