/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.CSCfgRecord;
import com.netscape.cmscore.dbs.Database;
import java.security.Principal;
import java.util.Arrays;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.lang3.StringUtils;

public class CSCfgDatabase<E extends CSCfgRecord>
extends Database<E> {
    public EngineConfig configStore;
    public String substoreName;

    public CSCfgDatabase(String name, String substoreName) {
        super(name);
        this.substoreName = substoreName;
    }

    public EngineConfig getEngineConfig() {
        return this.configStore;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.configStore = engineConfig;
    }

    public boolean requiresApproval() throws EBaseException {
        String value = this.configStore.getString("target.agent_approve.list", "");
        return Arrays.asList(StringUtils.split((String)value, (String)",")).contains(this.substoreName);
    }

    public boolean canApprove(Principal principal) {
        if (!(principal instanceof GenericPrincipal)) {
            return false;
        }
        return ((GenericPrincipal)principal).hasRole("TPS Agents");
    }

    public String getRecordStatus(String recordID) throws EBaseException {
        return this.configStore.getString("config." + this.substoreName + "." + recordID + ".state", "Enabled");
    }

    public void setRecordStatus(String recordID, String status) throws EBaseException {
        this.configStore.put("config." + this.substoreName + "." + recordID + ".state", status);
        this.configStore.put("config." + this.substoreName + "." + recordID + ".timestamp", "" + System.currentTimeMillis() * 1000L);
    }

    public void removeRecordStatus(String recordID) {
        this.configStore.remove("config." + this.substoreName + "." + recordID + ".state");
        this.configStore.remove("config." + this.substoreName + "." + recordID + ".timestamp");
    }
}

