/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.system.TPSConnectorCollection;
import com.netscape.certsrv.system.TPSConnectorData;
import com.netscape.certsrv.system.TPSConnectorResource;
import com.netscape.certsrv.tps.cert.TPSCertResource;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tks.TKSEngine;
import org.dogtagpki.server.tks.TKSEngineConfig;
import org.dogtagpki.server.tks.TPSConnectorConfig;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorService
extends PKIService
implements TPSConnectorResource {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorService.class);
    TKSEngine engine = TKSEngine.getInstance();
    TKSEngineConfig cs = this.engine.getConfig();
    public UGSubsystem userGroupManager = this.engine.getUGSubsystem();

    public Response findConnectors(String host, String port, Integer start, Integer size) {
        logger.info("TPSConnectorService: Finding TPS connectors for " + host + ":" + port);
        try {
            int i;
            start = start == null ? 0 : start;
            size = size == null ? 20 : size;
            Collection<String> tpsList = this.cs.getTPSConnectorIDs();
            Iterator<String> entries = tpsList.iterator();
            TPSConnectorCollection response = new TPSConnectorCollection();
            for (i = 0; i < start && entries.hasNext(); ++i) {
                entries.next();
            }
            while (i < start + size && entries.hasNext()) {
                TPSConnectorData connector = this.createTPSConnectorData(entries.next());
                if ((host == null || host.equals(connector.getHost())) && (port == null || port.equals(connector.getPort()))) {
                    response.addEntry((Object)connector);
                }
                ++i;
            }
            while (entries.hasNext()) {
                entries.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Unable to find TPS connectors: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to find TPS connectors: " + e.getMessage(), (Throwable)e);
        }
    }

    private TPSConnectorData createTPSConnectorData(String tpsID) throws EBaseException {
        TPSConnectorConfig tpsConfig = this.cs.getTPSConnectorConfig(tpsID);
        TPSConnectorData data = new TPSConnectorData();
        data.setID(tpsID);
        data.setHost(tpsConfig.getHost());
        data.setPort(tpsConfig.getPort());
        data.setUserID(tpsConfig.getUserID());
        data.setNickname(tpsConfig.getNickname());
        return data;
    }

    public Response getConnector(String id) {
        return this.createOKResponse(this.getConnectorData(id));
    }

    public TPSConnectorData getConnectorData(String id) {
        logger.info("TPSConnectorService: Getting TPS connector " + id);
        if (id == null) {
            throw new BadRequestException("TPS connector ID is null.");
        }
        try {
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("Connector " + id + " not found.");
            }
            return this.createTPSConnectorData(id);
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Unable to get TPS connector: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to get TPS connector: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response createConnector(String tpsHost, String tpsPort) {
        logger.info("TPSConnectorService: Creating TPS connector for " + tpsHost + ":" + tpsPort);
        if (tpsHost == null) {
            throw new BadRequestException("TPS connector host is null.");
        }
        if (tpsPort == null) {
            throw new BadRequestException("TPS connector port is null.");
        }
        try {
            String id = this.getConnectorID(tpsHost, tpsPort);
            if (id != null) {
                URI uri = this.uriInfo.getBaseUriBuilder().path(TPSCertResource.class).path("{id}").build(new Object[]{id});
                throw new BadRequestException("TPS connection already exists at " + uri.toString());
            }
            String newID = this.findNextConnectorID();
            TPSConnectorData newData = new TPSConnectorData();
            newData.setID(newID);
            newData.setHost(tpsHost);
            newData.setPort(tpsPort);
            newData.setUserID("TPS-" + tpsHost + "-" + tpsPort);
            URI uri = this.uriInfo.getBaseUriBuilder().path(TPSCertResource.class).path("{id}").build(new Object[]{newID});
            this.saveClientData(newData);
            this.addToConnectorList(newID);
            this.cs.commit(true);
            return this.createCreatedResponse(newData, uri);
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Unable to create new TPS connector: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to create new TPS connector: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response modifyConnector(String id, TPSConnectorData data) {
        logger.info("TPSConnectorService: Modifying TPS connector " + id);
        try {
            if (id == null) {
                throw new BadRequestException("Invalid connector ID");
            }
            if (data == null) {
                throw new BadRequestException("Invalid connector data");
            }
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("TPS connection does not exist");
            }
            if (data.getUserID() != null || data.getNickname() != null) {
                throw new UnauthorizedException("Cannot change userid or nickname using this interface");
            }
            TPSConnectorData curData = this.getConnectorData(id);
            curData.setHost(data.getHost());
            curData.setPort(data.getPort());
            this.saveClientData(curData);
            this.cs.commit(true);
            return this.createOKResponse(curData);
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Unable to modify TPS connector: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to modify TPS connector: " + e.getMessage(), (Throwable)e);
        }
    }

    private void saveClientData(TPSConnectorData newData) throws EBaseException {
        String id = newData.getID();
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.warn("TPSConnectorService: Attempt to save tps connection with null or empty id");
            return;
        }
        TPSConnectorConfig tpsConfig = this.cs.getTPSConnectorConfig(id);
        if (newData.getHost() != null) {
            tpsConfig.setHost(newData.getHost());
        }
        if (newData.getPort() != null) {
            tpsConfig.setPort(newData.getPort());
        }
        if (newData.getUserID() != null) {
            tpsConfig.setUserID(newData.getUserID());
        }
        if (newData.getNickname() != null) {
            tpsConfig.setNickname(newData.getNickname());
        }
    }

    public Response deleteConnector(String id) {
        logger.info("TPSConnectorService: Deleting TPS connector " + id);
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new BadRequestException("Attempt to delete TPS connection with null or empty id");
            }
            if (!this.connectorExists(id)) {
                return this.createNoContentResponse();
            }
            this.deleteSharedSecret(id);
            this.cs.removeTPSConnectorConfig(id);
            this.removeFromConnectorList(id);
            this.cs.commit(true);
            return this.createNoContentResponse();
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Failed to delete TPS connector: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Failed to delete TPS connector: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response deleteConnector(String host, String port) {
        logger.info("TPSConnectorService: Deleting TPS connector for " + host + ":" + port);
        if (host == null) {
            throw new BadRequestException("TPS connector host is null.");
        }
        if (port == null) {
            throw new BadRequestException("TPS connector port is null.");
        }
        try {
            String id = this.getConnectorID(host, port);
            this.deleteConnector(id);
        }
        catch (EBaseException e) {
            logger.error("TPSConnectorService: Failed to delete TPS connector: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Failed to delete TPS connector: " + e.getMessage(), (Throwable)e);
        }
        return this.createNoContentResponse();
    }

    public Response createSharedSecret(String id) {
        logger.info("TPSConnectorService: Creating shared secret for " + id);
        if (id == null) {
            throw new BadRequestException("TPS connector ID is null.");
        }
        try {
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("TPS connection does not exist");
            }
            String userid = this.validateUser(id);
            User user = this.userGroupManager.getUser(userid);
            logger.debug("TPSConnectorService.createSharedSecret.userid: " + userid);
            X509Certificate[] certs = user.getX509Certificates();
            String nickname = userid + " sharedSecret";
            logger.debug("TPSConnectorService.createSharedSecret. nickname: " + nickname);
            if (CryptoUtil.sharedSecretExists((String)nickname)) {
                throw new BadRequestException("Shared secret already exists");
            }
            CryptoUtil.createSharedSecret((String)nickname);
            TPSConnectorConfig tpsConfig = this.cs.getTPSConnectorConfig(id);
            tpsConfig.setNickname(nickname);
            this.cs.commit(true);
            SymmetricKey tempKey = CryptoUtil.createDes3SessionKeyOnInternal();
            if (tempKey == null) {
                return this.createNoContentResponse();
            }
            List listWrappedKeys = CryptoUtil.exportSharedSecret((String)nickname, (X509Certificate)certs[0], (SymmetricKey)tempKey);
            byte[] wrappedSessionKey = (byte[])listWrappedKeys.get(0);
            byte[] wrappedSharedSecret = (byte[])listWrappedKeys.get(1);
            KeyData keyData = new KeyData();
            keyData.setWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSessionKey));
            keyData.setAdditionalWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSharedSecret));
            return this.createOKResponse(keyData);
        }
        catch (Exception e) {
            logger.error("TPSConnectorService: Unable to generate and export shared secret: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to generate and export shared secret: " + e.getMessage(), (Throwable)e);
        }
    }

    private String validateUser(String id) throws EBaseException {
        TPSConnectorConfig tpsConfig = this.cs.getTPSConnectorConfig(id);
        String userid = tpsConfig.getUserID();
        if (userid.isEmpty()) {
            throw new PKIException("Bad TPS connection configuration: userid not defined");
        }
        Principal principal = this.servletRequest.getUserPrincipal();
        if (principal == null) {
            throw new UnauthorizedException("User credentials not provided");
        }
        String uid = principal.getName();
        if (!uid.equals(userid)) {
            throw new UnauthorizedException("TPS Connection belongs to another user");
        }
        return userid;
    }

    public Response replaceSharedSecret(String id) {
        logger.info("TPSConnectorService: Replacing shared secret for " + id);
        if (id == null) {
            throw new BadRequestException("TPS connector ID is null.");
        }
        try {
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("TPS connection does not exist");
            }
            String userid = this.validateUser(id);
            String nickname = userid + " sharedSecret";
            if (!CryptoUtil.sharedSecretExists((String)nickname)) {
                throw new BadRequestException("Cannot replace. Shared secret does not exist");
            }
            User user = this.userGroupManager.getUser(userid);
            X509Certificate[] certs = user.getX509Certificates();
            CryptoUtil.deleteSharedSecret((String)nickname);
            CryptoUtil.createSharedSecret((String)nickname);
            SymmetricKey tempKey = CryptoUtil.createDes3SessionKeyOnInternal();
            if (tempKey == null) {
                return this.createNoContentResponse();
            }
            List listWrappedKeys = CryptoUtil.exportSharedSecret((String)nickname, (X509Certificate)certs[0], (SymmetricKey)tempKey);
            byte[] wrappedSessionKey = (byte[])listWrappedKeys.get(0);
            byte[] wrappedSharedSecret = (byte[])listWrappedKeys.get(1);
            KeyData keyData = new KeyData();
            keyData.setWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSessionKey));
            keyData.setAdditionalWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSharedSecret));
            return this.createOKResponse(keyData);
        }
        catch (Exception e) {
            logger.error("TPSConnectorService: Unable to replace shared secret: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to replace shared secret: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response deleteSharedSecret(String id) {
        logger.info("TPSConnectorService: Deleting shared secret for " + id);
        if (id == null) {
            throw new BadRequestException("TPS connector ID is null.");
        }
        try {
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("TPS connection does not exist");
            }
            TPSConnectorConfig tpsConfig = this.cs.getTPSConnectorConfig(id);
            String userid = tpsConfig.getUserID();
            if (userid.isEmpty()) {
                throw new PKIException("Bad TPS connection configuration: userid not defined");
            }
            String nickname = userid + " sharedSecret";
            if (!CryptoUtil.sharedSecretExists((String)nickname)) {
                return this.createNoContentResponse();
            }
            CryptoUtil.deleteSharedSecret((String)nickname);
            tpsConfig.setNickname("");
            this.cs.commit(true);
            return this.createNoContentResponse();
        }
        catch (EBaseException | IllegalStateException | InvalidKeyException | NotInitializedException | TokenException e) {
            logger.error("TPSConnectorService: Unable to delete shared secret: " + e.getMessage(), e);
            throw new PKIException("Unable to delete shared secret: " + e.getMessage(), e);
        }
    }

    public Response getSharedSecret(String id) {
        logger.info("TPSConnectorService: Getting shared secret for " + id);
        if (id == null) {
            throw new BadRequestException("TPS connector ID is null.");
        }
        try {
            if (!this.connectorExists(id)) {
                throw new ResourceNotFoundException("TPS connection does not exist");
            }
            String userid = this.validateUser(id);
            String nickname = userid + " sharedSecret";
            if (!CryptoUtil.sharedSecretExists((String)nickname)) {
                return this.createNoContentResponse();
            }
            User user = this.userGroupManager.getUser(userid);
            X509Certificate[] certs = user.getX509Certificates();
            SymmetricKey tempKey = CryptoUtil.createDes3SessionKeyOnInternal();
            if (tempKey == null) {
                return this.createNoContentResponse();
            }
            List listWrappedKeys = CryptoUtil.exportSharedSecret((String)nickname, (X509Certificate)certs[0], (SymmetricKey)tempKey);
            byte[] wrappedSessionKey = (byte[])listWrappedKeys.get(0);
            byte[] wrappedSharedSecret = (byte[])listWrappedKeys.get(1);
            KeyData keyData = new KeyData();
            keyData.setWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSessionKey));
            keyData.setAdditionalWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSharedSecret));
            return this.createOKResponse(keyData);
        }
        catch (Exception e) {
            logger.error("TPSConnectorService: Unable to obtain shared secret: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to obtain shared secret: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean connectorExists(String id) throws EBaseException {
        Collection<String> tpsList = this.cs.getTPSConnectorIDs();
        return tpsList.contains(id);
    }

    private String getConnectorID(String host, String port) throws EBaseException {
        Collection<String> tpsList = this.cs.getTPSConnectorIDs();
        for (String tpsID : tpsList) {
            TPSConnectorData data = this.createTPSConnectorData(tpsID);
            if (!data.getHost().equals(host) || !data.getPort().equals(port)) continue;
            return tpsID;
        }
        return null;
    }

    private void addToConnectorList(String id) throws EBaseException {
        Collection<String> tpsList = this.cs.getTPSConnectorIDs();
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(tpsList);
        sorted.add(id);
        this.cs.setTPSConnectorIDs(sorted);
    }

    private void removeFromConnectorList(String id) throws EBaseException {
        Collection<String> tpsList = this.cs.getTPSConnectorIDs();
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(tpsList);
        sorted.remove(id);
        this.cs.setTPSConnectorIDs(sorted);
    }

    private String findNextConnectorID() throws EBaseException {
        Collection<String> tpsList = this.cs.getTPSConnectorIDs();
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(tpsList);
        int index = 0;
        while (sorted.contains(Integer.toString(index))) {
            ++index;
        }
        return Integer.toString(index);
    }
}

