/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.common;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.ISharedToken;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.profile.ECMCBadIdentityException;
import com.netscape.certsrv.profile.ECMCBadMessageCheckException;
import com.netscape.certsrv.profile.ECMCBadRequestException;
import com.netscape.certsrv.profile.ECMCPopFailedException;
import com.netscape.certsrv.profile.ECMCPopRequiredException;
import com.netscape.certsrv.profile.ECMCUnsupportedExtException;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkix.cmc.DecryptedPOP;
import org.mozilla.jss.pkix.cmc.IdentityProofV2;
import org.mozilla.jss.pkix.cmc.LraPopWitness;
import org.mozilla.jss.pkix.cmc.OtherMsg;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.PopLinkWitnessV2;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrollProfile
extends Profile {
    public static Logger logger = LoggerFactory.getLogger(EnrollProfile.class);
    public static final String CTX_CERT_REQUEST_TYPE = "cert_request_type";
    public static final String REQ_TYPE_PKCS10 = "pkcs10";
    public static final String REQ_TYPE_CRMF = "crmf";
    public static final String REQ_TYPE_CMC = "cmc";
    public static final String REQ_TYPE_KEYGEN = "keygen";
    public static final String REQUEST_LOCALE = "req_locale";
    public static final String REQUEST_SEQ_NUM = "req_seq_num";
    public static final String CTX_RENEWAL_SEQ_NUM = "renewal_seq_num";
    public static final String CTX_RENEWAL = "renewal";
    public static final String REQUEST_ISSUED_P12 = "req_issued_p12";
    public static final String REQUEST_AUTHORITY_ID = "req_authority_id";
    public static final String REQUEST_USER_DATA = "req_user_data";
    private static final OBJECT_IDENTIFIER PKIARCHIVEOPTIONS_OID = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L, 5L, 1L, 4L});

    @Override
    public Request[] createRequests(Map<String, String> ctx, Locale locale) throws Exception {
        String method = "EnrollProfile: createRequests: ";
        logger.debug(method + "begins");
        String cert_request_type = ctx.get(CTX_CERT_REQUEST_TYPE);
        String cert_request = ctx.get("cert_request");
        String is_renewal = ctx.get(CTX_RENEWAL);
        Integer renewal_seq_num = 0;
        if (cert_request_type == null) {
            logger.debug(method + " request type is null");
        }
        int num_requests = 1;
        if (cert_request_type != null && cert_request_type.startsWith(REQ_TYPE_PKCS10)) {
            logger.info("EnrollProfile: Parsing PKCS #10 request:");
            CAEngine engine = CAEngine.getInstance();
            PKCS10 pkcs10 = engine.parsePKCS10(locale, cert_request);
            PKCS10Attributes attributes = pkcs10.getAttributes();
            for (PKCS10Attribute attribute : attributes) {
                ObjectIdentifier attrID = attribute.getAttributeId();
                CertAttrSet attrValues = attribute.getAttributeValue();
                String attrName = attrValues.getName();
                logger.info("EnrollProfile: - " + attrID + ": " + attrName);
            }
        }
        if (cert_request_type != null && cert_request_type.startsWith(REQ_TYPE_CRMF)) {
            CertReqMsg[] msgs = CertUtil.parseCRMF((String)cert_request);
            num_requests = msgs.length;
        }
        TaggedRequest[] cmc_msgs = null;
        if (cert_request_type != null && cert_request_type.startsWith(REQ_TYPE_CMC)) {
            boolean donePOI = false;
            String signingUserSerial = ctx.get("cmcSigningCert");
            if (signingUserSerial != null) {
                donePOI = true;
            }
            cmc_msgs = this.parseCMC(locale, cert_request, donePOI);
            SessionContext sessionContext = SessionContext.getContext();
            String authenticatedSubject = (String)sessionContext.get((Object)"tokenSharedTokenAuthenticatedCertSubject");
            if (authenticatedSubject != null) {
                ctx.put("tokenSharedTokenAuthenticatedCertSubject", authenticatedSubject);
            }
            if (cmc_msgs == null) {
                logger.debug(method + "parseCMC returns cmc_msgs null");
                return null;
            }
            num_requests = cmc_msgs.length;
            logger.debug(method + "parseCMC returns cmc_msgs num_requests=" + num_requests);
        }
        if (is_renewal != null && is_renewal.equals("true")) {
            num_requests = 1;
            String renewal_seq_num_str = ctx.get(CTX_RENEWAL_SEQ_NUM);
            renewal_seq_num = renewal_seq_num_str == null ? 0 : Integer.parseInt(renewal_seq_num_str);
        }
        Request[] result = new Request[num_requests];
        for (int i = 0; i < num_requests; ++i) {
            result[i] = this.createEnrollmentRequest();
            if (is_renewal != null && is_renewal.equals("true")) {
                result[i].setExtData(REQUEST_SEQ_NUM, renewal_seq_num);
            } else {
                result[i].setExtData(REQUEST_SEQ_NUM, Integer.valueOf(i));
                if (cmc_msgs != null && cmc_msgs[i] != null) {
                    logger.debug(method + "setting cmc TaggedRequest in request");
                    result[i].setExtData("cert_request", ASN1Util.encode((ASN1Value)cmc_msgs[i]));
                }
            }
            if (locale != null) {
                result[i].setExtData(REQUEST_LOCALE, locale.getLanguage());
            }
            result[i].setExtData(REQUEST_AUTHORITY_ID, ctx.get(REQUEST_AUTHORITY_ID));
        }
        return result;
    }

    public void setDefaultCertInfo(Request request) throws EProfileException {
        X509CertInfo info = new X509CertInfo();
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority authority = engine.getCA();
        X500Name issuerName = authority.getX500Name();
        byte[] dummykey = new byte[]{48, 92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 75, 0, 48, 72, 2, 65, 0, -65, 121, -119, -59, 105, 66, -122, -78, -30, -64, 63, -47, 44, -48, -104, 103, -47, -108, 42, -38, 46, -8, 32, 49, -29, -26, -112, -29, -86, 71, 24, -104, 78, -31, -75, -128, 90, -92, -34, -51, -125, -13, 80, 101, -78, 39, -119, -38, 117, 28, 67, -19, -71, -124, -85, 105, -53, -103, -59, -67, -38, -83, 118, 65, 2, 3, 1, 0, 1};
        try {
            info.set("version", (Object)new CertificateVersion(2));
            info.set("serialNumber", (Object)new CertificateSerialNumber(new BigInteger("0")));
            if (authority.getIssuerObj() == null) {
                logger.debug("EnrollProfile: setDefaultCertInfo: authority.getIssuerObj() is null, creating new CertificateIssuerName");
                info.set("issuer", (Object)new CertificateIssuerName(issuerName));
            } else {
                logger.debug("EnrollProfile: setDefaultCertInfo: setting issuerDN using exact CA signing cert subjectDN encoding");
                info.set("issuer", (Object)authority.getIssuerObj());
            }
            info.set("key", (Object)new CertificateX509Key(X509Key.parse((DerValue)new DerValue(dummykey))));
            String defaultSubjectName = this.mConfig.getString("defaultSubjectName", "");
            info.set("subject", (Object)new CertificateSubjectName(new X500Name(defaultSubjectName)));
            info.set("validity", (Object)new CertificateValidity(new Date(), new Date()));
            info.set("algorithmID", (Object)new CertificateAlgorithmId(AlgorithmId.get((String)"SHA256withRSA")));
            info.set("extensions", (Object)new CertificateExtensions());
        }
        catch (Exception e) {
            logger.error("Unable to create X509CertInfo: " + e.getMessage(), (Throwable)e);
            throw new EProfileException((Throwable)e);
        }
        request.setExtData("req_x509info", info);
    }

    public Request createEnrollmentRequest() throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        Request req = null;
        try {
            RequestRepository requestRepository = engine.getRequestRepository();
            req = requestRepository.createRequest("enrollment");
            logger.info("EnrollProfile: Creating ernrollment request " + req.getRequestId().toHexString());
            this.setDefaultCertInfo(req);
            req.setExtData("req_extensions", new CertificateExtensions());
        }
        catch (EBaseException e) {
            throw new EProfileException("Unable to create enrollment request: " + e.getMessage(), (Throwable)e);
        }
        return req;
    }

    @Override
    public abstract void execute(Request var1) throws EProfileException;

    @Override
    public String getPolicySetId(Request req) {
        Integer seq = req.getExtDataInInteger(REQUEST_SEQ_NUM);
        int seq_no = seq;
        int count = 0;
        Enumeration<String> setIds = this.getProfilePolicySetIds();
        while (setIds.hasMoreElements()) {
            String setId = setIds.nextElement();
            if (count == seq_no) {
                return setId;
            }
            ++count;
        }
        return null;
    }

    @Override
    public String getRequestorDN(Request request) {
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        try {
            CertificateSubjectName sn = (CertificateSubjectName)info.get("subject");
            return sn.toString();
        }
        catch (Exception e) {
            logger.warn("Unable to get requestor DN: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setPOPchallenge(Request req) throws EBaseException {
        String method = "EnrollProfile: setPOPchallenge: ";
        Object msg = "";
        logger.debug(method + " getting user public key in request");
        if (req == null) {
            logger.error(method + "method parameters cannot be null");
            throw new EBaseException(method + (String)msg);
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        byte[] req_key_data = req.getExtDataInByteArray("req_key");
        if (req_key_data == null) {
            logger.error(method + " public key not found in request");
            throw new EBaseException(method + " public key not found in request");
        }
        logger.debug(method + "found user public key in request");
        SecureRandom random = jssSubsystem.getRandomNumberGenerator();
        byte[] challenge = new byte[64];
        random.nextBytes(challenge);
        PublicKey issuanceProtPubKey = engine.getIssuanceProtectionPublicKey();
        if (issuanceProtPubKey == null) {
            msg = method + "issuanceProtPubKey null";
            logger.error((String)msg);
            throw new EBaseException(method + (String)msg);
        }
        logger.debug(method + "issuanceProtPubKey not null");
        try {
            byte[] pop_sysPubEncryptedSession;
            CryptoToken token = null;
            String tokenName = cs.getString("cmc.token", "internal");
            token = CryptoUtil.getCryptoToken((String)tokenName);
            boolean useOAEP = cs.getUseOAEPKeyWrap();
            byte[] iv = CryptoUtil.getNonceData((int)EncryptionAlgorithm.AES_128_CBC.getIVLength());
            IVParameterSpec ivps = new IVParameterSpec(iv);
            PublicKey userPubKey = X509Key.parsePublicKey((DerValue)new DerValue(req_key_data));
            if (userPubKey == null) {
                msg = method + "userPubKey null after X509Key.parsePublicKey";
                logger.error((String)msg);
                throw new EBaseException((String)msg);
            }
            SymmetricKey symKey = CryptoUtil.generateKey((CryptoToken)token, (KeyGenAlgorithm)KeyGenAlgorithm.AES, (int)128, null, (boolean)true);
            byte[] pop_encryptedData = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)token, (SymmetricKey)symKey, (byte[])challenge, (EncryptionAlgorithm)EncryptionAlgorithm.AES_128_CBC, (IVParameterSpec)ivps);
            if (pop_encryptedData == null) {
                msg = method + "pop_encryptedData null";
                logger.error((String)msg);
                throw new EBaseException((String)msg);
            }
            KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
            if (useOAEP) {
                wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            if ((pop_sysPubEncryptedSession = CryptoUtil.wrapUsingPublicKey((CryptoToken)token, (PublicKey)issuanceProtPubKey, (SymmetricKey)symKey, (KeyWrapAlgorithm)wrapAlg)) == null) {
                msg = method + "pop_sysPubEncryptedSession null";
                logger.error((String)msg);
                throw new EBaseException((String)msg);
            }
            byte[] pop_userPubEncryptedSession = CryptoUtil.wrapUsingPublicKey((CryptoToken)token, (PublicKey)userPubKey, (SymmetricKey)symKey, (KeyWrapAlgorithm)wrapAlg);
            if (pop_userPubEncryptedSession == null) {
                msg = method + "pop_userPubEncryptedSession null";
                logger.error((String)msg);
                throw new EBaseException((String)msg);
            }
            logger.debug(method + "POP challenge fields generated successfully...setting request extData");
            req.setExtData("pop_encryptedData", pop_encryptedData);
            req.setExtData("pop_sysPubEncryptedSession", pop_sysPubEncryptedSession);
            req.setExtData("pop_userPubEncryptedSession", pop_userPubEncryptedSession);
            req.setExtData("pop_encryptedDataIV", iv);
            logger.debug(method + "now compute and set witness");
            String hashName = CryptoUtil.getDefaultHashAlgName();
            logger.debug(method + "hashName is " + hashName);
            MessageDigest hash = MessageDigest.getInstance(hashName);
            byte[] witness = hash.digest(challenge);
            req.setExtData("pop_witness", witness);
        }
        catch (Exception e) {
            String message = "Unable to generate POP challenge: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new EBaseException(message, (Throwable)e);
        }
    }

    @Override
    public void submit(AuthToken token, Request request) throws EDeferException, EProfileException {
        this.submit(token, request, false);
    }

    @Override
    public void submit(AuthToken token, Request request, boolean explicitApprovalRequired) throws EDeferException, EProfileException {
        String method = "EnrollProfile: submit: ";
        CAEngine engine = CAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        Object msg = "";
        logger.debug(method + "begins");
        boolean popChallengeRequired = request.getExtDataInBoolean("cmc_POPchallengeRequired", false);
        logger.debug(method + "popChallengeRequired =" + popChallengeRequired);
        try {
            requestRepository.updateRequest(request);
        }
        catch (EBaseException e) {
            logger.warn("Unable to update request: " + e.getMessage(), (Throwable)e);
        }
        if (token == null || explicitApprovalRequired) {
            if (token == null) {
                logger.debug(method + " auth token is null; agent manual approval required;");
            } else {
                logger.debug(method + "explicitApprovalRequired is true; agent manual approval required");
            }
            logger.debug(method + " validating request");
            this.validate(request);
            try {
                requestRepository.updateRequest(request);
            }
            catch (EBaseException e) {
                msg = method + " Unable to update request after validation: " + e.getMessage();
                logger.error((String)msg, (Throwable)e);
                throw new EProfileException((String)msg, (Throwable)e);
            }
            throw new EDeferException("defer request");
        }
        if (popChallengeRequired) {
            logger.debug(method + " popChallengeRequired, defer to enforce decryptedPOP");
            this.validate(request);
            logger.debug(method + " about to call setPOPchallenge");
            try {
                this.setPOPchallenge(request);
                requestRepository.updateRequest(request);
            }
            catch (EBaseException e) {
                msg = method + e.getMessage();
                logger.error((String)msg, (Throwable)e);
                throw new EProfileException((String)msg, (Throwable)e);
            }
            throw new ECMCPopRequiredException(" Return  with DecryptedPOP to complete");
        }
        logger.debug(method + " auth token is not null");
        this.validate(request);
        this.execute(request);
    }

    public PKIData getPKIDataFromCMCblob(Locale locale, String certReqBlob) throws EProfileException {
        String method = "EnrollProfile: getPKIDataFromCMCblob: ";
        Object msg = "";
        if (certReqBlob == null) {
            msg = method + "certReqBlob null";
            logger.error((String)msg);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + (String)msg);
        }
        logger.debug(method + "starts");
        byte[] data = CertUtil.parseCSR((String)certReqBlob);
        try {
            ByteArrayInputStream cmcBlobIn = new ByteArrayInputStream(data);
            PKIData pkiData = null;
            ContentInfo cmcReq = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)cmcBlobIn);
            OCTET_STRING content = null;
            if (cmcReq.getContentType().equals((Object)ContentInfo.SIGNED_DATA)) {
                logger.debug(method + "cmc request content is signed data");
                SignedData cmcFullReq = (SignedData)cmcReq.getInterpretedContent();
                EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                content = ci.getContent();
            } else {
                logger.debug(method + "cmc request content is unsigned data");
                content = (OCTET_STRING)cmcReq.getInterpretedContent();
            }
            ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
            pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
            return pkiData;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public static CertificateSubjectName getCMCSigningCertSNfromCertSerial(String certSerial) throws Exception {
        X509CertImpl userCert = EnrollProfile.getCMCSigningCertFromCertSerial(certSerial);
        return userCert == null ? null : userCert.getSubjectObj();
    }

    public static X509CertImpl getCMCSigningCertFromCertSerial(String certSerial) throws Exception {
        String method = "EnrollProfile: getCMCSigningCertFromCertSerial: ";
        Object msg = "";
        X509CertImpl userCert = null;
        if (certSerial == null || certSerial.equals("")) {
            msg = method + "certSerial empty";
            logger.error((String)msg);
            throw new Exception((String)msg);
        }
        CAEngine engine = CAEngine.getInstance();
        try {
            BigInteger serialNo = new BigInteger(certSerial);
            userCert = engine.getCertificateRepository().getX509Certificate(serialNo);
        }
        catch (NumberFormatException e) {
            msg = method + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            throw new Exception((String)msg, e);
        }
        catch (EBaseException e) {
            msg = method + e.getMessage() + "; signing user cert not found: serial=" + certSerial;
            logger.error((String)msg, (Throwable)e);
            throw new Exception((String)msg, e);
        }
        if (userCert == null) {
            msg = method + "signing user cert not found: serial=" + certSerial;
            logger.error((String)msg);
            throw new Exception((String)msg);
        }
        msg = method + "signing user cert found; serial=" + certSerial;
        logger.info((String)msg);
        return userCert;
    }

    public TaggedRequest[] parseCMC(Locale locale, String certreq) throws EProfileException {
        return this.parseCMC(locale, certreq, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaggedRequest[] parseCMC(Locale locale, String certreq, boolean donePOI) throws EProfileException {
        String method = "EnrollProfile: parseCMC: ";
        Object msg = "";
        logger.debug(method + "starts");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String auditMessage = "";
        String auditSubjectID = this.auditSubjectID();
        if (certreq == null) {
            msg = method + "certreq null";
            logger.error((String)msg);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + (String)msg);
        }
        TaggedRequest[] msgs = null;
        try {
            boolean id_cmc_revokeRequest;
            SessionContext context;
            UTF8String ident_s;
            byte[] randomSeed;
            SEQUENCE reqSeq;
            PKIData pkiData;
            block56: {
                SET vals;
                boolean id_cmc_idPOPLinkRandom;
                SET reqIdVals;
                boolean id_cmc_regInfo;
                SET decPopVals;
                boolean id_cmc_decryptedPOP;
                block54: {
                    TaggedAttribute attr;
                    boolean id_cmc_identityProof;
                    boolean id_cmc_identityProofV2;
                    boolean id_cmc_identification;
                    block57: {
                        pkiData = this.getPKIDataFromCMCblob(locale, certreq);
                        SEQUENCE controlSeq = pkiData.getControlSequence();
                        int numcontrols = controlSeq.size();
                        reqSeq = pkiData.getReqSequence();
                        randomSeed = null;
                        ident_s = null;
                        context = SessionContext.getContext();
                        String authManagerId = (String)context.get((Object)"authManagerId");
                        if (authManagerId == null) {
                            logger.debug(method + "authManagerId null.????");
                            authManagerId = "none";
                        } else {
                            logger.debug(method + "authManagerId =" + authManagerId);
                        }
                        if (authManagerId.equals("CMCAuth")) {
                            donePOI = true;
                        }
                        id_cmc_revokeRequest = false;
                        if (context.containsKey((Object)"numOfControls")) break block56;
                        logger.debug(method + "numcontrols=" + numcontrols);
                        if (numcontrols <= 0) break block56;
                        context.put((Object)"numOfControls", (Object)numcontrols);
                        TaggedAttribute[] attributes = new TaggedAttribute[numcontrols];
                        id_cmc_decryptedPOP = false;
                        decPopVals = null;
                        id_cmc_regInfo = false;
                        reqIdVals = null;
                        id_cmc_identification = false;
                        SET ident = null;
                        id_cmc_identityProofV2 = false;
                        id_cmc_identityProof = false;
                        attr = null;
                        id_cmc_idPOPLinkRandom = false;
                        vals = null;
                        logger.debug(method + "about to pre-process controls");
                        for (int i = 0; i < numcontrols; ++i) {
                            attributes[i] = (TaggedAttribute)controlSeq.elementAt(i);
                            OBJECT_IDENTIFIER oid = attributes[i].getType();
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_revokeRequest)) {
                                id_cmc_revokeRequest = true;
                                context.put((Object)OBJECT_IDENTIFIER.id_cmc_revokeRequest, (Object)attributes[i]);
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_decryptedPOP)) {
                                logger.debug(method + " id_cmc_decryptedPOP found");
                                id_cmc_decryptedPOP = true;
                                decPopVals = attributes[i].getValues();
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_regInfo)) {
                                logger.debug(method + "id_cmc_regInfo found");
                                id_cmc_regInfo = true;
                                reqIdVals = attributes[i].getValues();
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_identification)) {
                                logger.debug(method + " id_cmc_identification found");
                                id_cmc_identification = true;
                                ident = attributes[i].getValues();
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_identityProofV2)) {
                                logger.debug(method + " id_cmc_identityProofV2 found");
                                id_cmc_identityProofV2 = true;
                                attr = attributes[i];
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_identityProof)) {
                                logger.debug(method + " id_cmc_identityProof found");
                                id_cmc_identityProof = true;
                                attr = attributes[i];
                                continue;
                            }
                            if (oid.equals((Object)OBJECT_IDENTIFIER.id_cmc_idPOPLinkRandom)) {
                                logger.debug(method + "id_cmc_idPOPLinkRandom found");
                                id_cmc_idPOPLinkRandom = true;
                                vals = attributes[i].getValues();
                                continue;
                            }
                            logger.debug(method + "unknown control found");
                            context.put((Object)attributes[i].getType(), (Object)attributes[i]);
                        }
                        logger.debug(method + "processing controls...");
                        if (id_cmc_revokeRequest) {
                            logger.debug(method + "revocation control");
                        }
                        if (id_cmc_identification) {
                            if (ident == null) {
                                msg = "id_cmc_identification contains null attribute value";
                                logger.debug(method + (String)msg);
                                SEQUENCE bpids = this.getRequestBpids(reqSeq);
                                context.put((Object)"identification", (Object)bpids);
                                msg = " id_cmc_identification attribute value not found in";
                                logger.error(method + (String)msg);
                                throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + ":" + (String)msg);
                            }
                            ident_s = (UTF8String)ASN1Util.decode((ASN1Template)UTF8String.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)ident.elementAt(0)));
                            if (ident_s == null) {
                                msg = " id_cmc_identification contains invalid content";
                                logger.error(method + (String)msg);
                                SEQUENCE bpids = this.getRequestBpids(reqSeq);
                                context.put((Object)"identification", (Object)bpids);
                                throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + ":" + (String)msg);
                            }
                        }
                        if (!donePOI && !id_cmc_revokeRequest) break block57;
                        if (id_cmc_identityProofV2) {
                            logger.debug(method + "pre-signed CMC request, but id_cmc_identityProofV2 found...ignore; no further proof of identification check");
                            break block54;
                        } else if (id_cmc_identityProof) {
                            logger.debug(method + "pre-signed CMC request, but id_cmc_identityProof found...ignore; no further proof of identification check");
                            break block54;
                        } else {
                            logger.debug(method + "pre-signed CMC request; no further proof of identification check");
                        }
                        break block54;
                    }
                    if (id_cmc_identityProofV2 && attr != null) {
                        logger.debug(method + "not pre-signed CMC request; calling verifyIdentityProofV2;");
                        if (!id_cmc_identification || ident_s == null) {
                            SEQUENCE bpids = this.getRequestBpids(reqSeq);
                            context.put((Object)"identification", (Object)bpids);
                            context.put((Object)"identityProofV2", (Object)bpids);
                            msg = "id_cmc_identityProofV2 missing id_cmc_identification";
                            logger.error(method + (String)msg);
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                            auditor.log(auditMessage);
                            throw new ECMCBadIdentityException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + ":" + (String)msg);
                        }
                        valid = this.verifyIdentityProofV2(context, attr, ident_s, reqSeq, pkiData);
                        if (!valid) {
                            bpids = this.getRequestBpids(reqSeq);
                            context.put((Object)"identityProofV2", (Object)bpids);
                            msg = " after verifyIdentityProofV2";
                            logger.error(method + (String)msg);
                            throw new ECMCBadIdentityException(CMS.getUserMessage((Locale)locale, (String)"CMS_POI_VERIFICATION_ERROR", (String[])new String[0]) + (String)msg);
                        }
                        logger.debug(method + "passed verifyIdentityProofV2; Proof of Identity successful;");
                    } else if (id_cmc_identityProof && attr != null) {
                        logger.debug(method + "not pre-signed CMC request; calling verifyIdentityProof;");
                        valid = this.verifyIdentityProof(attr, reqSeq, pkiData);
                        if (!valid) {
                            bpids = this.getRequestBpids(reqSeq);
                            context.put((Object)"identityProof", (Object)bpids);
                            msg = " after verifyIdentityProof";
                            logger.error(method + (String)msg);
                            throw new ECMCBadIdentityException(CMS.getUserMessage((Locale)locale, (String)"CMS_POI_VERIFICATION_ERROR", (String[])new String[0]) + (String)msg);
                        }
                        logger.debug(method + "passed verifyIdentityProof; Proof of Identity successful;");
                        auditSubjectID = this.auditSubjectID();
                    } else {
                        msg = "not pre-signed CMC request; missing Proof of Identification control";
                        logger.error(method + (String)msg);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                        auditor.log(auditMessage);
                        throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_POI_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                    }
                }
                if (id_cmc_decryptedPOP) {
                    if (decPopVals == null) {
                        msg = "id_cmc_decryptedPOP contains invalid DecryptedPOP";
                        logger.error(method + (String)msg);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                        auditor.log(auditMessage);
                        SEQUENCE bpids = this.getRequestBpids(reqSeq);
                        context.put((Object)"decryptedPOP", (Object)bpids);
                        throw new ECMCPopFailedException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                    }
                    if (!id_cmc_regInfo) {
                        msg = "id_cmc_decryptedPOP must be accompanied by id_cmc_regInfo for request id per server/client agreement";
                        logger.error(method + (String)msg);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                        auditor.log(auditMessage);
                        SEQUENCE bpids = this.getRequestBpids(reqSeq);
                        context.put((Object)"decryptedPOP", (Object)bpids);
                        throw new ECMCPopFailedException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                    }
                    OCTET_STRING reqIdOS = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)reqIdVals.elementAt(0)));
                    DecryptedPOP decPop = (DecryptedPOP)ASN1Util.decode((ASN1Template)DecryptedPOP.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)decPopVals.elementAt(0)));
                    logger.error(method + "DecryptedPOP encoded");
                    BigInteger reqId = this.verifyDecryptedPOP(locale, decPop, reqIdOS);
                    if (reqId == null) {
                        msg = "DecryptedPOP failed to verify";
                        logger.error(method + (String)msg);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                        auditor.log(auditMessage);
                        SEQUENCE bpids = this.getRequestBpids(reqSeq);
                        context.put((Object)"decryptedPOP", (Object)bpids);
                        throw new ECMCPopFailedException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                    }
                    context.put((Object)"cmcDecryptedPopReqId", (Object)reqId);
                    return null;
                }
                if (id_cmc_idPOPLinkRandom && vals != null) {
                    OCTET_STRING ostr = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
                    randomSeed = ostr.toByteArray();
                    logger.debug(method + "got randomSeed");
                }
            }
            SEQUENCE otherMsgSeq = pkiData.getOtherMsgSequence();
            int numOtherMsgs = otherMsgSeq.size();
            if (!context.containsKey((Object)"numOfOtherMsgs")) {
                logger.debug(method + "found numOfOtherMsgs: " + numOtherMsgs);
                context.put((Object)"numOfOtherMsgs", (Object)numOtherMsgs);
                for (int i = 0; i < numOtherMsgs; ++i) {
                    OtherMsg omsg = (OtherMsg)ASN1Util.decode((ASN1Template)OtherMsg.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)otherMsgSeq.elementAt(i)));
                    context.put((Object)("otherMsg" + i), (Object)omsg);
                }
            }
            boolean popLinkWitnessRequired = false;
            try {
                String configName = "cmc.popLinkWitnessRequired";
                logger.debug(method + "getting :" + configName);
                popLinkWitnessRequired = cs.getBoolean(configName, false);
                if (popLinkWitnessRequired) {
                    logger.debug(method + "popLinkWitness(V2) required");
                } else {
                    logger.debug(method + "popLinkWitness(V2) not required");
                }
            }
            catch (Exception e) {
                msg = " Failed to retrieve cmc.popLinkWitnessRequired: " + e.getMessage();
                logger.error(method + (String)msg, (Throwable)e);
                throw new EProfileException((String)msg, (Throwable)e);
            }
            int nummsgs = reqSeq.size();
            if (nummsgs <= 0) {
                logger.debug(method + "nummsgs 0; returning...");
                return null;
            }
            logger.debug(method + "nummsgs =" + nummsgs);
            msgs = new TaggedRequest[reqSeq.size()];
            SEQUENCE bpids = new SEQUENCE();
            boolean valid = true;
            int i = 0;
            while (true) {
                if (i >= nummsgs) {
                    logger.debug(method + "ends");
                    return msgs;
                }
                msgs[i] = (TaggedRequest)reqSeq.elementAt(i);
                if (!id_cmc_revokeRequest) {
                    CertReqMsg crm;
                    boolean hasPop = true;
                    if (msgs[i].getType().equals(TaggedRequest.CRMF) && !(crm = msgs[i].getCrm()).hasPop()) {
                        hasPop = false;
                    }
                    if (popLinkWitnessRequired && hasPop && !context.containsKey((Object)"POPLinkWitnessV2") && !context.containsKey((Object)"POPLinkWitness")) {
                        logger.debug(method + "popLinkWitness(V2) required");
                        if (randomSeed == null || ident_s == null) {
                            msg = "missing needed randomSeed or identification for popLinkWitness(V2)";
                            logger.error(method + (String)msg);
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_ID_POP_LINK_WITNESS_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                            auditor.log(auditMessage);
                            context.put((Object)"POPLinkWitnessV2", (Object)bpids);
                            throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_LINK_WITNESS_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                        }
                        valid = this.verifyPOPLinkWitness(ident_s, randomSeed, msgs[i], bpids, context, pkiData);
                        if (valid) {
                            msg = ": ident_s=" + ident_s;
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_ID_POP_LINK_WITNESS_3", (Object[])new Object[]{auditSubjectID, "Success", method + (String)msg});
                            auditor.log(auditMessage);
                        } else {
                            msg = context.containsKey((Object)"POPLinkWitnessV2") ? " in POPLinkWitnessV2" : (context.containsKey((Object)"POPLinkWitness") ? " in POPLinkWitness" : " failure from verifyPOPLinkWitness");
                            msg = (String)msg + ": ident_s=" + ident_s;
                            logger.error(method + (String)msg);
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_ID_POP_LINK_WITNESS_3", (Object[])new Object[]{auditSubjectID, "Failure", method + (String)msg});
                            auditor.log(auditMessage);
                            throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_LINK_WITNESS_VERIFICATION_ERROR", (String[])new String[0]) + ":" + (String)msg);
                        }
                    }
                }
                ++i;
            }
        }
        catch (ECMCBadMessageCheckException e) {
            throw new ECMCBadMessageCheckException((Throwable)e);
        }
        catch (ECMCBadIdentityException e) {
            throw new ECMCBadIdentityException((Throwable)e);
        }
        catch (ECMCPopFailedException e) {
            throw new ECMCPopFailedException((Throwable)e);
        }
        catch (ECMCBadRequestException e) {
            throw new ECMCBadRequestException((Throwable)e);
        }
        catch (EProfileException e) {
            throw new EProfileException((Throwable)e);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    private BigInteger verifyDecryptedPOP(Locale locale, DecryptedPOP decPop, OCTET_STRING reqIdOS) throws EProfileException, ECMCPopFailedException {
        String method = "EnrollProfile: verifyDecryptedPOP: ";
        logger.debug(method + "begins");
        Object msg = "";
        if (decPop == null || reqIdOS == null) {
            logger.warn(method + "method parameters cannot be null");
            return null;
        }
        byte[] reqIdBA = reqIdOS.toByteArray();
        BigInteger reqIdBI = new BigInteger(reqIdBA);
        OCTET_STRING witness_os = decPop.getWitness();
        CAEngine engine = CAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        Request req = null;
        try {
            req = requestRepository.readRequest(new RequestId(reqIdBI));
        }
        catch (Exception e) {
            msg = method + "after findRequest: " + e.getMessage();
            logger.warn((String)msg, (Throwable)e);
            return null;
        }
        byte[] pop_encryptedData = req.getExtDataInByteArray("pop_encryptedData");
        if (pop_encryptedData == null) {
            msg = method + "pop_encryptedData not found in request:" + reqIdBI.toString();
            logger.warn((String)msg);
            return null;
        }
        byte[] pop_sysPubEncryptedSession = req.getExtDataInByteArray("pop_sysPubEncryptedSession");
        if (pop_sysPubEncryptedSession == null) {
            msg = method + "pop_sysPubEncryptedSession not found in request:" + reqIdBI.toString();
            logger.warn((String)msg);
            return null;
        }
        byte[] cmc_msg = req.getExtDataInByteArray("cert_request");
        if (cmc_msg == null) {
            msg = method + "cmc_msg not found in request:" + reqIdBI.toString();
            logger.warn((String)msg);
            return null;
        }
        CAEngineConfig cs = engine.getConfig();
        PrivateKey issuanceProtPrivKey = engine.getIssuanceProtectionPrivateKey();
        if (issuanceProtPrivKey == null) {
            msg = method + "issuanceProtPrivKey null";
            logger.warn((String)msg);
            return null;
        }
        logger.debug(method + "issuanceProtPrivKey not null");
        try {
            SymmetricKey symKey;
            CryptoToken token = null;
            String tokenName = cs.getString("cmc.token", "internal");
            token = CryptoUtil.getKeyStorageToken((String)tokenName);
            KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
            boolean useOAEP = cs.getUseOAEPKeyWrap();
            if (useOAEP) {
                wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            if ((symKey = CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)SymmetricKey.AES, (int)128, (SymmetricKey.Usage)SymmetricKey.Usage.DECRYPT, (PrivateKey)issuanceProtPrivKey, (byte[])pop_sysPubEncryptedSession, (KeyWrapAlgorithm)wrapAlg)) == null) {
                msg = "symKey null after CryptoUtil.unwrap returned";
                logger.warn((String)msg);
                return null;
            }
            byte[] iv = req.getExtDataInByteArray("pop_encryptedDataIV");
            IVParameterSpec ivps = new IVParameterSpec(iv);
            byte[] challenge_b = CryptoUtil.decryptUsingSymmetricKey((CryptoToken)token, (IVParameterSpec)ivps, (byte[])pop_encryptedData, (SymmetricKey)symKey, (EncryptionAlgorithm)EncryptionAlgorithm.AES_128_CBC);
            if (challenge_b == null) {
                msg = method + "challenge_b null after decryptUsingSymmetricKey returned";
                logger.warn((String)msg);
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance(CryptoUtil.getDefaultHashAlgName());
            if (digest == null) {
                msg = method + "digest null after decryptUsingSymmetricKey returned";
                logger.warn((String)msg);
                return null;
            }
            String hmacAlgName = CryptoUtil.getHMACAlgName((String)(CryptoUtil.getDefaultHashAlgName() + "-HMAC"));
            Mac hmac = Mac.getInstance(hmacAlgName, "Mozilla-JSS");
            Key secKey = CryptoUtil.importHmacSha1Key((byte[])challenge_b);
            hmac.init(secKey);
            hmac.update(cmc_msg);
            byte[] proofValue = hmac.doFinal();
            if (proofValue == null) {
                msg = method + "proofValue null after hmacDigest.digest returned";
                logger.warn((String)msg);
                return null;
            }
            boolean witnessChecked = Arrays.equals(proofValue, witness_os.toByteArray());
            if (!witnessChecked) {
                msg = method + "POP challenge witness verification failure";
                logger.warn((String)msg);
                return null;
            }
        }
        catch (Exception e) {
            msg = e.getMessage();
            logger.error(method + (String)msg, (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + e);
        }
        logger.debug(method + "POP challenge verified!");
        req.setExtData("cmc_POPchallengeRequired", "false");
        logger.debug(method + "cmc_POPchallengeRequired set back to false");
        logger.debug(method + "ends");
        return reqIdBI;
    }

    protected PopLinkWitnessV2 getPopLinkWitnessV2control(ASN1Value value) {
        String method = "EnrollProfile: getPopLinkWitnessV2control: ";
        ByteArrayInputStream bis = new ByteArrayInputStream(ASN1Util.encode((ASN1Value)value));
        PopLinkWitnessV2 popLinkWitnessV2 = null;
        try {
            popLinkWitnessV2 = (PopLinkWitnessV2)new PopLinkWitnessV2.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        return popLinkWitnessV2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean verifyPopLinkWitnessV2(PopLinkWitnessV2 popLinkWitnessV2, byte[] randomSeed, byte[] sharedSecret, String ident_string) {
        boolean bl;
        block15: {
            String method = "EnrollProfile: verifyPopLinkWitnessV2: ";
            if (popLinkWitnessV2 == null || randomSeed == null || sharedSecret == null) {
                logger.warn(method + " method parameters cannot be null");
                return false;
            }
            AlgorithmIdentifier keyGenAlg = popLinkWitnessV2.getKeyGenAlgorithm();
            AlgorithmIdentifier macAlg = popLinkWitnessV2.getMacAlgorithm();
            OCTET_STRING witness = popLinkWitnessV2.getWitness();
            if (keyGenAlg == null) {
                logger.warn(method + " keyGenAlg reurned by popLinkWitnessV2.getWitness is null");
                return false;
            }
            if (macAlg == null) {
                logger.warn(method + " macAlg reurned by popLinkWitnessV2.getWitness is null");
                return false;
            }
            if (witness == null) {
                logger.warn(method + " witness reurned by popLinkWitnessV2.getWitness is null");
                return false;
            }
            byte[] verifyBytes = null;
            try {
                DigestAlgorithm keyGenAlgID = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)keyGenAlg.getOID());
                MessageDigest keyGenMDAlg = MessageDigest.getInstance(keyGenAlgID.toString());
                HMACAlgorithm macAlgID = HMACAlgorithm.fromOID((OBJECT_IDENTIFIER)macAlg.getOID());
                MessageDigest macMDAlg = MessageDigest.getInstance(CryptoUtil.getHMACtoMessageDigestName((String)macAlgID.toString()));
                byte[] witness_bytes = witness.toByteArray();
                ByteBuffer bb = null;
                if (ident_string == null) {
                    verifyBytes = sharedSecret;
                } else {
                    bb = ByteBuffer.allocate(ident_string.getBytes().length + sharedSecret.length);
                    bb.put(sharedSecret);
                    bb.put(ident_string.getBytes());
                    verifyBytes = bb.array();
                }
                boolean result = this.verifyDigest(verifyBytes, randomSeed, witness_bytes, keyGenMDAlg, macMDAlg);
                if (ident_string != null) {
                    CryptoUtil.obscureBytes((byte[])verifyBytes, (String)"random");
                }
                bl = result;
                if (ident_string == null) break block15;
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn(method + e.getMessage(), (Throwable)e);
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception e2) {
                logger.warn(method + e2.getMessage(), (Throwable)e2);
                boolean bl3 = false;
                return bl3;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (ident_string != null) {
                    CryptoUtil.obscureBytes(verifyBytes, (String)"random");
                }
            }
            CryptoUtil.obscureBytes((byte[])verifyBytes, (String)"random");
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private boolean verifyPOPLinkWitness(UTF8String ident, byte[] randomSeed, TaggedRequest req, SEQUENCE bpids, SessionContext context, PKIData pkiData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean verifyDigest(byte[] sharedSecret, byte[] text, byte[] bv) {
        MessageDigest hashAlg;
        try {
            hashAlg = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn("EnrollProfile:verifyDigest: " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return this.verifyDigest(sharedSecret, text, bv, hashAlg, hashAlg);
    }

    private boolean verifyDigest(byte[] sharedSecret, byte[] text, byte[] bv, MessageDigest hashAlg, MessageDigest macAlg) {
        String method = "EnrollProfile:verifyDigest: ";
        byte[] key = null;
        logger.debug(method + "in verifyDigest: hashAlg=" + hashAlg.toString() + "; macAlg=" + macAlg.toString());
        if (sharedSecret == null || text == null || bv == null || hashAlg == null || macAlg == null) {
            logger.warn(method + "method parameters cannot be null");
            return false;
        }
        key = hashAlg.digest(sharedSecret);
        byte[] finalDigest = null;
        try {
            Mac hmac = Mac.getInstance(CryptoUtil.getHMACAlgName((String)(macAlg.getAlgorithm() + "-HMAC")), "Mozilla-JSS");
            Key secKey = CryptoUtil.importHmacSha1Key((byte[])key);
            hmac.init(secKey);
            hmac.update(text);
            finalDigest = hmac.doFinal();
        }
        catch (Exception e) {
            logger.debug(method + "hmac exception: " + e);
            finalDigest = null;
        }
        if (finalDigest.length != bv.length) {
            logger.warn(method + " The length of two HMAC digest are not the same.");
            return false;
        }
        for (int j = 0; j < bv.length; ++j) {
            if (bv[j] == finalDigest[j]) continue;
            logger.warn(method + " The content of two HMAC digest are not the same.");
            return false;
        }
        logger.info(method + " The content of two HMAC digest are the same.");
        return true;
    }

    private SEQUENCE getRequestBpids(SEQUENCE reqSeq) {
        SEQUENCE bpids = new SEQUENCE();
        for (int i = 0; i < reqSeq.size(); ++i) {
            TaggedRequest req = (TaggedRequest)reqSeq.elementAt(i);
            if (req.getType().equals(TaggedRequest.PKCS10)) {
                TaggedCertificationRequest tcr = req.getTcr();
                bpids.addElement((ASN1Value)tcr.getBodyPartID());
                continue;
            }
            if (!req.getType().equals(TaggedRequest.CRMF)) continue;
            CertReqMsg crm = req.getCrm();
            CertRequest request = crm.getCertReq();
            bpids.addElement((ASN1Value)request.getCertReqId());
        }
        return bpids;
    }

    private boolean verifyIdentityProofV2(SessionContext sessionContext, TaggedAttribute attr, UTF8String ident, SEQUENCE reqSeq, PKIData pkiData) {
        String method = "EnrollProfile:verifyIdentityProofV2: ";
        String msg = "";
        logger.debug(method + " begins");
        boolean verified = false;
        if (attr == null || ident == null || reqSeq == null) {
            logger.warn(method + "method parameters cannot be null");
            return false;
        }
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = method;
        String ident_string = ident.toString();
        String auditAttemptedCred = null;
        SET vals = attr.getValues();
        if (vals.size() < 1) {
            msg = " invalid TaggedAttribute in request";
            logger.warn(method + msg);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditAttemptedCred, "Failure", method + msg});
            auditor.log(auditMessage);
            return false;
        }
        try {
            String configName = "SharedToken";
            AuthSubsystem authSS = engine.getAuthSubsystem();
            AuthManager sharedTokenAuth = authSS.getAuthManager(configName);
            if (sharedTokenAuth == null) {
                msg = " Failed to retrieve shared secret authentication plugin class";
                logger.warn(method + msg);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditAttemptedCred, "Failure", method + msg});
                auditor.log(auditMessage);
                return false;
            }
            AuthToken authToken = (AuthToken)sessionContext.get((Object)"AuthToken");
            ISharedToken tokenClass = (ISharedToken)sharedTokenAuth;
            char[] token = null;
            if (ident_string == null) {
                token = tokenClass.getSharedToken(pkiData);
            } else {
                auditAttemptedCred = ident_string;
                token = tokenClass.getSharedToken(ident_string, authToken);
            }
            if (token == null) {
                msg = " Failed to retrieve shared secret";
                logger.warn(method + msg);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditAttemptedCred, "Failure", method + msg});
                auditor.log(auditMessage);
                return false;
            }
            IdentityProofV2 idV2val = (IdentityProofV2)ASN1Util.decode((ASN1Template)IdentityProofV2.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
            DigestAlgorithm hashAlgID = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)idV2val.getHashAlgID().getOID());
            MessageDigest hashAlg = MessageDigest.getInstance(hashAlgID.toString());
            HMACAlgorithm macAlgId = HMACAlgorithm.fromOID((OBJECT_IDENTIFIER)idV2val.getMacAlgId().getOID());
            MessageDigest macAlg = MessageDigest.getInstance(CryptoUtil.getHMACtoMessageDigestName((String)macAlgId.toString()));
            OCTET_STRING witness = idV2val.getWitness();
            if (witness == null) {
                msg = " witness reurned by idV2val.getWitness is null";
                logger.error(method + msg);
                throw new EBaseException(msg);
            }
            byte[] witness_bytes = witness.toByteArray();
            byte[] request_bytes = ASN1Util.encode((ASN1Value)reqSeq);
            byte[] verifyBytes = null;
            ByteBuffer bb = null;
            byte[] tokenBytes = CryptoUtil.charsToBytes((char[])token);
            if (ident_string == null) {
                verifyBytes = tokenBytes;
            } else {
                bb = ByteBuffer.allocate(ident_string.getBytes().length + token.length);
                bb.put(tokenBytes);
                bb.put(ident_string.getBytes());
                verifyBytes = bb.array();
            }
            verified = this.verifyDigest(verifyBytes, request_bytes, witness_bytes, hashAlg, macAlg);
            String auditSubjectID = null;
            if (ident_string != null) {
                CryptoUtil.obscureBytes((byte[])verifyBytes, (String)"random");
            }
            CryptoUtil.obscureChars((char[])token);
            if (!verified) {
                msg = "IdentityProofV2 failed to verify";
                logger.error(method + msg);
                throw new EBaseException(msg);
            }
            auditSubjectID = (String)sessionContext.get((Object)"userid");
            logger.debug(method + "current auditSubjectID was:" + auditSubjectID);
            logger.debug(method + "identity verified. Updating auditSubjectID");
            logger.debug(method + "updated auditSubjectID is:" + ident_string);
            auditSubjectID = ident_string;
            sessionContext.put((Object)"userid", (Object)auditSubjectID);
            authToken.set("tokenSharedTokenAuthenticatedCertSubject", authToken.getInString("tokenCertSubject"));
            authToken.set("tokenAuthenticatedCertSubject", authToken.getInString("tokenCertSubject"));
            sessionContext.put((Object)"tokenSharedTokenAuthenticatedCertSubject", (Object)authToken.getInString("tokenCertSubject"));
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditSubjectID, "Success", "method=" + method});
            auditor.log(auditMessage);
            return verified;
        }
        catch (Exception e) {
            logger.error(method + " Failed with Exception: " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_PROOF_OF_IDENTIFICATION_3", (Object[])new Object[]{auditAttemptedCred, "Failure", method + e.toString()});
            auditor.log(auditMessage);
            return false;
        }
    }

    private boolean verifyIdentityProof(TaggedAttribute attr, SEQUENCE reqSeq, PKIData pkiData) {
        String method = "verifyIdentityProof: ";
        boolean verified = false;
        SET vals = attr.getValues();
        if (vals.size() < 1) {
            return false;
        }
        CAEngine engine = CAEngine.getInstance();
        ISharedToken tokenClass = engine.createSharedTokenPlugin();
        if (tokenClass == null) {
            logger.warn(method + " Failed to retrieve shared secret authentication plugin class");
            return false;
        }
        OCTET_STRING ostr = null;
        char[] token = null;
        try {
            token = tokenClass.getSharedToken(pkiData);
            ostr = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
        }
        catch (InvalidBERException e) {
            logger.warn(method + "Failed to decode the byte value: " + e.getMessage(), (Throwable)e);
            CryptoUtil.obscureChars((char[])token);
            return false;
        }
        catch (Exception e) {
            logger.warn(method + "exception: " + e.getMessage(), (Throwable)e);
            return false;
        }
        byte[] b = ostr.toByteArray();
        byte[] text = ASN1Util.encode((ASN1Value)reqSeq);
        byte[] verifyBytes = CryptoUtil.charsToBytes((char[])token);
        verified = this.verifyDigest(verifyBytes, text, b);
        if (verified) {
            // empty if block
        }
        CryptoUtil.obscureBytes((byte[])verifyBytes, (String)"random");
        CryptoUtil.obscureChars((char[])token);
        return verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillTaggedRequest(Locale locale, TaggedRequest tagreq, X509CertInfo info, Request req) throws EProfileException, ECMCPopFailedException, ECMCBadRequestException {
        CertReqMsg crm;
        block24: {
            String methodPos;
            block26: {
                block27: {
                    TaggedRequest.Type type;
                    String method;
                    CAEngineConfig cs;
                    block25: {
                        String methodPos2;
                        block23: {
                            CAEngine engine = CAEngine.getInstance();
                            cs = engine.getConfig();
                            Auditor auditor = engine.getAuditor();
                            String auditMessage = null;
                            String auditSubjectID = this.auditSubjectID();
                            method = "EnrollProfile: fillTaggedRequest: ";
                            logger.debug(method + "begins");
                            type = tagreq.getType();
                            if (type == null) {
                                logger.error(method + "TaggedRequest type == null");
                                throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]) + "TaggedRequest type null");
                            }
                            if (!type.equals(TaggedRequest.PKCS10)) break block25;
                            methodPos2 = method + "PKCS10: ";
                            logger.debug(methodPos2 + " TaggedRequest type == pkcs10");
                            boolean sigver = true;
                            boolean tokenSwitched = false;
                            CryptoManager cm = null;
                            CryptoToken signToken = null;
                            CryptoToken savedToken = null;
                            try {
                                sigver = cs.getBoolean("ca.requestVerify.enabled", true);
                                cm = CryptoManager.getInstance();
                                if (sigver) {
                                    logger.debug(methodPos2 + "sigver true, POP is to be verified");
                                    String tokenName = cs.getString("ca.requestVerify.token", "internal");
                                    savedToken = cm.getThreadToken();
                                    signToken = CryptoUtil.getCryptoToken((String)tokenName);
                                    if (!savedToken.getName().equals(signToken.getName())) {
                                        cm.setThreadToken(signToken);
                                        tokenSwitched = true;
                                    }
                                } else {
                                    logger.debug(methodPos2 + "sigver false, POP is not to be verified now, but instead will be challenged");
                                    req.setExtData("cmc_POPchallengeRequired", "true");
                                }
                                TaggedCertificationRequest tcr = tagreq.getTcr();
                                CertificationRequest p10 = tcr.getCertificationRequest();
                                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                                p10.encode((OutputStream)ostream);
                                PKCS10 pkcs10 = new PKCS10(ostream.toByteArray(), sigver);
                                if (sigver) {
                                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Success", "method=" + method});
                                    auditor.log(auditMessage);
                                }
                                req.setExtData("bodyPartId", (BigInteger)tcr.getBodyPartID());
                                this.fillPKCS10(locale, pkcs10, info, req);
                                if (!sigver || !tokenSwitched) break block23;
                            }
                            catch (Exception e) {
                                logger.warn(method + e.getMessage(), (Throwable)e);
                                if (sigver) {
                                    this.popFailed(locale, auditSubjectID, auditMessage, e);
                                }
                                break block23;
                            }
                            cm.setThreadToken(savedToken);
                            break block23;
                            finally {
                                if (sigver && tokenSwitched) {
                                    cm.setThreadToken(savedToken);
                                }
                            }
                        }
                        logger.debug(methodPos2 + "done");
                        return;
                    }
                    if (!type.equals(TaggedRequest.CRMF)) {
                        logger.error(method + " unsupported type (not CRMF or PKCS10)");
                        throw new ECMCBadRequestException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]));
                    }
                    methodPos = method + "CRMF: ";
                    logger.debug(methodPos + " TaggedRequest type == crmf");
                    crm = tagreq.getCrm();
                    SessionContext context = SessionContext.getContext();
                    Integer nums = (Integer)context.get((Object)"numOfControls");
                    String configName = "cmc.lraPopWitness.verify.allow";
                    boolean verifyAllow = false;
                    try {
                        verifyAllow = cs.getBoolean(configName, false);
                    }
                    catch (Exception e) {
                        throw new EProfileException("Unable to get " + configName + ": " + e.getMessage(), (Throwable)e);
                    }
                    logger.debug("EnrollProfile: verify allow: " + verifyAllow);
                    if (!verifyAllow) break block26;
                    if (nums == null || nums <= 0) break block27;
                    TaggedAttribute attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_lraPOPWitness);
                    if (attr == null) {
                        logger.debug(methodPos + " verify POP in CMC because LRA POP Witness control attribute doesnt exist in the CMC request.");
                        if (crm.hasPop()) {
                            logger.debug(methodPos + " hasPop true");
                            this.verifyPOP(locale, crm);
                            break block24;
                        } else {
                            logger.debug(methodPos + "hasPop false, need to challenge");
                            req.setExtData("cmc_POPchallengeRequired", "true");
                        }
                        break block24;
                    } else {
                        this.parseLRAPopWitness(locale, crm, attr);
                    }
                    break block24;
                }
                logger.debug(methodPos + " verify POP in CMC because LRA POP Witness control attribute doesnt exist in the CMC request.");
                if (crm.hasPop()) {
                    logger.debug(methodPos + " hasPop true");
                    this.verifyPOP(locale, crm);
                    break block24;
                } else {
                    logger.debug(methodPos + "hasPop false, need to challenge");
                    req.setExtData("cmc_POPchallengeRequired", "true");
                }
                break block24;
            }
            if (crm.hasPop()) {
                logger.debug(methodPos + " hasPop true");
                this.verifyPOP(locale, crm);
            } else {
                logger.debug(methodPos + "hasPop false, need to challenge");
                req.setExtData("cmc_POPchallengeRequired", "true");
            }
        }
        this.fillCertReqMsg(locale, crm, info, req);
    }

    private void parseLRAPopWitness(Locale locale, CertReqMsg crm, TaggedAttribute attr) throws EProfileException {
        SET vals = attr.getValues();
        boolean donePOP = false;
        INTEGER reqId = null;
        if (vals.size() > 0) {
            LraPopWitness lraPop = null;
            try {
                lraPop = (LraPopWitness)ASN1Util.decode((ASN1Template)LraPopWitness.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
            }
            catch (InvalidBERException e) {
                logger.error("Unable to parse LRA POP Witness: " + e.getMessage(), (Throwable)e);
                throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENCODING_ERROR", (String[])new String[0]), (Throwable)e);
            }
            SEQUENCE bodyIds = lraPop.getBodyIds();
            reqId = crm.getCertReq().getCertReqId();
            for (int i = 0; i < bodyIds.size(); ++i) {
                INTEGER num = (INTEGER)bodyIds.elementAt(i);
                if (!num.toString().equals(reqId.toString())) continue;
                donePOP = true;
                logger.debug("EnrollProfile: skip POP for request: " + reqId + " because LRA POP Witness control is found.");
                break;
            }
        }
        if (!donePOP) {
            logger.debug("EnrollProfile: not skip POP for request: " + reqId + " because this request id is not part of the body list in LRA Pop witness control.");
            this.verifyPOP(locale, crm);
        }
    }

    protected PKIArchiveOptions getPKIArchiveOptions(AVA ava) {
        ANY archVal = ava.getValue();
        ByteArrayInputStream bis = new ByteArrayInputStream(ASN1Util.encode((ASN1Value)archVal));
        PKIArchiveOptions archOpts = null;
        try {
            archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            logger.warn("EnrollProfile: getPKIArchiveOptions " + e.getMessage(), (Throwable)e);
        }
        return archOpts;
    }

    public PKIArchiveOptions toPKIArchiveOptions(byte[] options) {
        ByteArrayInputStream bis = new ByteArrayInputStream(options);
        PKIArchiveOptions archOpts = null;
        try {
            archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            logger.warn("EnrollProfile: toPKIArchiveOptions " + e.getMessage(), (Throwable)e);
        }
        return archOpts;
    }

    public byte[] toByteArray(PKIArchiveOptions options) {
        return ASN1Util.encode((ASN1Value)options);
    }

    public void fillCertReqMsg(Locale locale, CertReqMsg certReqMsg, X509CertInfo info, Request req) throws EProfileException, ECMCUnsupportedExtException {
        String method = "EnrollProfile: fillCertReqMsg: ";
        logger.debug(method + "Start parseCertReqMsg ");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CAConfig caConfig = cs.getCAConfig();
        ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
        ConnectorConfig kraConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
        try {
            CertRequest certReq = certReqMsg.getCertReq();
            req.setExtData("bodyPartId", (BigInteger)certReq.getCertReqId());
            for (int i = 0; i < certReq.numControls(); ++i) {
                AVA ava = certReq.controlAt(i);
                if (!ava.getOID().equals((Object)PKIARCHIVEOPTIONS_OID)) continue;
                PKIArchiveOptions opt = this.getPKIArchiveOptions(ava);
                req.setExtData("req_archive_options", this.toByteArray(opt));
                try {
                    String transportCert = kraConnectorConfig.getString("transportCert", "");
                    req.setExtData("req_transport_cert", transportCert);
                    continue;
                }
                catch (EBaseException ee) {
                    logger.warn("EnrollProfile: fillCertReqMsg - Exception reading transportCert: " + ee.getMessage(), (Throwable)ee);
                }
            }
            CertTemplate certTemplate = certReq.getCertTemplate();
            SubjectPublicKeyInfo spki = certTemplate.getPublicKey();
            ByteArrayOutputStream keyout = new ByteArrayOutputStream();
            spki.encode((OutputStream)keyout);
            byte[] keybytes = keyout.toByteArray();
            X509Key key = new X509Key();
            key.decode(keybytes);
            CertificateX509Key certKey = new CertificateX509Key(key);
            ByteArrayOutputStream certKeyOut = new ByteArrayOutputStream();
            certKey.encode((OutputStream)certKeyOut);
            req.setExtData("req_key", certKeyOut.toByteArray());
            if (certTemplate.getNotBefore() != null || certTemplate.getNotAfter() != null) {
                logger.debug("EnrollProfile:  requested notBefore: " + certTemplate.getNotBefore());
                logger.debug("EnrollProfile:  requested notAfter:  " + certTemplate.getNotAfter());
                logger.debug("EnrollProfile:  current CA time:     " + new Date());
                CertificateValidity certValidity = new CertificateValidity(certTemplate.getNotBefore(), certTemplate.getNotAfter());
                ByteArrayOutputStream certValidityOut = new ByteArrayOutputStream();
                certValidity.encode((OutputStream)certValidityOut);
                req.setExtData("req_validity", certValidityOut.toByteArray());
            } else {
                logger.debug("EnrollProfile:  validity not supplied");
            }
            if (certTemplate.hasSubject()) {
                Name subjectdn = certTemplate.getSubject();
                ByteArrayOutputStream subjectEncStream = new ByteArrayOutputStream();
                subjectdn.encode((OutputStream)subjectEncStream);
                byte[] subjectEnc = subjectEncStream.toByteArray();
                X500Name subject = new X500Name(subjectEnc);
                req.setExtData("req_subject_name", new CertificateSubjectName(subject));
                try {
                    String subjectCN = subject.getCommonName();
                    if (subjectCN == null) {
                        subjectCN = "";
                    }
                    req.setExtData("req_subject_name.cn", subjectCN);
                }
                catch (Exception ee) {
                    req.setExtData("req_subject_name.cn", "");
                }
                try {
                    String subjectUID = subject.getUserID();
                    if (subjectUID == null) {
                        subjectUID = "";
                    }
                    req.setExtData("req_subject_name.uid", subjectUID);
                }
                catch (Exception ee) {
                    req.setExtData("req_subject_name.uid", "");
                }
            }
            CertificateExtensions extensions = null;
            extensions = req.getExtDataInCertExts("req_extensions");
            if (certTemplate.hasExtensions()) {
                if (extensions == null) {
                    extensions = new CertificateExtensions();
                }
                int numexts = certTemplate.numExtensions();
                OBJECT_IDENTIFIER SKIoid = new OBJECT_IDENTIFIER(PKIXExtensions.SubjectKey_Id.toString());
                for (int j = 0; j < numexts; ++j) {
                    org.mozilla.jss.pkix.cert.Extension jssext = certTemplate.extensionAt(j);
                    boolean isCritical = jssext.getCritical();
                    OBJECT_IDENTIFIER jssoid = jssext.getExtnId();
                    logger.debug(method + "found extension:" + jssoid.toString());
                    long[] numbers = jssoid.getNumbers();
                    int[] oidNumbers = new int[numbers.length];
                    for (int k = numbers.length - 1; k >= 0; --k) {
                        oidNumbers[k] = (int)numbers[k];
                    }
                    ObjectIdentifier oid = new ObjectIdentifier(oidNumbers);
                    OCTET_STRING jssvalue = jssext.getExtnValue();
                    ByteArrayOutputStream jssvalueout = new ByteArrayOutputStream();
                    jssvalue.encode((OutputStream)jssvalueout);
                    byte[] extValue = jssvalueout.toByteArray();
                    Extension ext = null;
                    if (jssoid.equals((Object)SKIoid)) {
                        logger.debug(method + "found SUBJECT_KEY_IDENTIFIER extension");
                        ext = new SubjectKeyIdentifierExtension(false, jssext.getExtnValue().toByteArray());
                    } else {
                        ext = new Extension(oid, isCritical, extValue);
                    }
                    extensions.parseExtension(ext);
                }
                req.setExtData("req_extensions", extensions);
            }
        }
        catch (IOException e) {
            logger.error("Unable to fill certificate request message: " + e.getMessage(), (Throwable)e);
            throw new ECMCUnsupportedExtException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error("Unable to fill certificate request message: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public void fillPKCS10(Locale locale, PKCS10 pkcs10, X509CertInfo info, Request req) throws EProfileException, ECMCUnsupportedExtException {
        logger.info("EnrollProfile: Processing PKCS #10 request:");
        X509Key key = pkcs10.getSubjectPublicKeyInfo();
        logger.info("EnrollProfile: - key algorithm: " + key.getAlgorithm());
        try {
            String subjectUID;
            String subjectCN;
            CertificateX509Key certKey = new CertificateX509Key(key);
            ByteArrayOutputStream certKeyOut = new ByteArrayOutputStream();
            certKey.encode((OutputStream)certKeyOut);
            req.setExtData("req_key", certKeyOut.toByteArray());
            X500Name subjectName = pkcs10.getSubjectName();
            logger.info("EnrollProfile: - subject: " + subjectName);
            req.setExtData("req_subject_name", new CertificateSubjectName(subjectName));
            try {
                subjectCN = subjectName.getCommonName();
                if (subjectCN == null) {
                    subjectCN = "";
                }
            }
            catch (Exception e) {
                subjectCN = "";
            }
            logger.info("EnrollProfile: - subject CN: " + subjectCN);
            req.setExtData("req_subject_name.cn", subjectCN);
            try {
                subjectUID = subjectName.getUserID();
                if (subjectUID == "") {
                    subjectUID = "";
                }
            }
            catch (Exception e) {
                subjectUID = "";
            }
            logger.info("EnrollProfile: - subject UID: " + subjectUID);
            req.setExtData("req_subject_name.uid", subjectUID);
            info.set("key", (Object)certKey);
            PKCS10Attributes p10Attrs = pkcs10.getAttributes();
            if (p10Attrs != null) {
                logger.info("EnrollProfile: - attributes:");
                Enumeration e = p10Attrs.getElements();
                while (e.hasMoreElements()) {
                    PKCS10Attribute p10Attr = (PKCS10Attribute)e.nextElement();
                    logger.info("EnrollProfile:   - " + p10Attr.getAttributeId());
                }
                PKCS10Attribute p10Attr = p10Attrs.getAttribute("extensions");
                if (p10Attr != null && p10Attr.getAttributeId().equals(PKCS9Attribute.EXTENSION_REQUEST_OID)) {
                    logger.debug("EnrollProfile: - extensions:");
                    Extensions extensions = (Extensions)p10Attr.getAttributeValue();
                    Enumeration extNames = extensions.getAttributeNames();
                    while (extNames.hasMoreElements()) {
                        String name = (String)extNames.nextElement();
                        logger.info("EnrollProfile:   - " + name);
                    }
                    DerOutputStream extOut = new DerOutputStream();
                    extensions.encode((OutputStream)extOut);
                    byte[] extB = extOut.toByteArray();
                    DerInputStream extIn = new DerInputStream(extB);
                    CertificateExtensions certExts = new CertificateExtensions(extIn);
                    req.setExtData("req_extensions", certExts);
                }
            }
        }
        catch (IOException e) {
            logger.error("Unable to process PKCS #10 data: " + e.getMessage(), (Throwable)e);
            throw new ECMCUnsupportedExtException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error("Unable to process PKCS #10 data: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public void fillNSNKEY(Locale locale, String sn, String skey, X509CertInfo info, Request req) throws EProfileException {
        try {
            X509Key key = new X509Key();
            key.decode(Utils.base64decode((String)skey));
            info.set("key", (Object)new CertificateX509Key(key));
            req.setExtData("screenname", sn);
            req.setExtData("aoluid", sn);
            req.setExtData("uid", sn);
            logger.info("EnrollProfile: fillNSNKEY(): uid=" + sn);
        }
        catch (Exception e) {
            logger.error("Unable to fill NSNKEY: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public void fillNSHKEY(Locale locale, String tcuid, String skey, X509CertInfo info, Request req) throws EProfileException {
        try {
            X509Key key = new X509Key();
            key.decode(Utils.base64decode((String)skey));
            info.set("key", (Object)new CertificateX509Key(key));
            req.setExtData("tokencuid", tcuid);
            logger.info("EnrollProfile: fillNSNKEY(): tokencuid=" + tcuid);
        }
        catch (Exception e) {
            logger.error("Unable to fill NSHKEY: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public void fillKeyGen(Locale locale, DerInputStream derIn, X509CertInfo info, Request req) throws EProfileException {
        try {
            DerValue[] derSPKACContent = derIn.getSequence(3);
            AlgorithmId mAlgId = AlgorithmId.parse((DerValue)derSPKACContent[1]);
            byte[] mSignature = derSPKACContent[2].getBitString();
            byte[] mPKAC = derSPKACContent[0].toByteArray();
            derIn = new DerInputStream(mPKAC);
            DerValue[] derPKACContent = derIn.getSequence(2);
            DerValue mDerSPKI = derPKACContent[0];
            X509Key mSPKI = X509Key.parse((DerValue)derPKACContent[0]);
            DerValue mDerChallenge = derPKACContent[1];
            if (mDerChallenge.length() != 0) {
                String string = derPKACContent[1].getIA5String();
            }
            CertificateX509Key certKey = new CertificateX509Key(mSPKI);
            ByteArrayOutputStream certKeyOut = new ByteArrayOutputStream();
            certKey.encode((OutputStream)certKeyOut);
            req.setExtData("req_key", certKeyOut.toByteArray());
            info.set("key", (Object)certKey);
        }
        catch (IOException e) {
            logger.error("Unable to fill key gen: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error("Unable to fill key gen: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
        }
    }

    public Locale getLocale(Request request) {
        Locale locale = null;
        String language = request.getExtDataInString(REQUEST_LOCALE);
        if (language != null) {
            locale = new Locale(language);
        }
        return locale;
    }

    @Override
    public void populateInput(Map<String, String> ctx, Request request) throws Exception {
        super.populateInput(ctx, request);
    }

    @Override
    public void populate(Request request) throws EProfileException {
        String method = "EnrollProfile: populate: ";
        logger.debug(method + "begins");
        super.populate(request);
    }

    @Override
    public void validate(Request request) throws ERejectException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(request);
        String auditProfileID = this.auditProfileID();
        String auditCertificateSubjectName = "<null>";
        String subject = null;
        logger.debug("EnrollProfile.validate: start");
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        try {
            CertificateSubjectName sn = (CertificateSubjectName)info.get("subject");
            if (sn != null && (subject = sn.toString()) != null) {
                auditCertificateSubjectName = subject.trim();
                logger.debug("EnrollProfile.validate: cert subject name:" + auditCertificateSubjectName);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Success", auditRequesterID, auditProfileID, auditCertificateSubjectName});
            auditor.log(auditMessage);
        }
        catch (CertificateException e) {
            logger.warn("EnrollProfile: populate " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, auditProfileID, auditCertificateSubjectName});
            auditor.log(auditMessage);
        }
        catch (IOException e) {
            logger.warn("EnrollProfile: populate " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, auditProfileID, auditCertificateSubjectName});
            auditor.log(auditMessage);
        }
        super.validate(request);
        Object key = null;
        try {
            key = info.get("key");
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (key == null) {
            Locale locale = this.getLocale(request);
            throw new ERejectException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMPTY_KEY", (String[])new String[0]));
        }
        logger.debug("EnrollProfile.validate: end");
    }

    protected String auditRequesterID(Request request) {
        String id;
        String requesterID = "$Unidentified$";
        if (request != null && (id = request.getRequestId().toHexString()) != null) {
            requesterID = id.trim();
        }
        return requesterID;
    }

    protected String auditProfileID() {
        String profileID = this.getId();
        profileID = profileID == null ? "$Unidentified$" : profileID.trim();
        return profileID;
    }

    public void verifyPOP(Locale locale, CertReqMsg certReqMsg) throws EProfileException, ECMCPopFailedException {
        ProofOfPossession pop;
        ProofOfPossession.Type popType;
        String method = "EnrollProfile: verifyPOP: ";
        logger.debug(method + "for signing keys begins.");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String auditMessage = method;
        String auditSubjectID = this.auditSubjectID();
        if (!certReqMsg.hasPop()) {
            logger.debug(method + "missing pop.");
            this.popFailed(locale, auditSubjectID, auditMessage);
        }
        if ((popType = (pop = certReqMsg.getPop()).getType()) != ProofOfPossession.SIGNATURE) {
            logger.debug(method + "pop type is not ProofOfPossession.SIGNATURE.");
            this.popFailed(locale, auditSubjectID, auditMessage);
        }
        try {
            CryptoToken verifyToken = null;
            String tokenName = cs.getString("ca.requestVerify.token", "internal");
            if (CryptoUtil.isInternalToken((String)tokenName)) {
                logger.debug(method + "POP verification using internal token");
                certReqMsg.verify();
            } else {
                logger.debug(method + "POP verification using token:" + tokenName);
                verifyToken = CryptoUtil.getCryptoToken((String)tokenName);
                certReqMsg.verify(verifyToken);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Success", "method=" + method});
            auditor.log(auditMessage);
        }
        catch (Exception e) {
            logger.debug(method + "Unable to verify POP: " + e);
            this.popFailed(locale, auditSubjectID, auditMessage, e);
        }
        logger.debug(method + "done.");
    }

    private void popFailed(Locale locale, String auditSubjectID, String msg) throws EProfileException, ECMCPopFailedException {
        this.popFailed(locale, auditSubjectID, msg, null);
    }

    private void popFailed(Locale locale, String auditSubjectID, String msg, Exception e) throws EProfileException, ECMCPopFailedException {
        if (e != null) {
            msg = (String)msg + e.toString();
        }
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Failure", msg});
        auditor.log(auditMessage);
        if (e == null) {
            throw new ECMCPopFailedException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]));
        }
        throw new ECMCPopFailedException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]), (Throwable)e);
    }
}

