/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import java.util.Map;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCCertReqInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(CMCCertReqInput.class);
    public static final String VAL_CERT_REQUEST_TYPE = "cert_request_type";
    public static final String VAL_CERT_REQUEST = "cert_request";
    public EnrollProfile mEnrollProfile = null;

    public CMCCertReqInput() {
        this.addValueName(VAL_CERT_REQUEST);
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
        this.mEnrollProfile = (EnrollProfile)profile;
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_CERT_REQ_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_CERT_REQ_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        String method = "CMCCertReqInput: populate: ";
        logger.debug(method + "begins");
        String cert_request = ctx.get(VAL_CERT_REQUEST);
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        if (cert_request == null) {
            logger.error(method + "invalid certificate request");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NO_CERT_REQ", (String[])new String[0]));
        }
        PKIData pkiData = this.mEnrollProfile.getPKIDataFromCMCblob(this.getLocale(request), cert_request);
        SEQUENCE reqSeq = pkiData.getReqSequence();
        int nummsgs = reqSeq.size();
        logger.debug(method + "pkiData.getReqSequence() called; nummsgs =" + nummsgs);
        TaggedRequest[] msgs = new TaggedRequest[reqSeq.size()];
        for (int i = 0; i < nummsgs; ++i) {
            msgs[i] = (TaggedRequest)reqSeq.elementAt(i);
        }
        Integer seqNum = request.getExtDataInInteger("req_seq_num");
        if (seqNum == null) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_UNKNOWN_SEQ_NUM", (String[])new String[0]));
        }
        this.mEnrollProfile.fillTaggedRequest(this.getLocale(request), msgs[seqNum], info, request);
        request.setExtData("req_x509info", info);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_CERT_REQUEST)) {
            return new Descriptor(VAL_CERT_REQUEST, null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_CERT_REQ", (String[])new String[0]));
        }
        return null;
    }
}

