/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.selftests.ca;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.security.cert.CertificateParsingException;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;

public class CAPresence
extends SelfTest {
    public static final String PROP_CA_SUB_ID = "CaSubId";
    private String mCaSubId = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        super.initSelfTest(subsystem, instanceName, parameters);
        try {
            this.mCaSubId = this.mConfig.getString(PROP_CA_SUB_ID);
            if (this.mCaSubId == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".CaSubId"}));
                throw new EMissingSelfTestException(PROP_CA_SUB_ID);
            }
            this.mCaSubId = this.mCaSubId.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".CaSubId"}));
            throw new EMissingSelfTestException(this.mPrefix, PROP_CA_SUB_ID, null);
        }
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_CA_PRESENCE_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener logger) throws Exception {
        X509Key caPubKey;
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = (CertificateAuthority)engine.getSubsystem(this.mCaSubId);
        if (ca == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_CA_IS_NOT_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        X509CertImpl caCert = ca.getCACert();
        if (caCert == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_CA_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        try {
            caPubKey = (X509Key)caCert.get("x509.info.key.value");
        }
        catch (CertificateParsingException e) {
            this.mSelfTestSubsystem.log(logger, e.toString());
            throw e;
        }
        if (caPubKey == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_CA_IS_CORRUPT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        String logMessage = CMS.getLogMessage((String)"SELFTESTS_CA_IS_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
        this.mSelfTestSubsystem.log(logger, logMessage);
    }
}

