/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapProfile {
    public static Logger logger = LoggerFactory.getLogger(BootstrapProfile.class);
    CAEngineConfig engineConfig;
    private Vector<EnrollDefault> mDefaults = new Vector();
    private String mName = null;
    private String mID = null;
    private String mDescription = null;
    private String mProfileIDMapping = null;
    private String mProfileSetIDMapping = null;

    public BootstrapProfile(CAEngineConfig engineConfig, ConfigStore config) throws Exception {
        this.engineConfig = engineConfig;
        this.mID = config.getString("id");
        this.mName = config.getString("name");
        this.mDescription = config.getString("description");
        this.mProfileIDMapping = config.getString("profileIDMapping");
        this.mProfileSetIDMapping = config.getString("profileSetIDMapping");
        StringTokenizer st = new StringTokenizer(config.getString("list"), ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            String c = config.getString(id + ".default.class");
            try {
                EnrollDefault def = (EnrollDefault)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.init(config.getSubStore(id + ".default", ConfigStore.class), def);
                this.mDefaults.addElement(def);
            }
            catch (Exception e) {
                logger.warn("BootstrapProfile: Unable to create PolicyDefault: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void init(ConfigStore config, EnrollDefault def) throws Exception {
        try {
            def.init(this.engineConfig, config);
        }
        catch (Exception e) {
            logger.warn("BootstrapProfile: Unable to initialize PolicyDefault: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getProfileIDMapping() {
        return this.mProfileIDMapping;
    }

    public String getProfileSetIDMapping() {
        return this.mProfileSetIDMapping;
    }

    public void populate(Request request, X509CertInfo info) throws Exception {
        Enumeration<EnrollDefault> e1 = this.mDefaults.elements();
        while (e1.hasMoreElements()) {
            EnrollDefault def = e1.nextElement();
            try {
                logger.debug("BootstrapProfile: Populating cert with " + def.getClass().getName());
                def.populate(request, info);
            }
            catch (Exception e) {
                logger.error("BootstrapProfile: Unable to populate cert: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }
}

