/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRevokeRequest;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRevokeCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRevokeCLI.class);
    public CACertCLI certCLI;

    public CACertRevokeCLI(CACertCLI certCLI) {
        super("revoke", "Revoke certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Serial Number> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        StringBuilder sb = new StringBuilder();
        for (RevocationReason reason : RevocationReason.INSTANCES) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(reason);
            if (reason != RevocationReason.UNSPECIFIED) continue;
            sb.append(" (default)");
        }
        Option option = new Option(null, "reason", true, "Revocation reason: " + sb);
        option.setArgName("reason");
        this.options.addOption(option);
        option = new Option(null, "comments", true, "Comments");
        option.setArgName("comments");
        this.options.addOption(option);
        this.options.addOption(null, "ca", false, "CA signing certificate");
        this.options.addOption(null, "force", false, "Force");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Missing Serial Number.");
        }
        CertId certID = new CertId(cmdArgs[0]);
        String string = cmd.getOptionValue("reason", RevocationReason.UNSPECIFIED.toString());
        RevocationReason reason = RevocationReason.valueOf((String)string);
        if (reason == null) {
            throw new Exception("Invalid revocation reason: " + string);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certCLI.getCertClient();
        CertData certData = certClient.reviewCert(certID);
        if (!cmd.hasOption("force")) {
            if (reason == RevocationReason.CERTIFICATE_HOLD) {
                System.out.println("Placing certificate on-hold:");
            } else if (reason == RevocationReason.REMOVE_FROM_CRL) {
                System.out.println("Placing certificate off-hold:");
            } else {
                System.out.println("Revoking certificate:");
            }
            CACertCLI.printCertData(certData, false, false);
            logger.info("Nonce: " + certData.getNonce());
            System.out.print("Are you sure (Y/N)? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            if (!line.equalsIgnoreCase("Y")) {
                return;
            }
        }
        CertRevokeRequest request = new CertRevokeRequest();
        request.setReason(reason.getLabel());
        request.setComments(cmd.getOptionValue("comments"));
        request.setNonce(certData.getNonce());
        CertRequestInfo certRequestInfo = cmd.hasOption("ca") ? certClient.revokeCACert(certID, request) : certClient.revokeCert(certID, request);
        if (logger.isInfoEnabled()) {
            CACertRequestCLI.printCertRequestInfo(certRequestInfo);
        }
        if (certRequestInfo.getRequestStatus() == RequestStatus.COMPLETE) {
            if (certRequestInfo.getOperationResult().equals("error")) {
                String error = certRequestInfo.getErrorMessage();
                if (error != null) {
                    System.out.println(error);
                }
                MainCLI.printMessage("Could not revoke certificate \"" + certID.toHexString() + "\"");
            } else {
                if (reason == RevocationReason.CERTIFICATE_HOLD) {
                    MainCLI.printMessage("Placed certificate \"" + certID.toHexString() + "\" on-hold");
                } else if (reason == RevocationReason.REMOVE_FROM_CRL) {
                    MainCLI.printMessage("Placed certificate \"" + certID.toHexString() + "\" off-hold");
                } else {
                    MainCLI.printMessage("Revoked certificate \"" + certID.toHexString() + "\"");
                }
                certData = certClient.getCert(certID);
                CACertCLI.printCertData(certData, false, false);
            }
        } else {
            MainCLI.printMessage("Request \"" + certRequestInfo.getRequestID().toHexString() + "\": " + certRequestInfo.getRequestStatus());
        }
    }
}

