/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.logging.ActivityClient;
import com.netscape.certsrv.logging.ActivityCollection;
import com.netscape.certsrv.logging.ActivityData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.logging.ActivityCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ActivityFindCLI.class);
    public ActivityCLI activityCLI;

    public ActivityFindCLI(ActivityCLI activityCLI) {
        super("find", "Find activities", (CLI)activityCLI);
        this.activityCLI = activityCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ActivityClient activityClient = this.activityCLI.getActivityClient();
        ActivityCollection result = activityClient.findActivities(filter, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection activities = result.getEntries();
        boolean first = true;
        for (ActivityData activityData : activities) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            ActivityCLI.printActivity(activityData, false);
        }
        MainCLI.printMessage("Number of entries returned " + activities.size());
    }
}

