/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.logging.AuditClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.logging.AuditCLI;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFileRetrieveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuditFileRetrieveCLI.class);
    public AuditCLI auditCLI;

    public AuditFileRetrieveCLI(AuditCLI auditCLI) {
        super("file-retrieve", "Retrieve audit file", (CLI)auditCLI);
        this.auditCLI = auditCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <filename> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file.");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing audit file name.");
        }
        if (cmdArgs.length > 1) {
            throw new Exception("Too many arguments specified.");
        }
        String filename = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        if (output == null) {
            output = filename;
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuditClient auditClient = this.auditCLI.getAuditClient();
        StreamingOutput so = auditClient.getAuditFile(filename);
        try (FileOutputStream out = new FileOutputStream(output);){
            so.write((OutputStream)out);
        }
    }
}

