/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.integrals.TabulatedGaussLegendre;

public class BivariateNormalDistribution {
    private final double correlation_;
    private static final CumulativeNormalDistribution cumnorm_ = new CumulativeNormalDistribution();

    public BivariateNormalDistribution(double rho) {
        if (rho < -1.0) {
            throw new ArithmeticException("rho must be >= -1.0 (" + rho + " not allowed)");
        }
        if (rho > 1.0) {
            throw new ArithmeticException("rho must be <= 1.0 (" + rho + " not allowed)");
        }
        this.correlation_ = rho;
    }

    public double evaluate(double x, double y) {
        TabulatedGaussLegendre gaussLegendreQuad = new TabulatedGaussLegendre(20);
        if (Math.abs(this.correlation_) < 0.3) {
            gaussLegendreQuad.setOrder(6);
        } else if (Math.abs(this.correlation_) < 0.75) {
            gaussLegendreQuad.setOrder(12);
        }
        double h = -x;
        double k = -y;
        double hk = h * k;
        double BVN = 0.0;
        if (Math.abs(this.correlation_) < 0.925) {
            if (Math.abs(this.correlation_) > 0.0) {
                double asr = Math.asin(this.correlation_);
                eqn3 f = new eqn3(h, k, asr);
                BVN = gaussLegendreQuad.evaluate(f);
                BVN *= asr * 0.07957747154594767;
            }
            BVN += cumnorm_.evaluate(-h) * cumnorm_.evaluate(-k);
        } else {
            if (this.correlation_ < 0.0) {
                k *= -1.0;
                hk *= -1.0;
            }
            if (Math.abs(this.correlation_) < 1.0) {
                double Ass = (1.0 - this.correlation_) * (1.0 + this.correlation_);
                double a = Math.sqrt(Ass);
                double bs = (h - k) * (h - k);
                double c = (4.0 - hk) / 8.0;
                double d = (12.0 - hk) / 16.0;
                double asr = -(bs / Ass + hk) / 2.0;
                if (asr > -100.0) {
                    BVN = a * Math.exp(asr) * (1.0 - c * (bs - Ass) * (1.0 - d * bs / 5.0) / 3.0 + c * d * Ass * Ass / 5.0);
                }
                if (-hk < 100.0) {
                    double B = Math.sqrt(bs);
                    BVN -= Math.exp(-hk / 2.0) * 2.5066282746310007 * cumnorm_.evaluate(-B / a) * B * (1.0 - c * bs * (1.0 - d * bs / 5.0) / 3.0);
                }
                eqn6 f = new eqn6(a /= 2.0, c, d, bs, hk);
                BVN += gaussLegendreQuad.evaluate(f);
                BVN /= Math.PI * -2;
            }
            if (this.correlation_ > 0.0) {
                BVN += cumnorm_.evaluate(-Math.max(h, k));
            } else {
                BVN *= -1.0;
                if (k > h) {
                    BVN += cumnorm_.evaluate(k) - cumnorm_.evaluate(h);
                }
            }
        }
        return BVN;
    }

    private static class eqn6
    implements UnaryFunctionDouble {
        private double a_;
        private double c_;
        private double d_;
        private double bs_;
        private double hk_;

        public eqn6(double a, double c, double d, double bs, double hk) {
            this.a_ = a;
            this.c_ = c;
            this.d_ = d;
            this.bs_ = bs;
            this.hk_ = hk;
        }

        @Override
        public double evaluate(double x) {
            double xs = this.a_ * (-x + 1.0);
            xs = Math.abs(xs * xs);
            double rs = Math.sqrt(1.0 - xs);
            double asr = -(this.bs_ / xs + this.hk_) / 2.0;
            if (asr > -100.0) {
                return this.a_ * Math.exp(asr) * (Math.exp(-this.hk_ * (1.0 - rs) / (2.0 * (1.0 + rs))) / rs - (1.0 + this.c_ * xs * (1.0 + this.d_ * xs)));
            }
            return 0.0;
        }
    }

    private static class eqn3
    implements UnaryFunctionDouble {
        private double hk_;
        private double asr_;
        private double hs_;

        public eqn3(double h, double k, double asr) {
            this.hk_ = h * k;
            this.hs_ = (h * h + k * k) / 2.0;
            this.asr_ = asr;
        }

        @Override
        public double evaluate(double x) {
            double sn = Math.sin(this.asr_ * (-x + 1.0) * 0.5);
            return Math.exp((sn * this.hk_ - this.hs_) / (1.0 - sn * sn));
        }
    }
}

