/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.lease;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseException;

public class LeaseMapException
extends LeaseException {
    private static final long serialVersionUID = -4854893779678486122L;
    public Map exceptionMap;

    public LeaseMapException(String s, Map exceptionMap) {
        super(s);
        Set mapEntries = exceptionMap.entrySet();
        Iterator i = mapEntries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                throw new NullPointerException("exceptionMap contains a null key");
            }
            if (!(key instanceof Lease)) {
                throw new IllegalArgumentException("exceptionMap contains an a key which is not a Lease:" + key);
            }
            if (value == null) {
                throw new NullPointerException("exceptionMap contains a null value");
            }
            if (value instanceof Throwable) continue;
            throw new IllegalArgumentException("exceptionMap contains an a value which is not a Throwable:" + value);
        }
        this.exceptionMap = exceptionMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.exceptionMap == null) {
            throw new InvalidObjectException("exceptionMap is null");
        }
        Set mapEntries = this.exceptionMap.entrySet();
        Iterator i = mapEntries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Lease)) {
                throw new InvalidObjectException("exceptionMap contains an a key which is not a Lease:" + key);
            }
            if (value instanceof Throwable) continue;
            throw new InvalidObjectException("exceptionMap contains an a value which is not a Throwable:" + value);
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("LeaseMapException should always have data");
    }
}

