/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.arguments.Arguments;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.MoreGreeks;
import org.jquantlib.pricingengines.results.Results;
import org.jquantlib.processes.StochasticProcess;

public class OneAssetStrikedOption
extends OneAssetOption {
    private double strikeSensitivity;

    public OneAssetStrikedOption(StochasticProcess process, Payoff payoff, Exercise exercise, PricingEngine engine) {
        super(process, payoff, exercise, engine);
    }

    public double getStrikeSensitivity() {
        this.calculate();
        if (Double.isNaN(this.strikeSensitivity)) {
            throw new ArithmeticException("strike sensitivity not provided");
        }
        return this.strikeSensitivity;
    }

    @Override
    protected void setupExpired() {
        super.setupExpired();
        this.strikeSensitivity = 0.0;
    }

    @Override
    public void setupArguments(Arguments args) {
        super.setupArguments(args);
        OneAssetOptionArguments moreArgs = (OneAssetOptionArguments)args;
        moreArgs.payoff = this.payoff;
    }

    @Override
    public void fetchResults(Results results) {
        super.fetchResults(results);
        if (!MoreGreeks.class.isAssignableFrom(results.getClass())) {
            throw new ClassCastException(results.getClass().getName());
        }
        MoreGreeks moreGreeks = (MoreGreeks)results;
        this.strikeSensitivity = moreGreeks.strikeSensitivity;
    }
}

