/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Array;
import org.jquantlib.math.functions.DoubleFunction;
import org.jquantlib.util.stdlibc.Std;

public class TransformedGrid {
    protected Array grid_;
    protected Array transformedGrid_;
    protected Array dxm_;
    protected Array dxp_;
    protected Array dx_;

    public TransformedGrid(Array grid) {
        this.grid_ = new Array(grid);
        this.transformedGrid_ = new Array(grid);
        this.dxm_ = new Array(grid.size());
        this.dxp_ = new Array(grid.size());
        this.dx_ = new Array(grid.size());
        for (int i = 1; i < this.transformedGrid_.size() - 1; ++i) {
            this.dxm_.set(i, this.transformedGrid_.at(i) - this.transformedGrid_.at(i - 1));
            this.dxp_.set(i, this.transformedGrid_.at(i + 1) - this.transformedGrid_.at(i));
            this.dx_.set(i, this.dxm_.at(i) + this.dxp_.at(i));
        }
    }

    public TransformedGrid(Array grid, DoubleFunction f) {
        this.grid_ = new Array(grid);
        this.transformedGrid_ = new Array(grid);
        this.dxm_ = new Array(grid.size());
        this.dxp_ = new Array(grid.size());
        this.dx_ = new Array(grid.size());
        Std.apply(this.transformedGrid_, f);
        for (int i = 1; i < this.transformedGrid_.size() - 1; ++i) {
            this.dxm_.set(i, this.transformedGrid_.at(i) - this.transformedGrid_.at(i - 1));
            this.dxp_.set(i, this.transformedGrid_.at(i + 1) - this.transformedGrid_.at(i));
            this.dx_.set(i, this.dxm_.at(i) + this.dxp_.at(i));
        }
    }

    public Array gridArray() {
        return this.grid_;
    }

    public Array transformedGridArray() {
        return this.transformedGrid_;
    }

    public Array dxmArray() {
        return this.dxm_;
    }

    public Array dxpArray() {
        return this.dxp_;
    }

    public Array dxArray() {
        return this.dx_;
    }

    public double grid(int i) {
        return this.grid_.at(i);
    }

    public double transformedGrid(int i) {
        return this.transformedGrid_.at(i);
    }

    public double dxm(int i) {
        return this.dxm_.at(i);
    }

    public double dxp(int i) {
        return this.dxp_.at(i);
    }

    public double dx(int i) {
        return this.dx_.at(i);
    }

    public int size() {
        return this.grid_.size();
    }
}

