/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;

public class NeumannBC
implements BoundaryCondition<TridiagonalOperator> {
    private double value;
    private BoundaryCondition.Side side;

    public NeumannBC(double value, BoundaryCondition.Side side) {
        this.value = value;
        this.side = side;
    }

    @Override
    public void applyAfterApplying(Array u) {
        switch (this.side) {
            case LOWER: {
                u.set(0, u.get(1) - this.value);
                break;
            }
            case UPPER: {
                u.set(u.size() - 1, u.get(u.size() - 2) + this.value);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void applyBeforeApplying(TridiagonalOperator operator) {
        switch (this.side) {
            case LOWER: {
                operator.setFirstRow(-1.0, 1.0);
                break;
            }
            case UPPER: {
                operator.setLastRow(-1.0, 1.0);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void applyBeforeSolving(TridiagonalOperator operator, Array rhs) {
        switch (this.side) {
            case LOWER: {
                operator.setFirstRow(-1.0, 1.0);
                rhs.set(0, this.value);
                break;
            }
            case UPPER: {
                operator.setLastRow(-1.0, 1.0);
                rhs.set(rhs.size() - 1, this.value);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void applyAfterSolving(Array arrayType) {
    }

    @Override
    public void setTime(double t) {
    }
}

