/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndCriteria {
    private static final Logger logger = LoggerFactory.getLogger(EndCriteria.class);
    protected final int maxIterations_;
    protected final int maxStationaryStateIterations_;
    protected final double rootEpsilon_;
    protected final double functionEpsilon_;
    protected final double gradientNormEpsilon_;
    private CriteriaType ecType;
    private int statStateIterations;

    public EndCriteria(int maxIterations, int maxStationaryStateIterations, double rootEpsilon, double functionEpsilon, double gradientNormEpsilon) {
        this.maxIterations_ = maxIterations;
        this.rootEpsilon_ = rootEpsilon;
        this.functionEpsilon_ = functionEpsilon;
        this.maxStationaryStateIterations_ = maxStationaryStateIterations != 0 ? maxStationaryStateIterations : Math.min(maxIterations / 2, 100);
        double d = this.gradientNormEpsilon_ = Double.isNaN(gradientNormEpsilon) ? this.functionEpsilon_ : gradientNormEpsilon;
        if (this.maxStationaryStateIterations_ < 1) {
            throw new IllegalArgumentException("maxStationaryStateIterations_ must be greater than one");
        }
        if (this.maxStationaryStateIterations_ > this.maxIterations_) {
            throw new IllegalArgumentException("maxStationaryStateIterations_ must be less than maxIterations_");
        }
    }

    public boolean checkMaxIterations(int iteration, CriteriaType ecType) {
        if (iteration < this.maxIterations_) {
            return false;
        }
        this.ecType = CriteriaType.MaxIterations;
        return true;
    }

    public boolean checkStationaryPoint(double xOld, double xNew, int statStateIterations, CriteriaType ecType) {
        if (Math.abs(xNew - xOld) >= this.rootEpsilon_) {
            this.statStateIterations = 0;
            return false;
        }
        ++this.statStateIterations;
        if (statStateIterations <= this.maxStationaryStateIterations_) {
            return false;
        }
        this.ecType = CriteriaType.StationaryPoint;
        return true;
    }

    public boolean checkStationaryFunctionValue(double fxOld, double fxNew, int statStateIterations, CriteriaType ecType) {
        if (Math.abs(fxNew - fxOld) >= this.functionEpsilon_) {
            this.statStateIterations = 0;
            return false;
        }
        ++this.statStateIterations;
        if (statStateIterations <= this.maxStationaryStateIterations_) {
            return false;
        }
        this.ecType = CriteriaType.StationaryFunctionValue;
        return true;
    }

    public boolean checkStationaryFunctionAccuracy(double f, boolean positiveOptimization, CriteriaType ecType) {
        if (!positiveOptimization) {
            return false;
        }
        if (f >= this.functionEpsilon_) {
            return false;
        }
        this.ecType = CriteriaType.StationaryFunctionAccuracy;
        return true;
    }

    public boolean checkZeroGradientNorm(double gradientNorm, CriteriaType ecType) {
        if (gradientNorm >= this.gradientNormEpsilon_) {
            return false;
        }
        this.ecType = CriteriaType.ZeroGradientNorm;
        return true;
    }

    public boolean bracket_operator(int iteration, int statStateIterations, boolean positiveOptimization, double fold, double normgold, double fnew, double normgnew, CriteriaType ecType) {
        return this.checkMaxIterations(iteration, ecType) || this.checkStationaryFunctionValue(fold, fnew, statStateIterations, ecType) || this.checkStationaryFunctionAccuracy(fnew, positiveOptimization, ecType) || this.checkZeroGradientNorm(normgnew, ecType);
    }

    public final int getMaxIterations() {
        return this.maxIterations_;
    }

    public final int getMaxStationaryStateIterations() {
        return this.maxStationaryStateIterations_;
    }

    public final double getRootEpsilon() {
        return this.rootEpsilon_;
    }

    public final double getFunctionEpsilon() {
        return this.functionEpsilon_;
    }

    public final double getGradientNormEpsilon() {
        return this.gradientNormEpsilon_;
    }

    public final String toString(CriteriaType ec) {
        switch (ec) {
            case None: {
                return "None";
            }
            case MaxIterations: {
                return "MaxIterations";
            }
            case StationaryPoint: {
                return "StationaryPoint";
            }
            case StationaryFunctionValue: {
                return "StationaryFunctionValue";
            }
            case StationaryFunctionAccuracy: {
                return "StationaryFunctionAccuracy";
            }
            case ZeroGradientNorm: {
                return "ZeroGradientNorm";
            }
            case Unknown: {
                return "Unknown";
            }
        }
        throw new RuntimeException("unknown EndCriteria::Type (" + (Object)((Object)ec) + ")");
    }

    public static enum CriteriaType {
        None,
        MaxIterations,
        StationaryPoint,
        StationaryFunctionValue,
        StationaryFunctionAccuracy,
        ZeroGradientNorm,
        Unknown;

    }
}

