/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.internal;

import com.infor.core.IAdapterFactory;
import com.infor.core.IAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AdapterManager
implements IAdapterManager {
    private static final int INITIAL_ADAPTERLOOKUP_MAPSIZE = 30;
    private static final int INITIAL_COLLECTION_SIZE = 5;
    protected HashMap adapterLookup = null;
    protected HashMap classLookup;
    protected HashMap classSearchOrderLookup;
    protected final HashMap factories = new HashMap(5);

    private void addFactoriesFor(String typeName, Map table) {
        List factoryList = (List)this.factories.get(typeName);
        if (factoryList == null) {
            return;
        }
        int imax = factoryList.size();
        for (int i = 0; i < imax; ++i) {
            IAdapterFactory factory = (IAdapterFactory)factoryList.get(i);
            Class<?>[] adapters = factory.getAdapterList();
            for (int j = 0; j < adapters.length; ++j) {
                String adapterName = adapters[j].getName();
                if (table.get(adapterName) != null) continue;
                table.put(adapterName, factory);
            }
        }
    }

    private Class cachedClassForName(IAdapterFactory factory, String typeName) {
        Map classes;
        Class clazz = null;
        HashMap lookup = this.classLookup;
        if (lookup != null && (classes = (Map)lookup.get(factory)) != null) {
            clazz = (Class)classes.get(typeName);
        }
        return clazz;
    }

    private Class classForName(IAdapterFactory factory, String typeName) {
        Class clazz = this.cachedClassForName(factory, typeName);
        return clazz;
    }

    public String[] computeAdapterTypes(Class adaptable) {
        Set types = this.getFactories(adaptable).keySet();
        return types.toArray(new String[types.size()]);
    }

    private Map getFactories(Class adaptable) {
        HashMap table;
        HashMap lookup = this.adapterLookup;
        if (lookup == null) {
            this.adapterLookup = lookup = new HashMap(30);
        }
        if ((table = (HashMap)lookup.get(adaptable.getName())) == null) {
            table = new HashMap(5);
            Class[] classes = this.computeClassOrder(adaptable);
            for (int i = 0; i < classes.length; ++i) {
                this.addFactoriesFor(classes[i].getName(), table);
            }
            lookup.put(adaptable.getName(), table);
        }
        return table;
    }

    public Class[] computeClassOrder(Class adaptable) {
        ArrayList classes = null;
        HashMap lookup = this.classSearchOrderLookup;
        if (lookup != null) {
            classes = (ArrayList)lookup.get(adaptable);
        }
        if (classes == null) {
            classes = new ArrayList();
            this.computeClassOrder(adaptable, classes);
            if (lookup == null) {
                this.classSearchOrderLookup = lookup = new HashMap();
            }
            lookup.put(adaptable, classes);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private void computeClassOrder(Class adaptable, Collection classes) {
        HashSet seen = new HashSet(5);
        for (Class clazz = adaptable; clazz != null; clazz = clazz.getSuperclass()) {
            classes.add(clazz);
            this.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
        }
    }

    private void computeInterfaceOrder(Class[] interfaces, Collection classes, Set seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            Class interfac = interfaces[i];
            if (!seen.add(interfac)) continue;
            classes.add(interfac);
            newInterfaces.add(interfac);
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), classes, seen);
        }
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    public Object getAdapter(Object adaptable, Class adapterType) {
        IAdapterFactory factory = (IAdapterFactory)this.getFactories(adaptable.getClass()).get(adapterType.getName());
        Object result = null;
        if (factory != null) {
            result = factory.getAdapter(adaptable, adapterType);
        }
        if (result == null && adapterType.isInstance(adaptable)) {
            return adaptable;
        }
        return result;
    }

    public Object getAdapter(Object adaptable, String adapterType) {
        Class clazz;
        IAdapterFactory factory = (IAdapterFactory)this.getFactories(adaptable.getClass()).get(adapterType);
        Object result = null;
        if (factory != null && (clazz = this.classForName(factory, adapterType)) != null) {
            result = factory.getAdapter(adaptable, clazz);
        }
        if (result == null && adaptable.getClass().getName().equals(adapterType)) {
            return adaptable;
        }
        return result;
    }

    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getFactories(adaptable.getClass()).get(adapterTypeName) != null;
    }

    public synchronized void setAdapterFactories(Map adapterFactories) {
        this.unregisterAllAdapters();
        if (adapterFactories != null) {
            for (Map.Entry entry : adapterFactories.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                String typeName = key.toString();
                if (key instanceof Class) {
                    typeName = ((Class)key).getName();
                }
                this.registerFactory((IAdapterFactory)value, typeName);
            }
        }
    }

    public synchronized void registerAdapters(IAdapterFactory factory, Class adaptable) {
        this.registerFactory(factory, adaptable.getName());
        this.flushLookup();
    }

    private void registerFactory(IAdapterFactory factory, String adaptableType) {
        ArrayList<IAdapterFactory> list = (ArrayList<IAdapterFactory>)this.factories.get(adaptableType);
        if (list == null) {
            list = new ArrayList<IAdapterFactory>(5);
            this.factories.put(adaptableType, list);
        }
        list.add(factory);
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory) {
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            ((List)it.next()).remove(factory);
        }
        this.flushLookup();
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory, Class adaptable) {
        List factoryList = (List)this.factories.get(adaptable.getName());
        if (factoryList == null) {
            return;
        }
        factoryList.remove(factory);
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
    }
}

