<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/blogs/init.jsp" %>

<liferay-util:buffer var="html">
	<liferay-util:include
		page="/blogs/view_entry_content_detail.original.jsp"
		servletContext="<%= application %>"
	/>
</liferay-util:buffer>

<%
	BlogsEntry entry = (BlogsEntry)request.getAttribute("view_entry_content.jsp-entry");

	String blogsEntryIdParameter = renderResponse.getNamespace() + entry.getEntryId();

	int x = html.indexOf(blogsEntryIdParameter);
	int y = html.indexOf(">", x);

	String coverImageURL = entry.getCoverImageURL(themeDisplay);
%>

<liferay-util:buffer var="customHTML">
	<c:if test="<%= Validator.isNotNull(coverImageURL) %>">
		<div class="row">
			<div class="col-md-8 mx-auto">
				<div class="custom-cover-image">
					<figure>
						<img class="blog-img-shadow" src="<%= coverImageURL %>">
					</figure>
				</div>
			</div>
		</div>
	</c:if>
</liferay-util:buffer>

<%
	StringBundler sb = new StringBundler(3);

	sb.append(html.substring(0, y + 4));
	sb.append(customHTML);
	sb.append(html.substring(y + 4));

	html = sb.toString();
%>

<%= html %>