package aQute.lib.tiny;

import java.lang.reflect.*;
import java.util.*;

public class Reference {

	public static Object get(Object targets[], String method) throws Exception {
		for (int i = 0; i < targets.length; i++) {
			try {
				return get(targets[i], method);
			} catch (NoSuchMethodException nsme) {

			}
		}
		throw new NoSuchMethodException(method.toString());
	}

	public static Object get(Object target, String method) throws Exception {
		String name = "get" + Character.toUpperCase(method.charAt(0)) +
				method.subSequence(1, method.length());
		try {
			Method m = target.getClass().getMethod(name, null);
			return m.invoke(target, null);
		} catch (NoSuchMethodException e) {
			Method m = target.getClass().getMethod(method.toString(), null);
			return m.invoke(target, null);
		}
	}

	public static Object set(Object target, String method, Object value)
			throws Exception {
		Class c = Object.class;
		if (value != null)
			c = value.getClass();

		String name = "set" + Character.toUpperCase(method.charAt(0)) +
				method.subSequence(1, method.length());
		try {
			Method m = target.getClass().getMethod(name, new Class[] { c });
			return m.invoke(target, new Object[] { value });
		} catch (NoSuchMethodException nsme) {
			if (value != null)
				value = value.toString();
			call(target, name, Arrays.asList(new Object[] { value }));
			Method m = target.getClass().getMethod(name, new Class[] { c });
			return m.invoke(target, new Object[] { value });

		}
	}

	static public Object call(Object target, CharSequence name,
			List inputArgs) throws Exception {
		Method methods[] = target.getClass().getMethods();
		// We want the highest arity first
		Arrays.sort(methods,new Comparator() {
			public int compare(Object a, Object b) {
				return ((Method)b).getParameterTypes().length - ((Method)a).getParameterTypes().length;
			}} 
		);
		
		for (int i = 0; i < methods.length; i++) {
			if (methods[i].getName().equals(name)) {
				Class types[] = methods[i].getParameterTypes();
				if ( types.length == 1 && types[0].isAssignableFrom(Object[].class)) {
					Object result = methods[i].invoke(target, new Object[] { inputArgs.toArray() } );
					while (! inputArgs.isEmpty() )
						inputArgs.remove(0);
					return result;
				} else
				if (types.length <= inputArgs.size()) {
					Object args[] = new Object[types.length];
					for (int j = 0; j < types.length; j++) {
						args[j] = coerce(types[j], inputArgs.get(j));
					}
					methods[i].setAccessible(true);
					Object result = methods[i].invoke(target, args);
					for (int j = 0; j < types.length; j++)
						inputArgs.remove(0);
					return result;
				}
			}
		}
		throw new NoSuchMethodException(name.toString());
	}

	static public Object call(Object targets[], CharSequence name,
			List inputArgs) throws Exception {
		for (int i = 0; i < targets.length; i++) {
			try {
				return call(targets[i], name, inputArgs);
			} catch (NoSuchMethodException nsme) {
				// Ignore
			}
		}
		for (int i = 0; i < targets.length; i++) {
			try {
				return call(targets[i], name, new ArrayList(inputArgs ));
			} catch (NoSuchMethodException nsme) {
				// Ignore
			}
		}
		throw new NoSuchMethodException(name.toString());
	}

	static public Object newInstance(Class target, Object[] inputArgs)
			throws Exception {
		Constructor constructors[] = target.getConstructors();
		for (int i = 0; i < constructors.length; i++) {
			Class params[] = constructors[i].getParameterTypes();
			try {
				if (params.length == inputArgs.length) {
					for (int j = 0; j < params.length; j++) {
						inputArgs[j] = coerce(params[j], inputArgs[j]);
					}
					return constructors[i].newInstance(inputArgs);
				}
			} catch (Exception e) {
				// Coercion failed, lets try next
				e.printStackTrace(); // for now
			}
		}
		throw new NoSuchMethodException(target.getName());
	}

	/**
	 * Coerce the value object into the given type.
	 * 
	 * @param c
	 *            the given type
	 * @param value
	 *            the value, usually a String. Can not be null.
	 * @return the resulting object
	 * @throws Exception
	 */
	public static Object coerce(Class c, Object value) throws Exception {
		if (c.isPrimitive()) {
			if (c == byte.class)
				c = Byte.class;
			else if (c == char.class)
				c = Character.class;
			else if (c == int.class)
				c = Integer.class;
			else if (c == long.class)
				c = Long.class;
			else if (c == float.class)
				c = Float.class;
			else if (c == double.class)
				c = Double.class;
			else
				throw new RuntimeException("Huh? Missing primitive: " + c);
		}

		if (value == null)
			return null;

		if (value.toString().equals("null"))
			return null;

		if (c.isAssignableFrom(value.getClass()))
			return value;

		if (c.isArray()) {
			if (value instanceof Object[]) {
				Object[] values = (Object[]) value;
				Class ctype = c.getComponentType();
				Object[] result = (Object[]) Array.newInstance(ctype,
						values.length);
				for (int i = 0; i < result.length; i++) {
					result[i] = coerce(ctype, values[i]);
				}
				return result;
			} else if (value instanceof String) {
				return getArray(c, (String) value);
			} else
				throw new IllegalArgumentException(
						"Array required but single value given");
		}

		if (c.isAssignableFrom(Collection.class)) {
			Collection collection = (Collection) c.newInstance();
			if (value instanceof Object[]) {
				Object[] values = (Object[]) value;
				for (int i = 0; i < values.length; i++) {
					collection.add(values[i]);
				}
			} else if (value instanceof String) {
				return Arrays.asList(getArray(c, (String) value));
			} else
				collection.add(value);
			return collection;
		}

		if (value instanceof Number && Number.class.isAssignableFrom(c)) {
			Number number = (Number) value;
			if (c == Byte.class) {
				return new Byte(number.byteValue());
			} else if (c == Short.class) {
				return new Short(number.shortValue());
			} else if (c == Integer.class) {
				return new Integer(number.intValue());
			} else if (c == Long.class) {
				return new Long(number.longValue());
			} else if (c == Float.class) {
				return new Float(number.floatValue());
			} else if (c == Double.class) {
				return new Double(number.doubleValue());
			}
		}

		Constructor constructor = c
				.getConstructor(new Class[] { String.class });
		return constructor.newInstance(new Object[] { value.toString() });
	}

	private static Object[] getArray(Class c, String value) throws Exception {
		String values[] = value.split("\\s*,\\s*");
		Class ctype = c.getComponentType();
		Object[] result = (Object[]) Array.newInstance(ctype, values.length);

		for (int i = 0; i < values.length; i++) {
			result[i] = coerce(ctype, values[i]);
		}
		return result;
	}

}
