/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/whois/WhoIs.java,v 1.1 2007-01-03 17:27:52 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2005). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.whois;

import java.io.*;
import java.net.Socket;
import java.util.*;

public class WhoIs {
	final static String	START	= "whois.arin.net";
	final int			PORT	= 43;
	final byte[]		CRLF	= {13, 10};

	String				ipnr;
	Map					values;

	public WhoIs(String ipnr) throws Exception {
		this.ipnr = ipnr;
		parse(START, PORT);
	}

	void parse(String host, int port) throws Exception {
		values = new TreeMap();
		try {
			Socket socket = new Socket(host, port);
			try {
				BufferedReader rdr = new BufferedReader(new InputStreamReader(
						socket.getInputStream()));
				OutputStream out = socket.getOutputStream();
				out.write(ipnr.getBytes());
				out.write(CRLF);
				String line = rdr.readLine();
				while (line != null) {
					if ( process(line) )
						line = rdr.readLine();
					else
						break;
				}
			}
			finally {
				socket.close();
			}
		}
		catch( IOException ie ) {
			System.err.println("Can not connect to " + host + ":" + port );
		}
	}

	public boolean process(String line) throws Exception {
		line = line.trim();
		if (line.length() == 0)
			return true;

		if (line.startsWith("%"))
			return true;
		if (line.startsWith("#"))
			return true;

		String header = null;
		String value = null;

		int index = line.indexOf(":");
		if (index < 0)
			return true;

		header = line.substring(0, index).trim().toLowerCase();
		value = line.substring(index + 1).trim();

		if (header.equals("referralserver")) {
			referrall(value);
			return false;
		}
		else {
			List l = (List) values.get(header);
			if (l == null) {
				l = new ArrayList();
				values.put(header, l);
			}
			l.add(value);
		}
		return true;
	}

	private void referrall(String value) throws Exception {
		value = value.toLowerCase();
		if (value.startsWith("whois://")) {
			String host = value.substring(8);
			int port = 43;
			int index = host.indexOf(":");
			if (index > 0) {
				port = Integer.parseInt(host.substring(index + 1));
				host = host.substring(0, index);
			}
			parse(host, port);
			return;
		}
		if (value.startsWith("rwhois://")) {
			String host = value.substring(9);
			int port = 43;
			int index = host.indexOf(":");
			if (index > 0) {
				String portS = host.substring(index + 1).trim();
				while (portS.endsWith("/"))
					portS = portS.substring(0,portS.length()-1);
				port = Integer.parseInt(portS);
				host = host.substring(0, index);
			}
			parse(host, port);
			return;
		}
		throw new IllegalArgumentException("Invalid referral: " + value);
	}

	public static void main(String args[]) throws Exception {
		WhoIs whois = new WhoIs("82.197.249.162");
		System.out.println(whois.values);

	}

	public String get(String string) {
		List	list = (List) values.get(string);
		if ( list == null)
			return null;
		StringBuffer sb = new StringBuffer();
		String del = "";
		for ( Iterator i=list.iterator(); i.hasNext(); ) {
			sb.append(del);
			sb.append(i.next());
			del = ", " ;
		}
		return sb.toString();
	}
}
