/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rcm.internal;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.ResourceContainerMonitor;
import com.alibaba.rcm.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import sun.misc.SharedSecrets;
import sun.misc.VM;

public abstract class AbstractResourceContainer
implements ResourceContainer {
    protected static final AbstractResourceContainer ROOT = new RootContainer();
    final long id = ResourceContainerMonitor.register(this);

    protected AbstractResourceContainer() {
    }

    public static AbstractResourceContainer root() {
        return ROOT;
    }

    public static AbstractResourceContainer current() {
        if (!VM.isBooted()) {
            return ROOT;
        }
        return SharedSecrets.getJavaLangAccess().getResourceContainer(Thread.currentThread());
    }

    public abstract Properties getProperties();

    public abstract void setProperties(Properties var1);

    public abstract List<Long> getActiveContainerThreadIds();

    public abstract Long getConsumedAmount(ResourceType var1);

    public abstract Long getResourceLimitReachedCount(ResourceType var1);

    @Override
    public void run(Runnable runnable) {
        if (this.getState() != ResourceContainer.State.RUNNING) {
            throw new IllegalStateException("container not running");
        }
        AbstractResourceContainer abstractResourceContainer = AbstractResourceContainer.current();
        if (abstractResourceContainer == this) {
            runnable.run();
        } else {
            if (abstractResourceContainer != ROOT) {
                throw new IllegalStateException("must be in root container before running into non-root container.");
            }
            this.attach();
            try {
                runnable.run();
            }
            finally {
                this.detach();
            }
        }
    }

    protected void attach() {
        SharedSecrets.getJavaLangAccess().setResourceContainer(Thread.currentThread(), this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void detach() {
        SharedSecrets.getJavaLangAccess().setResourceContainer(Thread.currentThread(), AbstractResourceContainer.root());
    }

    private static class RootContainer
    extends AbstractResourceContainer {
        private RootContainer() {
        }

        @Override
        public void run(Runnable runnable) {
            AbstractResourceContainer abstractResourceContainer = RootContainer.current();
            if (abstractResourceContainer == ROOT) {
                runnable.run();
                return;
            }
            abstractResourceContainer.detach();
            try {
                runnable.run();
            }
            finally {
                abstractResourceContainer.attach();
            }
        }

        @Override
        public ResourceContainer.State getState() {
            return ResourceContainer.State.RUNNING;
        }

        @Override
        protected void attach() {
            throw new UnsupportedOperationException("should not reach here");
        }

        @Override
        protected void detach() {
            throw new UnsupportedOperationException("should not reach here");
        }

        @Override
        public void updateConstraint(Constraint constraint) {
            throw new UnsupportedOperationException("updateConstraint() is not supported by root container");
        }

        @Override
        public Iterable<Constraint> getConstraints() {
            return Collections.emptyList();
        }

        @Override
        public Properties getProperties() {
            throw new UnsupportedOperationException("should not reach here");
        }

        @Override
        public void setProperties(Properties properties) {
            throw new UnsupportedOperationException("should not reach here");
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("destroy() is not supported by root container");
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public Long getConsumedAmount(ResourceType resourceType) {
            return 0L;
        }

        @Override
        public Long getResourceLimitReachedCount(ResourceType resourceType) {
            return 0L;
        }

        @Override
        public List<Long> getActiveContainerThreadIds() {
            Thread[] threadArray;
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            int n = threadGroup.activeCount();
            while ((n = threadGroup.enumerate(threadArray = new Thread[n + n / 2 + 1], true)) == threadArray.length) {
            }
            ArrayList<Long> arrayList = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                if (SharedSecrets.getJavaLangAccess().getResourceContainer(threadArray[i]) != ROOT) continue;
                arrayList.add(threadArray[i].getId());
            }
            return arrayList;
        }
    }
}

