/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;

@BugPattern(name="BadAnnotationImplementation", summary="Classes that implement Annotation must override equals and hashCode. Consider using AutoAnnotation instead of implementing Annotation by hand.", severity=BugPattern.SeverityLevel.ERROR)
public class BadAnnotationImplementation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> CLASS_TREE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.CLASS), Matchers.kindIs((Tree.Kind)Tree.Kind.ENUM)}), Matchers.isSubtypeOf((Supplier)Suppliers.ANNOTATION_TYPE)});

    public Description matchClass(ClassTree classTree, final VisitorState state) {
        if (!CLASS_TREE_MATCHER.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        if (classTree.getKind() == Tree.Kind.ENUM) {
            return this.buildDescription(classTree).setMessage("Enums cannot correctly implement Annotation because their equals and hashCode methods are final. Consider using AutoAnnotation instead of implementing Annotation by hand.").build();
        }
        Symbol.MethodSymbol equals = null;
        Symbol.MethodSymbol hashCode = null;
        final Types types = state.getTypes();
        Name equalsName = state.getName("equals");
        Predicate<Symbol.MethodSymbol> equalsPredicate = new Predicate<Symbol.MethodSymbol>(){

            public boolean apply(Symbol.MethodSymbol methodSymbol) {
                return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && (methodSymbol.flags() & 0x400L) == 0L && ((List)methodSymbol.getParameters()).size() == 1 && types.isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType);
            }
        };
        Name hashCodeName = state.getName("hashCode");
        Predicate<Symbol.MethodSymbol> hashCodePredicate = new Predicate<Symbol.MethodSymbol>(){

            public boolean apply(Symbol.MethodSymbol methodSymbol) {
                return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && (methodSymbol.flags() & 0x400L) == 0L && ((List)methodSymbol.getParameters()).isEmpty();
            }
        };
        for (Type sup : types.closure(ASTHelpers.getSymbol((ClassTree)classTree).type)) {
            if (equals == null) {
                equals = BadAnnotationImplementation.getMatchingMethod(sup, equalsName, equalsPredicate);
            }
            if (hashCode != null) continue;
            hashCode = BadAnnotationImplementation.getMatchingMethod(sup, hashCodeName, hashCodePredicate);
        }
        Verify.verifyNotNull(equals);
        Verify.verifyNotNull(hashCode);
        Symbol.TypeSymbol objectSymbol = state.getSymtab().objectType.tsym;
        if (equals.owner.equals(objectSymbol) || hashCode.owner.equals(objectSymbol)) {
            return this.describeMatch(classTree);
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static Symbol.MethodSymbol getMatchingMethod(Type type, Name name, Predicate<Symbol.MethodSymbol> predicate) {
        Scope.WriteableScope scope = type.tsym.members();
        for (Symbol sym : scope.getSymbolsByName(name)) {
            Symbol.MethodSymbol methodSymbol;
            if (!(sym instanceof Symbol.MethodSymbol) || !predicate.apply((Object)(methodSymbol = (Symbol.MethodSymbol)sym))) continue;
            return methodSymbol;
        }
        return null;
    }
}

