/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;

@BugPattern(name="BadComparable", summary="Possible sign flip from narrowing conversion", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class BadComparable
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final Matcher<MethodTree> COMPARABLE_METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"compareTo"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.INT_TYPE), Matchers.methodHasArity((int)1)});
    private static final Matcher<ClassTree> COMPARABLE_CLASS_MATCHER = Matchers.isSubtypeOf((String)"java.lang.Comparable");
    private static final Matcher<MethodTree> COMPARATOR_METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"compare"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.INT_TYPE), Matchers.methodHasArity((int)2)});
    private static final Matcher<ClassTree> COMPARATOR_CLASS_MATCHER = Matchers.isSubtypeOf((String)"java.util.Comparator");

    private static Type getTypeOfSubtract(BinaryTree expression, VisitorState state) {
        Type expressionType = ASTHelpers.getType((Tree)expression.getLeftOperand());
        if (!ASTHelpers.isSameType((Type)expressionType, (Type)ASTHelpers.getType((Tree)expression.getRightOperand()), (VisitorState)state)) {
            return ASTHelpers.getType((Tree)expression);
        }
        return expressionType;
    }

    private static boolean matches(TypeCastTree tree, VisitorState state) {
        Type treeType = ASTHelpers.getType((Tree)tree.getType());
        if (treeType.getTag() != TypeTag.INT) {
            return false;
        }
        ExpressionTree expression = ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression());
        if (expression.getKind() != Tree.Kind.MINUS) {
            return false;
        }
        Type expressionType = BadComparable.getTypeOfSubtract((BinaryTree)expression, state);
        TypeTag expressionTypeTag = state.getTypes().unboxedTypeOrType(expressionType).getTag();
        return expressionTypeTag == TypeTag.LONG;
    }

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!BadComparable.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree declaringClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (!COMPARABLE_CLASS_MATCHER.matches((Tree)declaringClass, state) && !COMPARATOR_CLASS_MATCHER.matches((Tree)declaringClass, state)) {
            return Description.NO_MATCH;
        }
        MethodTree method = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (method == null) {
            return Description.NO_MATCH;
        }
        if (!COMPARABLE_METHOD_MATCHER.matches((Tree)method, state) && !COMPARATOR_METHOD_MATCHER.matches((Tree)method, state)) {
            return Description.NO_MATCH;
        }
        BinaryTree subtract = (BinaryTree)ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression());
        ExpressionTree lhs = subtract.getLeftOperand();
        ExpressionTree rhs = subtract.getRightOperand();
        SuggestedFix fix = ASTHelpers.getType((Tree)lhs).isPrimitive() ? SuggestedFix.replace((Tree)tree, (String)("Long.compare(" + state.getSourceForNode((Tree)lhs) + ", " + state.getSourceForNode((Tree)rhs) + ")")) : SuggestedFix.replace((Tree)tree, (String)(state.getSourceForNode((Tree)lhs) + ".compareTo(" + state.getSourceForNode((Tree)rhs) + ")"));
        return this.describeMatch(tree, (Fix)fix);
    }
}

