/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.tools.javac.code.Type;
import java.util.HashSet;
import javax.annotation.Nullable;

@BugPattern(name="CatchingUnchecked", summary="This catch block catches `Exception`, but can only catch unchecked exceptions. Consider catching RuntimeException (or something more specific) instead so it is more apparent that no checked exceptions are being handled.", severity=BugPattern.SeverityLevel.WARNING)
public final class CatchingUnchecked
extends BugChecker
implements BugChecker.TryTreeMatcher {
    public Description matchTry(TryTree tree, VisitorState state) {
        ASTHelpers.ScanThrownTypes scanner = new ASTHelpers.ScanThrownTypes(state);
        scanner.scanResources(tree);
        scanner.scan((Tree)tree.getBlock(), null);
        HashSet<Type> thrownExceptions = new HashSet<Type>(scanner.getThrownTypes());
        for (CatchTree catchTree : tree.getCatches()) {
            if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)catchTree.getParameter()), (Type)state.getSymtab().exceptionType, (VisitorState)state) && thrownExceptions.stream().noneMatch(t -> ASTHelpers.isCheckedExceptionType((Type)t, (VisitorState)state))) {
                state.reportMatch(this.describeMatch(catchTree, (Fix)SuggestedFix.replace((Tree)catchTree.getParameter().getType(), (String)"RuntimeException")));
            }
            ImmutableList<Type> caughtTypes = CatchingUnchecked.extractTypes(ASTHelpers.getType((Tree)catchTree.getParameter()));
            thrownExceptions.removeIf(t -> caughtTypes.stream().anyMatch(ct -> ASTHelpers.isSubtype((Type)t, (Type)ct, (VisitorState)state)));
        }
        return Description.NO_MATCH;
    }

    private static ImmutableList<Type> extractTypes(@Nullable Type type) {
        if (type == null) {
            return ImmutableList.of();
        }
        if (type.isUnion()) {
            return ImmutableList.copyOf(((Type.UnionClassType)type).getAlternativeTypes());
        }
        return ImmutableList.of((Object)type);
    }
}

