/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

@BugPattern(name="DeprecatedVariable", summary="Applying the @Deprecated annotation to local variables or parameters has no effect", severity=BugPattern.SeverityLevel.WARNING)
public class DeprecatedVariable
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (!ASTHelpers.hasAnnotation((Symbol)sym, Deprecated.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        switch (sym.getKind()) {
            case LOCAL_VARIABLE: 
            case PARAMETER: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Description.Builder description = this.buildDescription(tree);
        Optional.ofNullable(ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Deprecated")).map(SuggestedFix::delete).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }
}

