/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BadImport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@BugPattern(name="DifferentNameButSame", severity=BugPattern.SeverityLevel.WARNING, summary="This type is referred to in different ways within this file, which may be confusing.", tags={"Style"})
public final class DifferentNameButSame
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Comparator<Map.Entry<String, List<TreePath>>> REPLACEMENT_PREFERENCE = Comparator.comparingInt(e -> ((String)e.getKey()).length()).thenComparing(Map.Entry::getKey);
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final MultiMatcher<Tree, AnnotationTree> HAS_TYPE_USE_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher & Serializable)(t, state) -> DifferentNameButSame.isTypeAnnotation(t));

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        HashBasedTable names = HashBasedTable.create();
        new TreePathScanner<Void, Void>((Table)names){
            final /* synthetic */ Table val$names;
            {
                this.val$names = table;
            }

            @Override
            public Void visitImport(ImportTree importTree, Void unused) {
                return null;
            }

            @Override
            public Void visitCase(CaseTree caseTree, Void unused) {
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                MemberSelectTree tree;
                Symbol superSymbol;
                if (this.getCurrentPath().getParentPath().getLeaf() instanceof MemberSelectTree && (superSymbol = ASTHelpers.getSymbol((Tree)(tree = (MemberSelectTree)this.getCurrentPath().getParentPath().getLeaf()))) instanceof Symbol.ClassSymbol) {
                    return (Void)super.visitMemberSelect(memberSelectTree, null);
                }
                this.handle(memberSelectTree);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                NewClassTree newClassTree;
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent instanceof NewClassTree && (newClassTree = (NewClassTree)parent).getIdentifier().equals(identifierTree) && newClassTree.getEnclosingExpression() != null) {
                    return null;
                }
                this.handle(identifierTree);
                return (Void)super.visitIdentifier(identifierTree, null);
            }

            private void handle(Tree tree) {
                if (state.getEndPosition(tree) == -1) {
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (!(symbol instanceof Symbol.ClassSymbol)) {
                    return;
                }
                String name = tree.toString();
                ArrayList<TreePath> treePaths = (ArrayList<TreePath>)this.val$names.get((Object)symbol, (Object)name);
                if (treePaths == null) {
                    treePaths = new ArrayList<TreePath>();
                    this.val$names.put((Object)symbol, (Object)name, treePaths);
                }
                treePaths.add(this.getCurrentPath());
            }
        }.scan(tree, null);
        block0: for (Map.Entry entry : names.rowMap().entrySet()) {
            Map references;
            Symbol symbol = (Symbol)entry.getKey();
            if (DifferentNameButSame.isGeneric(symbol) || this.isDefinedInThisFile(symbol, tree) || (references = (Map)entry.getValue()).size() == 1 || references.keySet().stream().anyMatch(n -> Ascii.isLowerCase((char)n.charAt(0)))) continue;
            ImmutableList namesByPreference = (ImmutableList)references.entrySet().stream().sorted(REPLACEMENT_PREFERENCE).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            for (String name : namesByPreference) {
                ImmutableList sites = (ImmutableList)references.entrySet().stream().filter(e -> !((String)e.getKey()).equals(name)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
                if (!(symbol instanceof Symbol.MethodSymbol) && !DifferentNameButSame.visibleAndReferToSameThing(name, (ImmutableList<TreePath>)sites, state) || BadImport.BAD_NESTED_CLASSES.contains((Object)name)) continue;
                List components = DOT_SPLITTER.splitToList((CharSequence)name);
                SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
                for (TreePath site : sites) {
                    fixBuilder.merge(DifferentNameButSame.createFix(site, components, state));
                }
                SuggestedFix fix = fixBuilder.build();
                for (TreePath path : sites) {
                    state.reportMatch(this.describeMatch(path.getLeaf(), (Fix)fix));
                }
                continue block0;
            }
        }
        return Description.NO_MATCH;
    }

    private boolean isDefinedInThisFile(Symbol symbol, CompilationUnitTree tree) {
        return tree.getTypeDecls().stream().anyMatch(t -> {
            Symbol topLevelClass = ASTHelpers.getSymbol((Tree)t);
            return topLevelClass instanceof Symbol.ClassSymbol && symbol.isEnclosedBy((Symbol.ClassSymbol)topLevelClass);
        });
    }

    private static boolean isGeneric(Symbol symbol) {
        Symbol s = symbol;
        while (s != null) {
            if (!s.getTypeParameters().isEmpty()) {
                return true;
            }
            s = s.owner;
        }
        return false;
    }

    private static SuggestedFix createFix(TreePath path, List<String> components, VisitorState state) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        StringBuilder stringBuilder = new StringBuilder();
        components.stream().limit(components.size() - 1).forEachOrdered(c -> stringBuilder.append((String)c).append("."));
        Tree site = path.getLeaf();
        Tree parent = path.getParentPath().getLeaf();
        if (DifferentNameButSame.canHaveTypeUseAnnotations(parent)) {
            for (AnnotationTree annotation : HAS_TYPE_USE_ANNOTATION.multiMatchResult(parent, state).matchingNodes()) {
                if (state.getEndPosition((Tree)annotation) < ASTHelpers.getStartPosition((Tree)site)) {
                    fixBuilder.delete((Tree)annotation);
                }
                stringBuilder.append(state.getSourceForNode((Tree)annotation)).append(" ");
            }
        }
        stringBuilder.append((String)Iterables.getLast(components));
        return fixBuilder.replace(site, stringBuilder.toString()).build();
    }

    private static boolean canHaveTypeUseAnnotations(Tree tree) {
        return tree instanceof AnnotatedTypeTree || tree instanceof MethodTree || tree instanceof VariableTree;
    }

    private static boolean visibleAndReferToSameThing(String name, ImmutableList<TreePath> locations, VisitorState state) {
        String firstComponent = name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
        HashSet<Symbol> idents = new HashSet<Symbol>();
        for (TreePath path : locations) {
            VisitorState stateWithPath = state.withPath(path);
            if (FindIdentifiers.findIdent((String)firstComponent, (VisitorState)stateWithPath, (Kinds.KindSelector)Kinds.KindSelector.VAR) != null) {
                return false;
            }
            Symbol symbol = FindIdentifiers.findIdent((String)firstComponent, (VisitorState)stateWithPath, (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP_PCK);
            if (symbol == null) {
                return false;
            }
            idents.add(symbol);
        }
        return idents.size() == 1;
    }

    private static boolean isTypeAnnotation(AnnotationTree t) {
        Symbol annotationSymbol = ASTHelpers.getSymbol((Tree)t.getAnnotationType());
        if (annotationSymbol == null) {
            return false;
        }
        Target target = annotationSymbol.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        List<ElementType> value = Arrays.asList(target.value());
        return value.contains((Object)ElementType.TYPE_USE) || value.contains((Object)ElementType.TYPE_PARAMETER);
    }
}

