/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="FieldCanBeLocal", altNames={"unused", "Unused"}, summary="This field can be replaced with a local variable in the methods that use it.", severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false)
public final class FieldCanBeLocal
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<ElementType> VALID_ON_LOCAL_VARIABLES = Sets.immutableEnumSet((Enum)ElementType.LOCAL_VARIABLE, (Enum[])new ElementType[]{ElementType.TYPE_USE});

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final LinkedHashMap potentialFields = new LinkedHashMap();
        SetMultimap unconditionalAssignments = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        SetMultimap uses = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(){

            public Void visitVariable(VariableTree variableTree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                if (symbol != null && symbol.getKind() == ElementKind.FIELD && symbol.isPrivate() && this.canBeLocal(variableTree)) {
                    potentialFields.put(symbol, this.getCurrentPath());
                }
                return null;
            }

            private boolean canBeLocal(VariableTree variableTree) {
                if (variableTree.getModifiers() == null) {
                    return true;
                }
                return variableTree.getModifiers().getAnnotations().stream().allMatch(this::canBeUsedOnLocalVariable);
            }

            private boolean canBeUsedOnLocalVariable(AnnotationTree annotationTree) {
                Target target = (Target)ASTHelpers.getAnnotation((Tree)annotationTree, Target.class);
                if (target == null) {
                    return true;
                }
                return !Sets.intersection((Set)VALID_ON_LOCAL_VARIABLES, (Set)ImmutableSet.copyOf((Object[])target.value())).isEmpty();
            }
        }.scan(state.getPath(), null);
        new TreePathScanner<Void, Void>((Multimap)unconditionalAssignments, (Multimap)uses){
            boolean inMethod = false;
            final /* synthetic */ Multimap val$unconditionalAssignments;
            final /* synthetic */ Multimap val$uses;
            {
                this.val$unconditionalAssignments = multimap;
                this.val$uses = multimap2;
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (FieldCanBeLocal.this.isSuppressed(classTree)) {
                    return null;
                }
                this.inMethod = false;
                return (Void)super.visitClass(classTree, unused);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (methodTree.getBody() == null) {
                    return null;
                }
                this.handleMethodLike(new TreePath(this.getCurrentPath(), methodTree.getBody()));
                this.inMethod = true;
                super.visitMethod(methodTree, null);
                this.inMethod = false;
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
                if (lambdaExpressionTree.getBody() == null) {
                    return null;
                }
                this.handleMethodLike(new TreePath(this.getCurrentPath(), lambdaExpressionTree.getBody()));
                this.inMethod = true;
                super.visitLambdaExpression(lambdaExpressionTree, null);
                this.inMethod = false;
                return null;
            }

            private void handleMethodLike(TreePath treePath) {
                final int depth = Iterables.size((Iterable)this.getCurrentPath());
                new TreePathScanner<Void, Void>(){
                    Set<Symbol.VarSymbol> unconditionallyAssigned = new HashSet<Symbol.VarSymbol>();

                    @Override
                    public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
                        this.scan(assignmentTree.getExpression(), null);
                        Symbol symbol = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable());
                        if (!(symbol instanceof Symbol.VarSymbol)) {
                            return (Void)this.scan(assignmentTree.getVariable(), null);
                        }
                        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                        if (!potentialFields.containsKey(varSymbol)) {
                            return (Void)this.scan(assignmentTree.getVariable(), null);
                        }
                        if (Iterables.size((Iterable)this.getCurrentPath()) == depth + 3) {
                            this.unconditionallyAssigned.add(varSymbol);
                            val$unconditionalAssignments.put((Object)varSymbol, (Object)this.getCurrentPath());
                        }
                        return (Void)this.scan(assignmentTree.getVariable(), null);
                    }

                    @Override
                    public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                        this.handleIdentifier(identifierTree);
                        return (Void)super.visitIdentifier(identifierTree, null);
                    }

                    @Override
                    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                        this.handleIdentifier(memberSelectTree);
                        return (Void)super.visitMemberSelect(memberSelectTree, null);
                    }

                    private void handleIdentifier(Tree tree) {
                        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                        if (!(symbol instanceof Symbol.VarSymbol)) {
                            return;
                        }
                        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                        val$uses.put((Object)varSymbol, (Object)tree);
                        if (!this.unconditionallyAssigned.contains(varSymbol)) {
                            potentialFields.remove(varSymbol);
                        }
                    }

                    @Override
                    public Void visitNewClass(NewClassTree node, Void unused) {
                        this.unconditionallyAssigned.clear();
                        return (Void)super.visitNewClass(node, null);
                    }

                    @Override
                    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                        this.unconditionallyAssigned.clear();
                        return (Void)super.visitMethodInvocation(node, null);
                    }

                    @Override
                    public Void visitMethod(MethodTree methodTree, Void unused) {
                        return null;
                    }

                    @Override
                    public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
                        return null;
                    }
                }.scan(treePath, (Void)null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                if (!this.inMethod) {
                    potentialFields.remove(ASTHelpers.getSymbol((Tree)identifierTree));
                }
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                if (!this.inMethod) {
                    potentialFields.remove(ASTHelpers.getSymbol((Tree)memberSelectTree));
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }
        }.scan(state.getPath(), (Void)null);
        for (Map.Entry entry : potentialFields.entrySet()) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)entry.getKey();
            TreePath declarationSite = (TreePath)entry.getValue();
            Collection assignmentLocations = unconditionalAssignments.get((Object)varSymbol);
            if (assignmentLocations.isEmpty()) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            VariableTree variableTree = (VariableTree)declarationSite.getLeaf();
            String type = state.getSourceForNode(variableTree.getType());
            String annotations = FieldCanBeLocal.getAnnotationSource(state, variableTree);
            fix.delete(declarationSite.getLeaf());
            HashSet<ExpressionTree> deletedTrees = new HashSet<ExpressionTree>();
            HashSet<Tree> scopesDeclared = new HashSet<Tree>();
            for (TreePath assignmentSite : assignmentLocations) {
                AssignmentTree assignmentTree = (AssignmentTree)assignmentSite.getLeaf();
                Symbol rhsSymbol = ASTHelpers.getSymbol((Tree)assignmentTree.getExpression());
                String assigneeName = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable()).getSimpleName().toString();
                if (rhsSymbol != null && assignmentTree.getExpression() instanceof IdentifierTree && rhsSymbol.getSimpleName().contentEquals(assigneeName)) {
                    deletedTrees.add(assignmentTree.getVariable());
                    fix.delete(assignmentSite.getParentPath().getLeaf());
                    continue;
                }
                Tree scope = assignmentSite.getParentPath().getParentPath().getLeaf();
                if (!scopesDeclared.add(scope)) continue;
                fix.prefixWith(assignmentSite.getLeaf(), annotations + " " + type + " ");
            }
            for (Tree usage : uses.get((Object)varSymbol)) {
                IdentifierTree ident;
                ExpressionTree selected;
                if (deletedTrees.contains(usage) || usage.getKind() == Tree.Kind.IDENTIFIER || usage.getKind() != Tree.Kind.MEMBER_SELECT || !((selected = ((MemberSelectTree)usage).getExpression()) instanceof IdentifierTree) || !(ident = (IdentifierTree)selected).getName().contentEquals("this")) continue;
                fix.replace(ASTHelpers.getStartPosition((Tree)ident), state.getEndPosition((Tree)ident) + 1, "");
            }
            state.reportMatch(this.describeMatch(declarationSite.getLeaf(), (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }

    private static String getAnnotationSource(VisitorState state, VariableTree variableTree) {
        List<? extends AnnotationTree> annotations = variableTree.getModifiers().getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return "";
        }
        return state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)annotations.get(0)), state.getEndPosition((Tree)Iterables.getLast(annotations))).toString();
    }
}

