/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="FieldCanBeStatic", summary="A final field initialized at compile-time with an instance of an immutable type can be static.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class FieldCanBeStatic
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> PURE_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Optional"), MethodMatchers.staticMethod().onClass("com.google.common.base.Pair"), MethodMatchers.staticMethod().onClass("com.google.common.base.Splitter"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableBiMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableCollection"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableList"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableListMultimap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableMultimap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableMultiset"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableRangeMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableRangeSet"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSet"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSetMultimap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedMultiset"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedSet"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableTable"), MethodMatchers.staticMethod().onClass("com.google.common.collect.Range"), MethodMatchers.staticMethod().onClass("com.google.protobuf.GeneratedMessage"), MethodMatchers.staticMethod().onClass("java.time.Duration").namedAnyOf(new String[]{"ofNanos", "ofMillis", "ofSeconds", "ofMinutes", "ofHours", "ofDays"}).withParameters(new String[]{"long"}), MethodMatchers.staticMethod().onClass("java.time.Instant").namedAnyOf(new String[]{"ofEpochMilli", "ofEpochSecond"}).withParameters(new String[]{"long"}), MethodMatchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds"}), MethodMatchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds", "fromMinutes", "fromHours", "fromDays"}), MethodMatchers.staticMethod().onClass("org.joda.time.Duration").namedAnyOf(new String[]{"millis", "standardSeconds", "standardMinutes", "standardHours", "standardDays"}).withParameters(new String[]{"long"}), MethodMatchers.constructor().forClass("org.joda.time.Instant").withParameters(new String[]{"long"}), MethodMatchers.constructor().forClass("org.joda.time.DateTime").withParameters(new String[]{"long"}), MethodMatchers.staticMethod().onClass("java.time.LocalDate").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.time.LocalDateTime").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.time.LocalTime").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.time.MonthDay"), MethodMatchers.staticMethod().onClass("java.time.OffsetDateTime").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.time.OffsetTime").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.time.Period"), MethodMatchers.staticMethod().onClass("java.time.Year"), MethodMatchers.staticMethod().onClass("java.time.YearMonth"), MethodMatchers.staticMethod().onClass("java.time.ZoneId"), MethodMatchers.staticMethod().onClass("java.time.ZoneOffset"), MethodMatchers.staticMethod().onClass("java.time.ZonedDateTime").withNameMatching(Pattern.compile("^?!(now)")), MethodMatchers.staticMethod().onClass("java.util.Optional"), MethodMatchers.staticMethod().onClass("java.util.OptionalDouble"), MethodMatchers.staticMethod().onClass("java.util.OptionalInt"), MethodMatchers.staticMethod().onClass("java.util.OptionalLong"), MethodMatchers.staticMethod().onClass("java.util.regex.Pattern"), MethodMatchers.staticMethod().onClass("org.joda.time.DateTime"), MethodMatchers.staticMethod().onClass("org.joda.time.DateTimeZone"), MethodMatchers.staticMethod().onClass("org.joda.time.Days"), MethodMatchers.staticMethod().onClass("org.joda.time.Duration"), MethodMatchers.staticMethod().onClass("org.joda.time.Instant"), MethodMatchers.staticMethod().onClass("org.joda.time.Interval"), MethodMatchers.staticMethod().onClass("org.joda.time.LocalDate"), MethodMatchers.staticMethod().onClass("org.joda.time.LocalDateTime"), MethodMatchers.staticMethod().onClass("org.joda.time.Period"), MethodMatchers.staticMethod().onClass("org.joda.time.format.DateTimeFormatter")});
    private static final Supplier<ImmutableSet<Name>> EXEMPTING_VARIABLE_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("com.google.inject.testing.fieldbinder.Bind").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private final WellKnownMutability wellKnownMutability;
    private static final Pattern LOWER_CAMEL_PATTERN = Pattern.compile("[a-z][a-zA-Z0-9]+");

    public FieldCanBeStatic(ErrorProneFlags flags) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol == null || !symbol.isPrivate() || !tree.getModifiers().getFlags().contains((Object)Modifier.FINAL) || symbol.isStatic() || !symbol.getKind().equals((Object)ElementKind.FIELD)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol enclClass = symbol.owner.enclClass();
        if (enclClass == null) {
            return Description.NO_MATCH;
        }
        if (!enclClass.getNestingKind().equals((Object)NestingKind.TOP_LEVEL) && !enclClass.isStatic() && symbol.getConstantValue() == null) {
            return Description.NO_MATCH;
        }
        if (!this.isTypeKnownImmutable(ASTHelpers.getType((Tree)tree), state)) {
            return Description.NO_MATCH;
        }
        if (!this.isPure(tree.getInitializer(), state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong((Symbol)symbol, (Set)((Set)EXEMPTING_VARIABLE_ANNOTATIONS.get(state)), (VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().merge(this.renameVariable(tree, state)).merge(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).orElse(SuggestedFix.emptyFix())).build();
        return this.describeMatch(tree, (Fix)fix);
    }

    private SuggestedFix renameVariable(VariableTree variableTree, VisitorState state) {
        String name = variableTree.getName().toString();
        if (!LOWER_CAMEL_PATTERN.matcher(name).matches()) {
            return SuggestedFix.emptyFix();
        }
        final String replacement = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, variableTree.getName().toString());
        int typeEndPos = state.getEndPosition(variableTree.getType());
        int searchOffset = typeEndPos - ((JCTree)((Object)variableTree)).getStartPosition();
        int pos = ((JCTree)((Object)variableTree)).getStartPosition() + state.getSourceForNode((Tree)variableTree).indexOf(name, searchOffset);
        final SuggestedFix.Builder fix = SuggestedFix.builder().replace(pos, pos + name.length(), replacement);
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)variableTree);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            private void handle(Tree tree) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    fix.replace(tree, replacement);
                }
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    private boolean isPure(ExpressionTree initializer, final VisitorState state) {
        final AtomicBoolean isPure = new AtomicBoolean(true);
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                if (tree instanceof MethodInvocationTree) {
                    if (!PURE_METHODS.matches((Tree)((ExpressionTree)tree), state)) {
                        isPure.set(false);
                    }
                    return (Void)super.scan(tree, null);
                }
                if (tree instanceof BinaryTree || tree instanceof LiteralTree || tree instanceof ParenthesizedTree) {
                    return (Void)super.scan(tree, null);
                }
                if (tree instanceof IdentifierTree || tree instanceof MemberSelectTree) {
                    Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                    if (!(!(symbol instanceof Symbol.VarSymbol) || symbol.isStatic() && ASTHelpers.isConsideredFinal((Symbol)symbol))) {
                        isPure.set(false);
                    }
                    return (Void)super.scan(tree, null);
                }
                isPure.set(false);
                return null;
            }
        }.scan((Tree)initializer, (Void)null);
        return isPure.get();
    }

    private boolean isTypeKnownImmutable(Type type, VisitorState state) {
        ThreadSafety threadSafety = ThreadSafety.builder().setPurpose(ThreadSafety.Purpose.FOR_IMMUTABLE_CHECKER).knownTypes(this.wellKnownMutability).acceptedAnnotations((ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName(), (Object)AutoValue.class.getName())).markerAnnotations((ImmutableSet<String>)ImmutableSet.of()).build(state);
        return !threadSafety.isThreadSafeType(true, threadSafety.threadSafeTypeParametersInScope(type.tsym), type).isPresent();
    }
}

