/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="JavaUtilDate", summary="Date has a bad API that leads to bugs; prefer java.time.Instant or LocalDate.", severity=BugPattern.SeverityLevel.WARNING)
public class JavaUtilDateChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> EXEMPTIONS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.util.Date").named("toInstant"), MethodMatchers.staticMethod().onClass("java.util.Date").named("from").withParameters(new String[]{"java.time.Instant"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!JavaUtilDateChecker.isDate(state, ASTHelpers.getReceiverType((ExpressionTree)tree))) {
            return Description.NO_MATCH;
        }
        if (EXEMPTIONS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return JavaUtilDateChecker.isDate(state, ASTHelpers.getType((Tree)tree.getIdentifier())) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static boolean isDate(VisitorState state, Type type) {
        return ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString("java.util.Date"), (VisitorState)state);
    }
}

