/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(name="MethodCanBeStatic", altNames={"static-method"}, summary="A private method that does not reference the enclosing instance can be static", severity=BugPattern.SeverityLevel.SUGGESTION)
public class MethodCanBeStatic
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final FindingOutputStyle findingOutputStyle;

    public MethodCanBeStatic(ErrorProneFlags flags) {
        boolean findingPerSite = flags.getBoolean("MethodCanBeStatic:FindingPerSite").orElse(false);
        this.findingOutputStyle = findingPerSite ? FindingOutputStyle.FINDING_PER_SITE : FindingOutputStyle.ONE_FINDING;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap<Symbol.MethodSymbol, MethodDetails> nodes = new HashMap<Symbol.MethodSymbol, MethodDetails>();
        new TreePathScanner<Void, Void>(){
            private int suppressions = 0;

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (MethodCanBeStatic.this.isSuppressed(classTree)) {
                    ++this.suppressions;
                    super.visitClass(classTree, null);
                    --this.suppressions;
                } else {
                    super.visitClass(classTree, null);
                }
                return null;
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (MethodCanBeStatic.this.isSuppressed(tree)) {
                    ++this.suppressions;
                    this.matchMethod(tree);
                    super.visitMethod(tree, null);
                    --this.suppressions;
                } else {
                    this.matchMethod(tree);
                    super.visitMethod(tree, null);
                }
                return null;
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                if (MethodCanBeStatic.this.isSuppressed(variableTree)) {
                    ++this.suppressions;
                    super.visitVariable(variableTree, null);
                    --this.suppressions;
                } else {
                    super.visitVariable(variableTree, null);
                }
                return null;
            }

            private void matchMethod(MethodTree tree) {
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
                if (sym.isStatic()) {
                    nodes.put(sym, new MethodDetails(tree, true, (Set)ImmutableSet.of()));
                } else {
                    CanBeStaticAnalyzer.CanBeStaticResult result = CanBeStaticAnalyzer.canBeStaticResult(tree, sym, state);
                    boolean isExcluded = MethodCanBeStatic.isExcluded(tree, state);
                    nodes.put(sym, new MethodDetails(tree, result.canPossiblyBeStatic() && !isExcluded && this.suppressions == 0, (Set)result.methodsReferenced()));
                }
            }
        }.scan(state.getPath(), (Void)null);
        MethodCanBeStatic.propagateNonStaticness(nodes);
        nodes.entrySet().removeIf(entry -> ((MethodDetails)entry.getValue()).tree.getModifiers().getFlags().contains((Object)Modifier.STATIC));
        return this.generateDescription(nodes, state);
    }

    private static void propagateNonStaticness(Map<Symbol.MethodSymbol, MethodDetails> nodes) {
        for (Map.Entry<Symbol.MethodSymbol, MethodDetails> entry : nodes.entrySet()) {
            Symbol.MethodSymbol sym = entry.getKey();
            MethodDetails methodDetails = entry.getValue();
            for (Symbol.MethodSymbol use : methodDetails.methodsReferenced) {
                if (!nodes.containsKey(use)) continue;
                nodes.get(use).referencedBy.add(sym);
            }
            if (!MethodCanBeStatic.referencesExternalMethods(methodDetails, nodes.keySet())) continue;
            methodDetails.couldPossiblyBeStatic = false;
        }
        HashSet<Symbol.MethodSymbol> toVisit = new HashSet<Symbol.MethodSymbol>(nodes.keySet());
        while (!toVisit.isEmpty()) {
            HashSet<Symbol.MethodSymbol> nextVisit = new HashSet<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol sym : toVisit) {
                MethodDetails methodDetails = nodes.get(sym);
                if (methodDetails.couldPossiblyBeStatic) continue;
                for (Symbol.MethodSymbol user : methodDetails.referencedBy) {
                    if (!nodes.get(user).couldPossiblyBeStatic) continue;
                    nodes.get(user).couldPossiblyBeStatic = false;
                    nodes.get(user).methodsReferenced.remove(sym);
                    nextVisit.add(user);
                }
            }
            toVisit = nextVisit;
        }
    }

    private Description generateDescription(Map<Symbol.MethodSymbol, MethodDetails> nodes, VisitorState state) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.setShortDescription("Make static");
        HashSet<MethodTree> affectedTrees = new HashSet<MethodTree>();
        for (Map.Entry<Symbol.MethodSymbol, MethodDetails> entry : nodes.entrySet()) {
            boolean noExternalMethods;
            Symbol.MethodSymbol sym = entry.getKey();
            MethodDetails methodDetails = entry.getValue();
            boolean bl = noExternalMethods = !MethodCanBeStatic.referencesExternalMethods(methodDetails, nodes.keySet());
            if (!methodDetails.couldPossiblyBeStatic || !noExternalMethods) continue;
            SuggestedFixes.addModifiers((Tree)methodDetails.tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).map(f -> this.fixQualifiers(state, sym, (SuggestedFix)f)).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
            affectedTrees.add(methodDetails.tree);
        }
        return this.findingOutputStyle.report(affectedTrees, fixBuilder.build(), state, this);
    }

    private static boolean referencesExternalMethods(MethodDetails methodDetails, Set<Symbol.MethodSymbol> localMethods) {
        return !Sets.difference((Set)methodDetails.methodsReferenced, localMethods).isEmpty();
    }

    private SuggestedFix fixQualifiers(VisitorState state, final Symbol.MethodSymbol sym, SuggestedFix f) {
        final SuggestedFix.Builder builder = SuggestedFix.builder().merge(f);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.fixQualifier(tree, tree.getExpression());
                return (Void)super.visitMemberSelect(tree, unused);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                this.fixQualifier(tree, tree.getQualifierExpression());
                return (Void)super.visitMemberReference(tree, unused);
            }

            private void fixQualifier(Tree tree, ExpressionTree qualifierExpression) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    builder.replace((Tree)qualifierExpression, sym.owner.enclClass().getSimpleName().toString());
                }
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return builder.build();
    }

    private static boolean isExcluded(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return true;
        }
        if (sym.isConstructor() || sym.getModifiers().contains((Object)Modifier.NATIVE) || sym.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
            return true;
        }
        if (!sym.isPrivate()) {
            return true;
        }
        switch (sym.owner.enclClass().getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!sym.owner.enclClass().hasOuterInstance()) break;
                return true;
            }
            case LOCAL: 
            case ANONYMOUS: {
                return true;
            }
        }
        return Matchers.SERIALIZATION_METHODS.matches((Tree)tree, state);
    }

    private static enum FindingOutputStyle {
        ONE_FINDING{

            @Override
            public Description report(Set<MethodTree> affectedTrees, SuggestedFix fix, VisitorState state, BugChecker checker) {
                return affectedTrees.stream().min(Comparator.comparingInt(t -> ASTHelpers.getStartPosition((Tree)t))).map(t -> checker.describeMatch((Tree)t.getModifiers(), (Fix)fix)).orElse(Description.NO_MATCH);
            }
        }
        ,
        FINDING_PER_SITE{

            @Override
            public Description report(Set<MethodTree> affectedTrees, SuggestedFix fix, VisitorState state, BugChecker checker) {
                for (MethodTree tree : affectedTrees) {
                    state.reportMatch(checker.describeMatch((Tree)tree.getModifiers(), (Fix)fix));
                }
                return Description.NO_MATCH;
            }
        };


        public abstract Description report(Set<MethodTree> var1, SuggestedFix var2, VisitorState var3, BugChecker var4);
    }

    private static final class MethodDetails {
        private final MethodTree tree;
        private boolean couldPossiblyBeStatic;
        private final Set<Symbol.MethodSymbol> methodsReferenced;
        private final Set<Symbol.MethodSymbol> referencedBy = new HashSet<Symbol.MethodSymbol>();

        private MethodDetails(MethodTree tree, boolean couldPossiblyBeStatic, Set<Symbol.MethodSymbol> methodsReferenced) {
            this.tree = tree;
            this.couldPossiblyBeStatic = couldPossiblyBeStatic;
            this.methodsReferenced = new HashSet<Symbol.MethodSymbol>(methodsReferenced);
        }
    }
}

