/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(name="PublicApiNamedStreamShouldReturnStream", summary="Public methods named stream() are generally expected to return a type whose name ends with Stream. Consider choosing a different method name instead.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class PublicApiNamedStreamShouldReturnStream
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String STREAM = "stream";
    private static final Matcher<MethodTree> CONFUSING_PUBLIC_API_STREAM_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"stream"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), PublicApiNamedStreamShouldReturnStream::returnTypeDoesNotEndsWithStream});

    private static boolean returnTypeDoesNotEndsWithStream(MethodTree methodTree, VisitorState state) {
        Type returnType = ASTHelpers.getSymbol((MethodTree)methodTree).getReturnType();
        return returnType != null && !((Name)returnType.tsym.getSimpleName()).toString().endsWith("Stream");
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!CONFUSING_PUBLIC_API_STREAM_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

