/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(name="ReturnValueIgnored", altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", severity=BugPattern.SeverityLevel.ERROR)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final ImmutableSet<String> TYPES_TO_CHECK = ImmutableSet.of((Object)"java.math.BigInteger", (Object)"java.math.BigDecimal", (Object)"java.nio.file.Path");
    private static final Matcher<ExpressionTree> RETURNS_SAME_TYPE = Matchers.allOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> TYPES_TO_CHECK.contains((Object)ASTHelpers.getReceiverType((ExpressionTree)t).toString()), (Matcher & Serializable)(t, s) -> ASTHelpers.isSameType((Type)ASTHelpers.getReceiverType((ExpressionTree)t), (Type)ASTHelpers.getReturnType((ExpressionTree)t), (VisitorState)s)});
    private static final Matcher<ExpressionTree> ALLOWED_JAVA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().named("parse"), MethodMatchers.instanceMethod().anyClass().named("parse"), MethodMatchers.staticMethod().anyClass().named("of"), MethodMatchers.staticMethod().anyClass().named("from"), MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("ofOffset"), MethodMatchers.instanceMethod().onExactClass("java.time.format.DateTimeFormatterBuilder").withNameMatching(Pattern.compile("^(append|parse|pad|optional).*")), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidIntValue"), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidValue"), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ValueRange").named("checkValidValue")});
    private static final Matcher<ExpressionTree> STREAM_METHOD = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.BaseStream");
    private static final Matcher<ExpressionTree> ARRAYS_METHODS = MethodMatchers.staticMethod().onClass("java.util.Arrays");
    private static final Matcher<ExpressionTree> STRING_METHODS = Matchers.anyMethod().onClass("java.lang.String");
    private static final ImmutableSet<String> PRIMITIVE_TYPES = ImmutableSet.of((Object)"java.lang.Boolean", (Object)"java.lang.Byte", (Object)"java.lang.Character", (Object)"java.lang.Double", (Object)"java.lang.Float", (Object)"java.lang.Integer", (Object[])new String[]{"java.lang.Long", "java.lang.Short"});
    private static final Matcher<ExpressionTree> PRIMITIVE_NON_PARSING_METHODS = Matchers.anyMethod().onClass(TypePredicates.isExactTypeAny(PRIMITIVE_TYPES));
    private static final Matcher<ExpressionTree> PRIMITIVE_PARSING_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.lang.Character").namedAnyOf(new String[]{"toChars", "codePointCount"}), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("decode"), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).withNameMatching(Pattern.compile("^parse[A-z]*")), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("valueOf").withParameters(new String[]{"java.lang.String"}), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("valueOf").withParameters(new String[]{"java.lang.String", "int"})});
    private static final Matcher<ExpressionTree> COLLECTION_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("contains").withParameters(new String[]{"java.lang.Object"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll").withParameters(new String[]{"java.util.Collection"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("isEmpty").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("size").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("stream").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("toArray").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("toArray").withParameters(new String[]{"java.util.function.IntFunction"})});
    private static final Matcher<ExpressionTree> MAP_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"containsKey", "containsValue"}).withParameters(new String[]{"java.lang.Object"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"isEmpty", "size", "entrySet", "keySet", "values"}), MethodMatchers.staticMethod().onClass("java.util.Map").namedAnyOf(new String[]{"of", "copyOf", "entry", "ofEntries"})});
    private static final Matcher<ExpressionTree> MAP_ENTRY_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.util.Map.Entry"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map.Entry").namedAnyOf(new String[]{"getKey", "getValue"})});
    private static final Matcher<ExpressionTree> ITERABLE_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.lang.Iterable").named("iterator").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.lang.Iterable").named("spliterator").withNoParameters()});
    private static final Matcher<ExpressionTree> ITERATOR_METHODS = MethodMatchers.instanceMethod().onDescendantOf("java.util.Iterator").named("hasNext").withNoParameters();
    private static final Matcher<ExpressionTree> PRIMITIVE_METHODS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(PRIMITIVE_PARSING_METHODS), PRIMITIVE_NON_PARSING_METHODS});
    private static final Matcher<ExpressionTree> OPTIONAL_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.util.Optional"), MethodMatchers.instanceMethod().onExactClass("java.util.Optional").namedAnyOf(new String[]{"isEmpty", "isPresent"})});
    private static final Matcher<ExpressionTree> MORE_OPTIONAL_METHODS = Matchers.anyMethod().onClass("java.util.Optional");
    private static final Matcher<ExpressionTree> TIME_UNIT_METHODS = Matchers.anyMethod().onClass("java.util.concurrent.TimeUnit");
    private static final Matcher<ExpressionTree> JODA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableInstant").named("getMillis").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis").withNoParameters()});
    private static final String PROTO_MESSAGE = "com.google.protobuf.MessageLite";
    private static final Matcher<ExpressionTree> PROTO_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(TypePredicates.isDescendantOf((String)"com.google.protobuf.MessageLite")).named("newBuilder"), MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").namedAnyOf(new String[]{"build", "buildPartial"})});
    private static final Matcher<ExpressionTree> OBJECT_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").namedAnyOf(new String[]{"getClass", "hashCode", "clone", "toString"}).withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").namedAnyOf(new String[]{"equals"}).withParameters(new String[]{"java.lang.Object"})});
    private static final Matcher<? super ExpressionTree> SPECIALIZED_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{RETURNS_SAME_TYPE, ReturnValueIgnored::functionalMethod, STREAM_METHOD, STRING_METHODS, PROTO_METHODS, PRIMITIVE_METHODS, ARRAYS_METHODS, OPTIONAL_METHODS, TIME_UNIT_METHODS, ReturnValueIgnored::javaTimeTypes, COLLECTION_METHODS, MAP_METHODS, ITERABLE_METHODS, ITERATOR_METHODS});
    private final Matcher<? super ExpressionTree> matcher;

    private static boolean javaTimeTypes(ExpressionTree tree, VisitorState state) {
        if (Matchers.packageStartsWith((String)"java.time").matches((Tree)tree, state)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.MethodSymbol && symbol.owner.packge().getQualifiedName().toString().startsWith("java.time") && symbol.getModifiers().contains((Object)Modifier.PUBLIC) && !ALLOWED_JAVA_TIME_METHODS.matches((Tree)tree, state);
    }

    private static boolean functionalMethod(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.MethodSymbol && symbol.owner.packge().getQualifiedName().contentEquals("java.util.function");
    }

    public ReturnValueIgnored(ErrorProneFlags flags) {
        boolean checkOptionalMethods = flags.getBoolean("ReturnValueIgnored:MoreOptional").orElse(true);
        boolean checkObjectMethods = flags.getBoolean("ReturnValueIgnored:ObjectMethods").orElse(true);
        boolean checkMapEntryMethods = flags.getBoolean("ReturnValueIgnored:MapEntry").orElse(true);
        boolean checkJodaTimeMethods = flags.getBoolean("ReturnValueIgnored:JodaTime").orElse(true);
        this.matcher = Matchers.anyOf((Matcher[])new Matcher[]{SPECIALIZED_MATCHER, checkOptionalMethods ? MORE_OPTIONAL_METHODS : Matchers.nothing(), checkObjectMethods ? OBJECT_METHODS : Matchers.nothing(), checkJodaTimeMethods ? JODA_TIME_METHODS : Matchers.nothing(), checkMapEntryMethods ? MAP_ENTRY_METHODS : Matchers.nothing()});
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return this.matcher;
    }

    @Override
    protected String getMessage(Name name) {
        return String.format("Return value of '%s' must be used", name);
    }
}

