/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import javax.annotation.Nullable;

@BugPattern(name="TestExceptionChecker", summary="Using @Test(expected=...) is discouraged, since the test will pass if *any* statement in the test method throws the expected exception", severity=BugPattern.SeverityLevel.WARNING)
public class TestExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder baseFixBuilder = SuggestedFix.builder();
        JCTree.JCExpression expectedException = TestExceptionChecker.deleteExpectedException(baseFixBuilder, ((JCTree.JCMethodDecl)tree).getModifiers().getAnnotations(), state);
        SuggestedFix baseFix = baseFixBuilder.build();
        if (expectedException == null) {
            return Description.NO_MATCH;
        }
        return this.handleStatements(tree, state, expectedException, baseFix);
    }

    private Description handleStatements(MethodTree tree, VisitorState state, JCTree.JCExpression expectedException, SuggestedFix baseFix) {
        return this.describeMatch(tree, (Fix)TestExceptionChecker.buildFix(state, SuggestedFix.builder().merge(baseFix), expectedException, tree.getBody().getStatements()));
    }

    private static SuggestedFix buildFix(VisitorState state, SuggestedFix.Builder fix, JCTree.JCExpression expectedException, Collection<? extends StatementTree> statements) {
        if (statements.isEmpty()) {
            return fix.build();
        }
        fix.addStaticImport("org.junit.Assert.assertThrows");
        StringBuilder prefix = new StringBuilder();
        prefix.append(String.format("assertThrows(%s, () -> ", state.getSourceForNode((Tree)expectedException)));
        if (statements.size() == 1 && Iterables.getOnlyElement(statements) instanceof ExpressionStatementTree) {
            ExpressionTree expression = ((ExpressionStatementTree)Iterables.getOnlyElement(statements)).getExpression();
            fix.prefixWith((Tree)expression, prefix.toString());
            fix.postfixWith((Tree)expression, ")");
        } else {
            prefix.append(" {");
            fix.prefixWith((Tree)statements.iterator().next(), prefix.toString());
            fix.postfixWith((Tree)Iterables.getLast(statements), "});");
        }
        return fix.build();
    }

    @Nullable
    private static JCTree.JCExpression deleteExpectedException(SuggestedFix.Builder fix, java.util.List<JCTree.JCAnnotation> annotations, VisitorState state) {
        Type testAnnotation = state.getTypeFromString("org.junit.Test");
        for (JCTree.JCAnnotation annotationTree : annotations) {
            if (!ASTHelpers.isSameType((Type)testAnnotation, (Type)annotationTree.type, (VisitorState)state)) continue;
            java.util.List arguments = annotationTree.getArguments();
            for (JCTree.JCExpression arg : arguments) {
                if (!arg.hasTag(JCTree.Tag.ASSIGN)) continue;
                JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                if (!assign.lhs.hasTag(JCTree.Tag.IDENT) || !((JCTree.JCIdent)assign.lhs).getName().contentEquals("expected")) continue;
                if (((List)arguments).size() == 1) {
                    fix.replace((Tree)annotationTree, "@Test");
                } else {
                    TestExceptionChecker.removeFromList(fix, state, arguments, assign);
                }
                return assign.rhs;
            }
        }
        return null;
    }

    private static void removeFromList(SuggestedFix.Builder fix, VisitorState state, java.util.List<? extends Tree> arguments, Tree tree) {
        int idx = arguments.indexOf(tree);
        if (idx == arguments.size() - 1) {
            fix.replace(state.getEndPosition(arguments.get(arguments.size() - 1)), state.getEndPosition(tree), "");
        } else {
            fix.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)arguments.get(idx + 1)), "");
        }
    }
}

