/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BadImport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Name;

@BugPattern(name="UnnecessarilyFullyQualified", severity=BugPattern.SeverityLevel.WARNING, summary="This fully qualified name is unambiguous to the compiler if imported.")
public final class UnnecessarilyFullyQualified
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> EXEMPTED_NAMES = ImmutableSet.of((Object)"Annotation");

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        if (tree.getTypeDecls().stream().anyMatch(t -> ASTHelpers.getSymbol((Tree)tree) != null && !ASTHelpers.getGeneratedBy((Symbol)ASTHelpers.getSymbol((Tree)tree), (VisitorState)state).isEmpty())) {
            return Description.NO_MATCH;
        }
        if (UnnecessarilyFullyQualified.isPackageInfo(tree)) {
            return Description.NO_MATCH;
        }
        HashBasedTable table = HashBasedTable.create();
        final HashSet identifiersSeen = new HashSet();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
                super((BugChecker)UnnecessarilyFullyQualified.this);
            }

            public Void visitImport(ImportTree importTree, Void unused) {
                return null;
            }

            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                if (!this.shouldIgnore()) {
                    this.handle(this.getCurrentPath());
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                identifiersSeen.add(identifierTree.getName());
                return null;
            }

            private boolean shouldIgnore() {
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                return parentTree instanceof MemberSelectTree && ASTHelpers.getSymbol((Tree)parentTree) instanceof Symbol.ClassSymbol;
            }

            private void handle(TreePath path) {
                MemberSelectTree tree = (MemberSelectTree)path.getLeaf();
                if (!this.isFullyQualified(tree)) {
                    return;
                }
                if (BadImport.BAD_NESTED_CLASSES.contains((Object)tree.getIdentifier().toString())) {
                    if (tree.getExpression() instanceof MemberSelectTree && ASTHelpers.getSymbol((Tree)tree.getExpression()) instanceof Symbol.ClassSymbol) {
                        this.handle(new TreePath(path, tree.getExpression()));
                    }
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (!(symbol instanceof Symbol.ClassSymbol)) {
                    return;
                }
                if (state.getEndPosition((Tree)tree) == -1) {
                    return;
                }
                ArrayList<TreePath> treePaths = (ArrayList<TreePath>)this.val$table.get((Object)tree.getIdentifier(), (Object)symbol.type.tsym);
                if (treePaths == null) {
                    treePaths = new ArrayList<TreePath>();
                    this.val$table.put((Object)tree.getIdentifier(), (Object)symbol.type.tsym, treePaths);
                }
                treePaths.add(path);
            }

            private boolean isFullyQualified(MemberSelectTree tree) {
                final AtomicBoolean isFullyQualified = new AtomicBoolean();
                new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                        return (Void)this.visit(memberSelectTree.getExpression(), null);
                    }

                    @Override
                    public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
                        if (ASTHelpers.getSymbol((Tree)identifierTree) instanceof Symbol.PackageSymbol) {
                            isFullyQualified.set(true);
                        }
                        return null;
                    }
                }.visit(tree, null);
                return isFullyQualified.get();
            }
        }.scan(state.getPath(), null);
        for (Map.Entry rows : table.rowMap().entrySet()) {
            List pathsToFix;
            String nameString;
            Name name = (Name)rows.getKey();
            Map types = (Map)rows.getValue();
            if (types.size() > 1 || Ascii.isLowerCase((char)name.charAt(0)) || identifiersSeen.contains(name) || EXEMPTED_NAMES.contains((Object)(nameString = name.toString())) || (pathsToFix = (List)Iterables.getOnlyElement(types.values())).stream().anyMatch(path -> FindIdentifiers.findIdent((String)nameString, (VisitorState)state.withPath(path), (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP) != null)) continue;
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            fixBuilder.addImport(((Symbol.TypeSymbol)Iterables.getOnlyElement(types.keySet())).getQualifiedName().toString());
            for (TreePath path2 : pathsToFix) {
                fixBuilder.replace(path2.getLeaf(), nameString);
            }
            SuggestedFix fix = fixBuilder.build();
            for (TreePath path3 : pathsToFix) {
                state.reportMatch(this.describeMatch(path3.getLeaf(), (Fix)fix));
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean isPackageInfo(CompilationUnitTree tree) {
        String name = ASTHelpers.getFileName((CompilationUnitTree)tree);
        int idx = name.lastIndexOf(47);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name.equals("package-info.java");
    }
}

