/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_UnnecessaryMethodReference_KnownAlias;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="UnnecessaryMethodReference", severity=BugPattern.SeverityLevel.WARNING, summary="This method reference is unnecessary, and can be replaced with the variable itself.")
public final class UnnecessaryMethodReference
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher {
    private static final ImmutableList<KnownAlias> KNOWN_ALIASES = ImmutableList.of((Object)KnownAlias.create((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.base.Predicate").named("apply"), TypePredicates.isExactType((String)"java.util.function.Predicate")), (Object)KnownAlias.create((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.base.Converter").named("convert"), TypePredicates.isExactType((String)"java.util.function.Function")));

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!tree.getMode().equals((Object)MemberReferenceTree.ReferenceMode.INVOKE)) {
            return Description.NO_MATCH;
        }
        if (!(state.getPath().getParentPath().getLeaf() instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state);
        if (targetType == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        if (receiver instanceof IdentifierTree && ((IdentifierTree)receiver).getName().contentEquals("super")) {
            return Description.NO_MATCH;
        }
        if (!state.getTypes().isSubtype(ASTHelpers.getType((Tree)receiver), targetType.type())) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        Scope.WriteableScope members = targetType.type().tsym.members();
        if (!ASTHelpers.scope((Scope)members).anyMatch(sym -> UnnecessaryMethodReference.isFunctionalInterfaceInvocation(symbol, targetType.type(), sym, state)) && !UnnecessaryMethodReference.isKnownAlias(tree, targetType.type(), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)receiver), (int)state.getEndPosition((Tree)tree), (String)""));
    }

    private static boolean isFunctionalInterfaceInvocation(Symbol.MethodSymbol memberReferenceTarget, Type type, Symbol symbol, VisitorState state) {
        return (memberReferenceTarget.equals(symbol) || ASTHelpers.findSuperMethodInType((Symbol.MethodSymbol)memberReferenceTarget, (Type)type, (Types)state.getTypes()) != null) && symbol.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isKnownAlias(MemberReferenceTree tree, Type type, VisitorState state) {
        return KNOWN_ALIASES.stream().anyMatch(k -> k.matcher().matches((Tree)tree, state) && k.targetType().apply(type, state));
    }

    @AutoValue
    static abstract class KnownAlias {
        KnownAlias() {
        }

        public static KnownAlias create(Matcher<ExpressionTree> matcher, TypePredicate targetType) {
            return new AutoValue_UnnecessaryMethodReference_KnownAlias(matcher, targetType);
        }

        abstract Matcher<ExpressionTree> matcher();

        abstract TypePredicate targetType();
    }
}

