/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;

class NullnessFixes {
    private NullnessFixes() {
    }

    static SuggestedFix makeFix(VisitorState state, Tree declaration) {
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String qualifiedName = NullnessFixes.getQualifiedName(state, builder);
        return builder.prefixWith(declaration, "@" + qualifiedName + " ").build();
    }

    private static String getQualifiedName(VisitorState state, SuggestedFix.Builder builder) {
        Symbol sym = FindIdentifiers.findIdent((String)"Nullable", (VisitorState)state, (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP);
        ErrorProneFlags flags = state.errorProneOptions().getFlags();
        String defaultType = flags.get("Nullness:DefaultNullnessAnnotation").orElse(state.isAndroidCompatible() ? "androidx.annotation.Nullable" : "javax.annotation.Nullable");
        if (sym != null) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)sym;
            if (classSym.isAnnotationType()) {
                return "Nullable";
            }
            return defaultType;
        }
        builder.addImport(defaultType);
        return "Nullable";
    }
}

