/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class BytecodeBinder {
    static Type.ClassTy bindClassTy(Sig.ClassTySig sig, Function<String, TyVarSymbol> scope) {
        StringBuilder sb = new StringBuilder(sig.pkg());
        boolean first = true;
        ArrayList<Type.ClassTy.SimpleClassTy> classes = new ArrayList<Type.ClassTy.SimpleClassTy>();
        for (Sig.SimpleClassTySig s : sig.classes()) {
            sb.append(first ? (char)'/' : '$');
            sb.append(s.simpleName());
            ClassSymbol sym = new ClassSymbol(sb.toString());
            ImmutableList.Builder tyArgs = ImmutableList.builder();
            for (Sig.TySig arg : s.tyArgs()) {
                tyArgs.add((Object)BytecodeBinder.bindTy(arg, scope));
            }
            classes.add(Type.ClassTy.SimpleClassTy.create(sym, (ImmutableList<Type>)tyArgs.build(), (ImmutableList<AnnoInfo>)ImmutableList.of()));
            first = false;
        }
        return Type.ClassTy.create(classes);
    }

    private static Type wildTy(Sig.WildTySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.boundKind()) {
            case NONE: {
                return Type.WildUnboundedTy.create((ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(BytecodeBinder.bindTy(((Sig.LowerBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(BytecodeBinder.bindTy(((Sig.UpperBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)sig.boundKind());
    }

    static Type bindTy(Sig.TySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.kind()) {
            case BASE_TY_SIG: {
                return Type.PrimTy.create(((Sig.BaseTySig)sig).type(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case CLASS_TY_SIG: {
                return BytecodeBinder.bindClassTy((Sig.ClassTySig)sig, scope);
            }
            case TY_VAR_SIG: {
                return Type.TyVar.create(scope.apply(((Sig.TyVarSig)sig).name()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case ARRAY_TY_SIG: {
                return BytecodeBinder.bindArrayTy((Sig.ArrayTySig)sig, scope);
            }
            case WILD_TY_SIG: {
                return BytecodeBinder.wildTy((Sig.WildTySig)sig, scope);
            }
            case VOID_TY_SIG: {
                return Type.VOID;
            }
        }
        throw new AssertionError((Object)sig.kind());
    }

    private static Type bindArrayTy(Sig.ArrayTySig arrayTySig, Function<String, TyVarSymbol> scope) {
        return Type.ArrayTy.create(BytecodeBinder.bindTy(arrayTySig.elementType(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    public static Const bindValue(ClassFile.AnnotationInfo.ElementValue value) {
        switch (value.kind()) {
            case ENUM: {
                return BytecodeBinder.bindEnumValue((ClassFile.AnnotationInfo.ElementValue.EnumConstValue)value);
            }
            case CONST: {
                return ((ClassFile.AnnotationInfo.ElementValue.ConstValue)value).value();
            }
            case ARRAY: {
                return BytecodeBinder.bindArrayValue((ClassFile.AnnotationInfo.ElementValue.ArrayValue)value);
            }
            case CLASS: {
                return new TurbineClassValue(BytecodeBinder.bindTy(new SigParser(((ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue)value).className()).parseType(), x -> {
                    throw new IllegalStateException((String)x);
                }));
            }
            case ANNOTATION: {
                return BytecodeBinder.bindAnnotationValue(((ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue)value).annotation());
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    static TurbineAnnotationValue bindAnnotationValue(ClassFile.AnnotationInfo value) {
        ClassSymbol sym = BytecodeBinder.asClassSymbol(value.typeName());
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<String, ClassFile.AnnotationInfo.ElementValue> e : value.elementValuePairs().entrySet()) {
            values.put((Object)e.getKey(), (Object)BytecodeBinder.bindValue(e.getValue()));
        }
        return new TurbineAnnotationValue(new AnnoInfo(null, sym, null, (ImmutableMap<String, Const>)values.build()));
    }

    static ImmutableList<AnnoInfo> bindAnnotations(List<ClassFile.AnnotationInfo> input) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ClassFile.AnnotationInfo annotation : input) {
            TurbineAnnotationValue anno = BytecodeBinder.bindAnnotationValue(annotation);
            if (BytecodeBinder.shouldSkip(anno)) continue;
            result.add((Object)anno.info());
        }
        return result.build();
    }

    private static boolean shouldSkip(TurbineAnnotationValue anno) {
        return anno.sym().equals(ClassSymbol.PROFILE_ANNOTATION) || anno.sym().equals(ClassSymbol.PROPRIETARY_ANNOTATION);
    }

    private static ClassSymbol asClassSymbol(String s) {
        return new ClassSymbol(s.substring(1, s.length() - 1));
    }

    private static Const bindArrayValue(ClassFile.AnnotationInfo.ElementValue.ArrayValue value) {
        ImmutableList.Builder elements = ImmutableList.builder();
        for (ClassFile.AnnotationInfo.ElementValue element : value.elements()) {
            elements.add((Object)BytecodeBinder.bindValue(element));
        }
        return new Const.ArrayInitValue((ImmutableList<Const>)elements.build());
    }

    public static Const.Value bindConstValue(Type type, Const.Value value) {
        if (type.tyKind() != Type.TyKind.PRIM_TY) {
            return value;
        }
        switch (((Type.PrimTy)type).primkind()) {
            case CHAR: {
                return new Const.CharValue((char)BytecodeBinder.asInt(value));
            }
            case SHORT: {
                return new Const.ShortValue((short)BytecodeBinder.asInt(value));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(BytecodeBinder.asInt(value) != 0);
            }
            case BYTE: {
                return new Const.ByteValue((byte)BytecodeBinder.asInt(value));
            }
        }
        return value;
    }

    private static int asInt(Const.Value value) {
        return ((Const.IntValue)value).value();
    }

    private static Const bindEnumValue(ClassFile.AnnotationInfo.ElementValue.EnumConstValue value) {
        return new EnumConstantValue(new FieldSymbol(BytecodeBinder.asClassSymbol(value.typeName()), value.constName()));
    }

    public static ModuleInfo bindModuleInfo(String path, Supplier<byte[]> bytes) {
        ClassFile classFile = ClassReader.read(path, bytes.get());
        ClassFile.ModuleInfo module = classFile.module();
        Objects.requireNonNull(module, path);
        return new ModuleInfo(module.name(), module.version(), module.flags(), (ImmutableList<AnnoInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.RequireInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ExportInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.OpenInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.UseInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ProvideInfo>)ImmutableList.of());
    }

    private BytecodeBinder() {
    }
}

