/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineTypeMirror;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.jspecify.nullness.Nullable;

public class TurbineTypes
implements Types {
    private final ModelFactory factory;

    public TurbineTypes(ModelFactory factory) {
        this.factory = factory;
    }

    private static Type asTurbineType(TypeMirror typeMirror) {
        if (!(typeMirror instanceof TurbineTypeMirror)) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
        return ((TurbineTypeMirror)typeMirror).asTurbineType();
    }

    @Override
    public Element asElement(TypeMirror t) {
        switch (t.getKind()) {
            case DECLARED: {
                return ((TurbineTypeMirror.TurbineDeclaredType)t).asElement();
            }
            case TYPEVAR: {
                return ((TurbineTypeMirror.TurbineTypeVariable)t).asElement();
            }
            case ERROR: {
                return ((TurbineTypeMirror.TurbineErrorType)t).asElement();
            }
        }
        return null;
    }

    @Override
    public boolean isSameType(TypeMirror a, TypeMirror b) {
        Type t1 = TurbineTypes.asTurbineType(a);
        Type t2 = TurbineTypes.asTurbineType(b);
        if (t1.tyKind() == Type.TyKind.WILD_TY || t2.tyKind() == Type.TyKind.WILD_TY) {
            return false;
        }
        return this.isSameType(t1, t2);
    }

    private boolean isSameType(Type a, Type b) {
        switch (a.tyKind()) {
            case PRIM_TY: {
                return b.tyKind() == Type.TyKind.PRIM_TY && ((Type.PrimTy)a).primkind() == ((Type.PrimTy)b).primkind();
            }
            case VOID_TY: {
                return b.tyKind() == Type.TyKind.VOID_TY;
            }
            case NONE_TY: {
                return b.tyKind() == Type.TyKind.NONE_TY;
            }
            case CLASS_TY: {
                return this.isSameClassType((Type.ClassTy)a, b);
            }
            case ARRAY_TY: {
                return b.tyKind() == Type.TyKind.ARRAY_TY && this.isSameType(((Type.ArrayTy)a).elementType(), ((Type.ArrayTy)b).elementType());
            }
            case TY_VAR: {
                return b.tyKind() == Type.TyKind.TY_VAR && ((Type.TyVar)a).sym().equals(((Type.TyVar)b).sym());
            }
            case WILD_TY: {
                return this.isSameWildType((Type.WildTy)a, b);
            }
            case INTERSECTION_TY: {
                return b.tyKind() == Type.TyKind.INTERSECTION_TY && this.isSameIntersectionType((Type.IntersectionTy)a, (Type.IntersectionTy)b);
            }
            case METHOD_TY: {
                return b.tyKind() == Type.TyKind.METHOD_TY && this.isSameMethodType((Type.MethodTy)a, (Type.MethodTy)b);
            }
            case ERROR_TY: {
                return false;
            }
        }
        throw new AssertionError((Object)a.tyKind());
    }

    private boolean isSameMethodType(Type.MethodTy a, Type.MethodTy b) {
        ImmutableMap<TyVarSymbol, Type> mapping = TurbineTypes.getMapping(a, b);
        if (mapping == null) {
            return false;
        }
        if (!this.sameTypeParameterBounds(a, b, mapping)) {
            return false;
        }
        if (!this.isSameType(a.returnType(), this.subst(b.returnType(), (Map<TyVarSymbol, Type>)mapping))) {
            return false;
        }
        return this.isSameTypes(a.parameters(), this.substAll((ImmutableList<? extends Type>)b.parameters(), (Map<TyVarSymbol, Type>)mapping));
    }

    private boolean sameTypeParameterBounds(Type.MethodTy a, Type.MethodTy b, ImmutableMap<TyVarSymbol, Type> mapping) {
        if (a.tyParams().size() != b.tyParams().size()) {
            return false;
        }
        UnmodifiableIterator ax = a.tyParams().iterator();
        UnmodifiableIterator bx = b.tyParams().iterator();
        while (ax.hasNext()) {
            TyVarSymbol x = (TyVarSymbol)ax.next();
            TyVarSymbol y = (TyVarSymbol)bx.next();
            if (this.isSameType(this.factory.getTyVarInfo(x).upperBound(), this.subst(this.factory.getTyVarInfo(y).upperBound(), (Map<TyVarSymbol, Type>)mapping))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameTypes(ImmutableList<Type> a, ImmutableList<Type> b) {
        if (a.size() != b.size()) {
            return false;
        }
        UnmodifiableIterator ax = a.iterator();
        UnmodifiableIterator bx = b.iterator();
        while (ax.hasNext()) {
            if (this.isSameType((Type)ax.next(), (Type)bx.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameIntersectionType(Type.IntersectionTy a, Type.IntersectionTy b) {
        return this.isSameTypes(this.getBounds(a), this.getBounds(b));
    }

    private ImmutableList<Type> getBounds(Type.IntersectionTy a) {
        return TurbineTypes.getBounds(this.factory, a);
    }

    static ImmutableList<Type> getBounds(ModelFactory factory, Type.IntersectionTy type) {
        ImmutableList<Type> bounds = type.bounds();
        if (TurbineTypes.implicitObjectBound(factory, bounds)) {
            return ImmutableList.builder().add((Object)Type.ClassTy.OBJECT).addAll(bounds).build();
        }
        return bounds;
    }

    private static boolean implicitObjectBound(ModelFactory factory, ImmutableList<Type> bounds) {
        if (bounds.isEmpty()) {
            return true;
        }
        Type.ClassTy first = (Type.ClassTy)bounds.get(0);
        return factory.getSymbol(first.sym()).kind().equals((Object)TurbineTyKind.INTERFACE);
    }

    private boolean isSameWildType(Type.WildTy a, Type other) {
        switch (other.tyKind()) {
            case WILD_TY: {
                break;
            }
            case CLASS_TY: {
                return ((Type.ClassTy)other).sym().equals(ClassSymbol.OBJECT) && a.boundKind() == Type.WildTy.BoundKind.LOWER && a.bound().tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)a.bound()).sym().equals(ClassSymbol.OBJECT);
            }
            default: {
                return false;
            }
        }
        Type.WildTy b = (Type.WildTy)other;
        switch (a.boundKind()) {
            case NONE: {
                switch (b.boundKind()) {
                    case UPPER: {
                        return TurbineTypes.isObjectType(b.bound());
                    }
                    case LOWER: {
                        return false;
                    }
                    case NONE: {
                        return true;
                    }
                }
                break;
            }
            case UPPER: {
                switch (b.boundKind()) {
                    case UPPER: {
                        return this.isSameType(a.bound(), b.bound());
                    }
                    case LOWER: {
                        return false;
                    }
                    case NONE: {
                        return TurbineTypes.isObjectType(a.bound());
                    }
                }
                break;
            }
            case LOWER: {
                return b.boundKind() == Type.WildTy.BoundKind.LOWER && this.isSameType(a.bound(), b.bound());
            }
        }
        throw new AssertionError((Object)a.boundKind());
    }

    private boolean isSameClassType(Type.ClassTy a, Type other) {
        switch (other.tyKind()) {
            case CLASS_TY: {
                break;
            }
            case WILD_TY: {
                Type.WildTy w = (Type.WildTy)other;
                return a.sym().equals(ClassSymbol.OBJECT) && w.boundKind() == Type.WildTy.BoundKind.LOWER && w.bound().tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)w.bound()).sym().equals(ClassSymbol.OBJECT);
            }
            default: {
                return false;
            }
        }
        Type.ClassTy b = (Type.ClassTy)other;
        if (!a.sym().equals(b.sym())) {
            return false;
        }
        UnmodifiableIterator ax = a.classes().reverse().iterator();
        UnmodifiableIterator bx = b.classes().reverse().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.isSameSimpleClassType((Type.ClassTy.SimpleClassTy)ax.next(), (Type.ClassTy.SimpleClassTy)bx.next())) continue;
            return false;
        }
        return !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)ax) && !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)bx);
    }

    private static boolean hasTyArgs(Iterator<Type.ClassTy.SimpleClassTy> it) {
        while (it.hasNext()) {
            if (it.next().targs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isSameSimpleClassType(Type.ClassTy.SimpleClassTy a, Type.ClassTy.SimpleClassTy b) {
        return a.sym().equals(b.sym()) && this.isSameTypes(a.targs(), b.targs());
    }

    @Override
    public boolean isSubtype(TypeMirror a, TypeMirror b) {
        return this.isSubtype(TurbineTypes.asTurbineType(a), TurbineTypes.asTurbineType(b), true);
    }

    private boolean isSubtype(Type a, Type b, boolean strict) {
        if (b.tyKind() == Type.TyKind.INTERSECTION_TY) {
            for (Type bound : this.getBounds((Type.IntersectionTy)b)) {
                if (this.isSubtype(a, bound, true)) continue;
                return false;
            }
            return true;
        }
        switch (a.tyKind()) {
            case CLASS_TY: {
                return this.isClassSubtype((Type.ClassTy)a, b, strict);
            }
            case PRIM_TY: {
                return TurbineTypes.isPrimSubtype((Type.PrimTy)a, b);
            }
            case ARRAY_TY: {
                return this.isArraySubtype((Type.ArrayTy)a, b, strict);
            }
            case TY_VAR: {
                return this.isTyVarSubtype((Type.TyVar)a, b, strict);
            }
            case INTERSECTION_TY: {
                return this.isIntersectionSubtype((Type.IntersectionTy)a, b, strict);
            }
            case VOID_TY: {
                return b.tyKind() == Type.TyKind.VOID_TY;
            }
            case NONE_TY: {
                return b.tyKind() == Type.TyKind.NONE_TY;
            }
            case WILD_TY: {
                return false;
            }
            case ERROR_TY: {
                return true;
            }
            case METHOD_TY: {
                return false;
            }
        }
        throw new AssertionError((Object)a.tyKind());
    }

    private boolean isTyVarSubtype(Type.TyVar a, Type b, boolean strict) {
        if (b.tyKind() == Type.TyKind.TY_VAR) {
            return a.sym().equals(((Type.TyVar)b).sym());
        }
        TypeBoundClass.TyVarInfo tyVarInfo = this.factory.getTyVarInfo(a.sym());
        return this.isSubtype(tyVarInfo.upperBound(), b, strict);
    }

    private boolean isIntersectionSubtype(Type.IntersectionTy a, Type b, boolean strict) {
        for (Type bound : this.getBounds(a)) {
            if (!this.isSubtype(bound, b, strict)) continue;
            return true;
        }
        return false;
    }

    private boolean isArraySubtype(Type.ArrayTy a, Type b, boolean strict) {
        switch (b.tyKind()) {
            case ARRAY_TY: {
                Type ae = a.elementType();
                Type be = ((Type.ArrayTy)b).elementType();
                if (ae.tyKind() == Type.TyKind.PRIM_TY) {
                    return this.isSameType(ae, be);
                }
                return this.isSubtype(ae, be, strict);
            }
            case CLASS_TY: {
                ClassSymbol bsym = ((Type.ClassTy)b).sym();
                switch (bsym.binaryName()) {
                    case "java/lang/Object": 
                    case "java/lang/Cloneable": 
                    case "java/io/Serializable": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isPrimSubtype(Type.PrimTy a, Type other) {
        if (other.tyKind() != Type.TyKind.PRIM_TY) {
            return false;
        }
        Type.PrimTy b = (Type.PrimTy)other;
        switch (a.primkind()) {
            case CHAR: {
                switch (b.primkind()) {
                    case CHAR: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case BYTE: {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BYTE: 
                    case SHORT: {
                        return true;
                    }
                }
                return false;
            }
            case SHORT: {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case SHORT: {
                        return true;
                    }
                }
                return false;
            }
            case INT: {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case LONG: {
                switch (b.primkind()) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case FLOAT: {
                switch (b.primkind()) {
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return a.primkind() == b.primkind();
            }
        }
        throw new AssertionError((Object)a.primkind());
    }

    private boolean isClassSubtype(Type.ClassTy a, Type other, boolean strict) {
        if (other.tyKind() != Type.TyKind.CLASS_TY) {
            return false;
        }
        Type.ClassTy b = (Type.ClassTy)other;
        if (!a.sym().equals(b.sym())) {
            ImmutableList<Type.ClassTy> path = this.factory.cha().search(a, b.sym());
            if (path.isEmpty()) {
                return false;
            }
            a = (Type.ClassTy)path.get(0);
            for (Type.ClassTy ty : path) {
                ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(ty);
                if (mapping == null) {
                    a = (Type.ClassTy)this.erasure(a);
                    break;
                }
                a = this.substClassTy(a, (Map<TyVarSymbol, Type>)mapping);
            }
        }
        UnmodifiableIterator ax = a.classes().reverse().iterator();
        UnmodifiableIterator bx = b.classes().reverse().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.tyArgsContains((Type.ClassTy.SimpleClassTy)ax.next(), (Type.ClassTy.SimpleClassTy)bx.next(), strict)) continue;
            return false;
        }
        return !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)ax) && !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)bx);
    }

    private boolean tyArgsContains(Type.ClassTy.SimpleClassTy a, Type.ClassTy.SimpleClassTy b, boolean strict) {
        Verify.verify((boolean)a.sym().equals(b.sym()));
        UnmodifiableIterator ax = a.targs().iterator();
        UnmodifiableIterator bx = b.targs().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.containedBy((Type)ax.next(), (Type)bx.next(), strict)) continue;
            return false;
        }
        if (strict) {
            return !bx.hasNext();
        }
        return true;
    }

    private Type subst(Type type, Map<TyVarSymbol, Type> mapping) {
        switch (type.tyKind()) {
            case CLASS_TY: {
                return this.substClassTy((Type.ClassTy)type, mapping);
            }
            case ARRAY_TY: {
                return this.substArrayTy((Type.ArrayTy)type, mapping);
            }
            case TY_VAR: {
                return this.substTyVar((Type.TyVar)type, mapping);
            }
            case PRIM_TY: 
            case VOID_TY: 
            case NONE_TY: 
            case ERROR_TY: {
                return type;
            }
            case METHOD_TY: {
                return this.substMethod((Type.MethodTy)type, mapping);
            }
            case INTERSECTION_TY: {
                return this.substIntersectionTy((Type.IntersectionTy)type, mapping);
            }
            case WILD_TY: {
                return this.substWildTy((Type.WildTy)type, mapping);
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private Type substWildTy(Type.WildTy type, Map<TyVarSymbol, Type> mapping) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(this.subst(type.bound(), mapping), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(this.subst(type.bound(), mapping), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private Type substIntersectionTy(Type.IntersectionTy type, Map<TyVarSymbol, Type> mapping) {
        return Type.IntersectionTy.create(this.substAll(this.getBounds(type), mapping));
    }

    private Type.MethodTy substMethod(Type.MethodTy method, Map<TyVarSymbol, Type> mapping) {
        return Type.MethodTy.create(method.tyParams(), this.subst(method.returnType(), mapping), method.receiverType() != null ? this.subst(method.receiverType(), mapping) : null, this.substAll(method.parameters(), mapping), this.substAll(method.thrown(), mapping));
    }

    private ImmutableList<Type> substAll(ImmutableList<? extends Type> types, Map<TyVarSymbol, Type> mapping) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)this.subst(type, mapping));
        }
        return result.build();
    }

    private Type substTyVar(Type.TyVar type, Map<TyVarSymbol, Type> mapping) {
        return mapping.getOrDefault(type.sym(), type);
    }

    private Type substArrayTy(Type.ArrayTy type, Map<TyVarSymbol, Type> mapping) {
        return Type.ArrayTy.create(this.subst(type.elementType(), mapping), type.annos());
    }

    private Type.ClassTy substClassTy(Type.ClassTy type, Map<TyVarSymbol, Type> mapping) {
        ImmutableList.Builder simples = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy simple : type.classes()) {
            ImmutableList.Builder args = ImmutableList.builder();
            for (Type arg : simple.targs()) {
                args.add((Object)this.subst(arg, mapping));
            }
            simples.add((Object)Type.ClassTy.SimpleClassTy.create(simple.sym(), (ImmutableList<Type>)args.build(), simple.annos()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    private static @Nullable ImmutableMap<TyVarSymbol, Type> getMapping(Type.MethodTy a, Type.MethodTy b) {
        if (a.tyParams().size() != b.tyParams().size()) {
            return null;
        }
        UnmodifiableIterator ax = a.tyParams().iterator();
        UnmodifiableIterator bx = b.tyParams().iterator();
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        while (ax.hasNext()) {
            TyVarSymbol s = (TyVarSymbol)ax.next();
            TyVarSymbol t = (TyVarSymbol)bx.next();
            mapping.put((Object)t, (Object)Type.TyVar.create(s, (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return mapping.build();
    }

    private @Nullable ImmutableMap<TyVarSymbol, Type> getMapping(Type.ClassTy ty) {
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        for (Type.ClassTy.SimpleClassTy s : ty.classes()) {
            TypeBoundClass info = this.factory.getSymbol(s.sym());
            if (s.targs().isEmpty() && !info.typeParameters().isEmpty()) {
                return null;
            }
            UnmodifiableIterator ax = info.typeParameters().values().iterator();
            UnmodifiableIterator bx = s.targs().iterator();
            while (ax.hasNext()) {
                mapping.put((Object)((TyVarSymbol)ax.next()), (Object)((Type)bx.next()));
            }
            Verify.verify((!bx.hasNext() ? 1 : 0) != 0);
        }
        return mapping.build();
    }

    @Override
    public boolean isAssignable(TypeMirror a1, TypeMirror a2) {
        return this.isAssignable(TurbineTypes.asTurbineType(a1), TurbineTypes.asTurbineType(a2));
    }

    private boolean isAssignable(Type t1, Type t2) {
        block0 : switch (t1.tyKind()) {
            case PRIM_TY: {
                if (t2.tyKind() != Type.TyKind.CLASS_TY) break;
                ClassSymbol boxed = TurbineTypes.boxedClass(((Type.PrimTy)t1).primkind());
                t1 = Type.ClassTy.asNonParametricClassTy(boxed);
                break;
            }
            case CLASS_TY: {
                switch (t2.tyKind()) {
                    case PRIM_TY: {
                        TurbineConstantTypeKind unboxed = TurbineTypes.unboxedType((Type.ClassTy)t1);
                        if (unboxed == null) {
                            return false;
                        }
                        t1 = Type.PrimTy.create(unboxed, (ImmutableList<AnnoInfo>)ImmutableList.of());
                        break block0;
                    }
                    case CLASS_TY: {
                        break block0;
                    }
                }
                break;
            }
        }
        return this.isSubtype(t1, t2, false);
    }

    private static boolean isObjectType(Type type) {
        return type.tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)type).sym().equals(ClassSymbol.OBJECT);
    }

    @Override
    public boolean contains(TypeMirror a, TypeMirror b) {
        return this.contains(TurbineTypes.asTurbineType(a), TurbineTypes.asTurbineType(b), true);
    }

    private boolean contains(Type t1, Type t2, boolean strict) {
        return this.containedBy(t2, t1, strict);
    }

    private boolean containedBy(Type t1, Type t2, boolean strict) {
        if (t1.tyKind() == Type.TyKind.WILD_TY) {
            Type.WildTy w1 = (Type.WildTy)t1;
            switch (w1.boundKind()) {
                case UPPER: {
                    Type t = w1.bound();
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case UPPER: {
                                return this.isSubtype(t, w2.bound(), strict);
                            }
                            case NONE: {
                                return true;
                            }
                            case LOWER: {
                                return false;
                            }
                        }
                        throw new AssertionError((Object)w1.boundKind());
                    }
                    return false;
                }
                case LOWER: {
                    Type t = w1.bound();
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case LOWER: {
                                return this.isSubtype(w2.bound(), t, strict);
                            }
                            case NONE: {
                                return true;
                            }
                            case UPPER: {
                                return TurbineTypes.isObjectType(w2.bound());
                            }
                        }
                        throw new AssertionError((Object)w2.boundKind());
                    }
                    return TurbineTypes.isObjectType(t2) && TurbineTypes.isObjectType(t);
                }
                case NONE: {
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case NONE: {
                                return true;
                            }
                            case LOWER: {
                                return false;
                            }
                            case UPPER: {
                                return TurbineTypes.isObjectType(w2.bound());
                            }
                        }
                        throw new AssertionError((Object)w2.boundKind());
                    }
                    return false;
                }
            }
            throw new AssertionError((Object)w1.boundKind());
        }
        if (t2.tyKind() == Type.TyKind.WILD_TY) {
            Type.WildTy w2 = (Type.WildTy)t2;
            switch (w2.boundKind()) {
                case LOWER: {
                    return this.isSubtype(w2.bound(), t1, strict);
                }
                case UPPER: {
                    return this.isSubtype(t1, w2.bound(), strict);
                }
                case NONE: {
                    return true;
                }
            }
            throw new AssertionError((Object)w2.boundKind());
        }
        return this.isSameType(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.isSubsignature((Type.MethodTy)TurbineTypes.asTurbineType(m1), (Type.MethodTy)TurbineTypes.asTurbineType(m2));
    }

    private boolean isSubsignature(Type.MethodTy a, Type.MethodTy b) {
        return this.isSameSignature(a, b) || this.isSameSignature(a, (Type.MethodTy)this.erasure(b));
    }

    private boolean isSameSignature(Type.MethodTy a, Type.MethodTy b) {
        if (a.parameters().size() != b.parameters().size()) {
            return false;
        }
        ImmutableMap<TyVarSymbol, Type> mapping = TurbineTypes.getMapping(a, b);
        if (mapping == null) {
            return false;
        }
        if (!this.sameTypeParameterBounds(a, b, mapping)) {
            return false;
        }
        UnmodifiableIterator ax = a.parameters().iterator();
        UnmodifiableIterator bx = this.substAll((ImmutableList<? extends Type>)b.parameters(), (Map<TyVarSymbol, Type>)mapping).iterator();
        while (ax.hasNext()) {
            if (this.isSameType((Type)ax.next(), (Type)bx.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror m) {
        return this.factory.asTypeMirrors((Iterable<? extends Type>)TurbineTypes.deannotate(this.directSupertypes(TurbineTypes.asTurbineType(m))));
    }

    public ImmutableList<Type> directSupertypes(Type t) {
        switch (t.tyKind()) {
            case CLASS_TY: {
                return this.directSupertypes((Type.ClassTy)t);
            }
            case INTERSECTION_TY: {
                return ((Type.IntersectionTy)t).bounds();
            }
            case TY_VAR: {
                return this.getBounds(this.factory.getTyVarInfo(((Type.TyVar)t).sym()).upperBound());
            }
            case ARRAY_TY: {
                return this.directSupertypes((Type.ArrayTy)t);
            }
            case PRIM_TY: 
            case VOID_TY: 
            case NONE_TY: 
            case WILD_TY: 
            case ERROR_TY: {
                return ImmutableList.of();
            }
        }
        throw new IllegalArgumentException(t.tyKind().name());
    }

    private ImmutableList<Type> directSupertypes(Type.ArrayTy t) {
        Type elem = t.elementType();
        if (elem.tyKind() == Type.TyKind.PRIM_TY || TurbineTypes.isObjectType(elem)) {
            return ImmutableList.of((Object)Type.IntersectionTy.create((ImmutableList<Type>)ImmutableList.of((Object)Type.ClassTy.OBJECT, (Object)Type.ClassTy.SERIALIZABLE, (Object)Type.ClassTy.CLONEABLE)));
        }
        ImmutableList<Type> ex = this.directSupertypes(elem);
        return ImmutableList.of((Object)Type.ArrayTy.create((Type)ex.iterator().next(), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private ImmutableList<Type> directSupertypes(Type.ClassTy t) {
        if (t.sym().equals(ClassSymbol.OBJECT)) {
            return ImmutableList.of();
        }
        TypeBoundClass info = this.factory.getSymbol(t.sym());
        ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(t);
        boolean raw = mapping == null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (info.superClassType() != null) {
            builder.add((Object)(raw ? this.erasure(info.superClassType()) : this.subst(info.superClassType(), (Map<TyVarSymbol, Type>)mapping)));
        } else {
            builder.add((Object)Type.ClassTy.OBJECT);
        }
        for (Type interfaceType : info.interfaceTypes()) {
            builder.add((Object)(raw ? this.erasure(interfaceType) : this.subst(interfaceType, (Map<TyVarSymbol, Type>)mapping)));
        }
        return builder.build();
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        Type t = this.erasure(TurbineTypes.asTurbineType(typeMirror));
        if (t.tyKind() == Type.TyKind.CLASS_TY) {
            t = TurbineTypes.deannotate(t);
        }
        return this.factory.asTypeMirror(t);
    }

    private Type erasure(Type type) {
        return Erasure.erase(type, new Function<TyVarSymbol, TypeBoundClass.TyVarInfo>(){

            public TypeBoundClass.TyVarInfo apply(TyVarSymbol input) {
                return TurbineTypes.this.factory.getTyVarInfo(input);
            }
        });
    }

    private static Type deannotate(Type ty) {
        switch (ty.tyKind()) {
            case CLASS_TY: {
                return TurbineTypes.deannotateClassTy((Type.ClassTy)ty);
            }
            case ARRAY_TY: {
                return TurbineTypes.deannotateArrayTy((Type.ArrayTy)ty);
            }
            case PRIM_TY: 
            case VOID_TY: 
            case NONE_TY: 
            case TY_VAR: 
            case WILD_TY: 
            case INTERSECTION_TY: 
            case METHOD_TY: 
            case ERROR_TY: {
                return ty;
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private static ImmutableList<Type> deannotate(ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)TurbineTypes.deannotate(type));
        }
        return result.build();
    }

    private static Type.ArrayTy deannotateArrayTy(Type.ArrayTy ty) {
        return Type.ArrayTy.create(TurbineTypes.deannotate(ty.elementType()), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    public static Type.ClassTy deannotateClassTy(Type.ClassTy ty) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : ty.classes()) {
            classes.add((Object)Type.ClassTy.SimpleClassTy.create(c.sym(), TurbineTypes.deannotate(c.targs()), (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.factory.typeElement(TurbineTypes.boxedClass(((Type.PrimTy)TurbineTypes.asTurbineType(p)).primkind()));
    }

    static ClassSymbol boxedClass(TurbineConstantTypeKind kind) {
        switch (kind) {
            case CHAR: {
                return ClassSymbol.CHARACTER;
            }
            case SHORT: {
                return ClassSymbol.SHORT;
            }
            case INT: {
                return ClassSymbol.INTEGER;
            }
            case LONG: {
                return ClassSymbol.LONG;
            }
            case FLOAT: {
                return ClassSymbol.FLOAT;
            }
            case DOUBLE: {
                return ClassSymbol.DOUBLE;
            }
            case BOOLEAN: {
                return ClassSymbol.BOOLEAN;
            }
            case BYTE: {
                return ClassSymbol.BYTE;
            }
        }
        throw new AssertionError((Object)kind);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        Type type = TurbineTypes.asTurbineType(typeMirror);
        if (type.tyKind() != Type.TyKind.CLASS_TY) {
            throw new IllegalArgumentException(type.toString());
        }
        TurbineConstantTypeKind unboxed = TurbineTypes.unboxedType((Type.ClassTy)type);
        if (unboxed == null) {
            throw new IllegalArgumentException(type.toString());
        }
        return (PrimitiveType)this.factory.asTypeMirror(Type.PrimTy.create(unboxed, (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private static TurbineConstantTypeKind unboxedType(Type.ClassTy classTy) {
        switch (classTy.sym().binaryName()) {
            case "java/lang/Boolean": {
                return TurbineConstantTypeKind.BOOLEAN;
            }
            case "java/lang/Byte": {
                return TurbineConstantTypeKind.BYTE;
            }
            case "java/lang/Short": {
                return TurbineConstantTypeKind.SHORT;
            }
            case "java/lang/Integer": {
                return TurbineConstantTypeKind.INT;
            }
            case "java/lang/Long": {
                return TurbineConstantTypeKind.LONG;
            }
            case "java/lang/Character": {
                return TurbineConstantTypeKind.CHAR;
            }
            case "java/lang/Float": {
                return TurbineConstantTypeKind.FLOAT;
            }
            case "java/lang/Double": {
                return TurbineConstantTypeKind.DOUBLE;
            }
        }
        return null;
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        Preconditions.checkArgument((boolean)kind.isPrimitive(), (String)"%s is not a primitive type", (Object)((Object)kind));
        return (PrimitiveType)this.factory.asTypeMirror(Type.PrimTy.create(TurbineTypes.primitiveType(kind), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private static TurbineConstantTypeKind primitiveType(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return TurbineConstantTypeKind.BOOLEAN;
            }
            case BYTE: {
                return TurbineConstantTypeKind.BYTE;
            }
            case SHORT: {
                return TurbineConstantTypeKind.SHORT;
            }
            case INT: {
                return TurbineConstantTypeKind.INT;
            }
            case LONG: {
                return TurbineConstantTypeKind.LONG;
            }
            case CHAR: {
                return TurbineConstantTypeKind.CHAR;
            }
            case FLOAT: {
                return TurbineConstantTypeKind.FLOAT;
            }
            case DOUBLE: {
                return TurbineConstantTypeKind.DOUBLE;
            }
        }
        throw new IllegalArgumentException((Object)((Object)kind) + " is not a primitive type");
    }

    @Override
    public NullType getNullType() {
        return this.factory.nullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        switch (kind) {
            case VOID: {
                return (NoType)this.factory.asTypeMirror(Type.VOID);
            }
            case NONE: {
                return this.factory.noType();
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return (ArrayType)this.factory.asTypeMirror(Type.ArrayTy.create(TurbineTypes.asTurbineType(componentType), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        Type.WildTy type = extendsBound != null ? Type.WildUpperBoundedTy.create(TurbineTypes.asTurbineType(extendsBound), (ImmutableList<AnnoInfo>)ImmutableList.of()) : (superBound != null ? Type.WildLowerBoundedTy.create(TurbineTypes.asTurbineType(superBound), (ImmutableList<AnnoInfo>)ImmutableList.of()) : Type.WildUnboundedTy.create((ImmutableList<AnnoInfo>)ImmutableList.of()));
        return (WildcardType)this.factory.asTypeMirror(type);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        Objects.requireNonNull(typeElem);
        ImmutableList.Builder args = ImmutableList.builder();
        for (TypeMirror t : typeArgs) {
            args.add((Object)TurbineTypes.asTurbineType(t));
        }
        TurbineElement.TurbineTypeElement element = (TurbineElement.TurbineTypeElement)typeElem;
        return (DeclaredType)this.factory.asTypeMirror(Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.of((Object)Type.ClassTy.SimpleClassTy.create(element.sym(), (ImmutableList<Type>)args.build(), (ImmutableList<AnnoInfo>)ImmutableList.of()))));
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        if (containing == null) {
            return this.getDeclaredType(typeElem, typeArgs);
        }
        Objects.requireNonNull(typeElem);
        Type.ClassTy base = (Type.ClassTy)TurbineTypes.asTurbineType(containing);
        TurbineElement.TurbineTypeElement element = (TurbineElement.TurbineTypeElement)typeElem;
        ImmutableList.Builder args = ImmutableList.builder();
        for (TypeMirror t : typeArgs) {
            args.add((Object)TurbineTypes.asTurbineType(t));
        }
        return (DeclaredType)this.factory.asTypeMirror(Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.builder().addAll(base.classes()).add((Object)Type.ClassTy.SimpleClassTy.create(element.sym(), (ImmutableList<Type>)args.build(), (ImmutableList<AnnoInfo>)ImmutableList.of())).build()));
    }

    private static ClassSymbol enclosingClass(Symbol symbol) {
        switch (symbol.symKind()) {
            case CLASS: {
                return (ClassSymbol)symbol;
            }
            case TY_PARAM: {
                return TurbineTypes.enclosingClass(((TyVarSymbol)symbol).owner());
            }
            case METHOD: {
                return ((MethodSymbol)symbol).owner();
            }
            case FIELD: {
                return ((FieldSymbol)symbol).owner();
            }
            case PARAMETER: {
                return ((ParamSymbol)symbol).owner().owner();
            }
            case RECORD_COMPONENT: {
                return ((RecordComponentSymbol)symbol).owner();
            }
            case MODULE: 
            case PACKAGE: {
                throw new IllegalArgumentException(symbol.symKind().toString());
            }
        }
        throw new AssertionError((Object)symbol.symKind());
    }

    private static Type type(Element element) {
        switch (element.getKind()) {
            case TYPE_PARAMETER: {
                return Type.TyVar.create(((TurbineElement.TurbineTypeParameterElement)element).sym(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case FIELD: {
                return ((TurbineElement.TurbineFieldElement)element).info().type();
            }
            case METHOD: 
            case CONSTRUCTOR: {
                return ((TurbineElement.TurbineExecutableElement)element).info().asType();
            }
        }
        throw new UnsupportedOperationException(element.toString());
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        Type.ClassTy c = ((TurbineTypeMirror.TurbineDeclaredType)containing).asTurbineType();
        ClassSymbol symbol = TurbineTypes.enclosingClass(((TurbineElement)element).sym());
        ImmutableList<Type.ClassTy> path = this.factory.cha().search(c, TurbineTypes.enclosingClass(symbol));
        if (path.isEmpty()) {
            return null;
        }
        Type type = TurbineTypes.type(element);
        for (Type.ClassTy ty : path) {
            ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(ty);
            if (mapping == null) {
                type = this.erasure(type);
                break;
            }
            type = this.subst(type, (Map<TyVarSymbol, Type>)mapping);
        }
        return this.factory.asTypeMirror(type);
    }
}

