/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;

public class TestNgMatchers {
    public static boolean hasTestNgAnnotation(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(tree);
        if (methodSym == null) {
            return false;
        }
        if (TestNgMatchers.hasTestNgAttr(methodSym)) {
            return true;
        }
        return ASTHelpers.findSuperMethods(methodSym, state.getTypes()).stream().anyMatch(TestNgMatchers::hasTestNgAttr);
    }

    public static boolean hasTestNgAnnotation(ClassTree tree) {
        Symbol.ClassSymbol classSym = ASTHelpers.getSymbol(tree);
        return classSym != null && TestNgMatchers.hasTestNgAttr(classSym);
    }

    private static boolean hasTestNgAttr(Symbol methodSym) {
        return methodSym.getRawAttributes().stream().anyMatch(attr -> attr.type.tsym.getQualifiedName().toString().startsWith("org.testng."));
    }

    private TestNgMatchers() {
    }
}

