/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import java.lang.reflect.Method;

public final class RuntimeVersion {
    private static final int MAJOR = RuntimeVersion.getMajor();

    private static int getMajor() {
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object version = versionMethod.invoke(null, new Object[0]);
            return (Integer)version.getClass().getMethod("major", new Class[0]).invoke(version, new Object[0]);
        }
        catch (Exception versionMethod) {
            int version = (int)Double.parseDouble(System.getProperty("java.class.version"));
            if (49 <= version && version <= 52) {
                return version - 44;
            }
            throw new IllegalStateException("Unknown Java version: " + System.getProperty("java.specification.version"));
        }
    }

    public static boolean isAtLeast8() {
        return MAJOR >= 8;
    }

    public static boolean isAtLeast9() {
        return MAJOR >= 9;
    }

    public static boolean isAtLeast10() {
        return MAJOR >= 10;
    }

    public static boolean isAtMost10() {
        return MAJOR <= 10;
    }

    public static boolean isAtLeast11() {
        return MAJOR >= 11;
    }

    public static boolean isAtLeast12() {
        return MAJOR >= 12;
    }

    public static boolean isAtLeast13() {
        return MAJOR >= 13;
    }

    public static boolean isAtLeast14() {
        return MAJOR >= 14;
    }

    public static boolean isAtLeast15() {
        return MAJOR >= 15;
    }

    public static boolean isAtLeast16() {
        return MAJOR >= 16;
    }

    public static boolean isAtLeast17() {
        return MAJOR >= 17;
    }

    public static int release() {
        return MAJOR;
    }

    private RuntimeVersion() {
    }
}

