# Testing Workloads

Workloads based on packages in `artifacts` can be installed, and used for testing.

- This is done by installing a specified SDK version (`$(SdkVersionForWorkloadTesting)`) in `artifacts/bin/dotnet-net7`.
- Then the manifest for the workload in `@(WorkloadIdForTesting)` is installed
    - Then workload packs are installed
    - packs, or manifests not generated by `runtime`, are restored from nuget

- The SDK is installed by `ProvisionSdkForWorkloadTesting` target
- and the workload is installed by `InstallWorkloadUsingArtifacts` target, using the `InstallWorkloadFromArtifacts` task

- `@(WorkloadIdForTesting)`:

Example for wasm:
```xml
    <WorkloadIdForTesting Include="wasm-tools"
                          Name="microsoft.net.workload.mono.toolchain"
                          ManifestName="Microsoft.NET.Workload.Mono.ToolChain"
                          Version="$(PackageVersion)"
                          VersionBand="$(SdkBandVersion)" />
```

- Currently, this is used only by `src/tests/BuildWasmApps/Wasm.Build.Tests`

## Multiple runtime packs

The workload depends on three runtime packs - single threaded, multithreaded, and for perf tracing. If you have a local
runtime build, for say multithreaded, then the workload install will fail because of missing runtime pack nugets for
the other two variants.

For non-CI builds, we build the same runtime pack nuget but with the different expected names. So, essentially you get all
the expected nugets, but they are all the same except for the name.

If you have all the nugets available, and want to avoid the above behavior then set `WasmSkipMissingRuntimeBuild=true`.

## Limitations:

- The cross compiler package is built manually from the `InstallWorkloadUsingArtifacts` target
