// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Reflection.TypeLoading
{
    internal static class Utf8Constants
    {
        public static ReadOnlySpan<byte> System => "System"u8;
        public static ReadOnlySpan<byte> SystemReflection => "System.Reflection"u8;
        public static ReadOnlySpan<byte> SystemCollectionsGeneric => "System.Collections.Generic"u8;
        public static ReadOnlySpan<byte> SystemRuntimeInteropServices => "System.Runtime.InteropServices"u8;
        public static ReadOnlySpan<byte> SystemRuntimeCompilerServices => "System.Runtime.CompilerServices"u8;

        public static ReadOnlySpan<byte> Array => "Array"u8;
        public static ReadOnlySpan<byte> Boolean => "Boolean"u8;
        public static ReadOnlySpan<byte> Byte => "Byte"u8;
        public static ReadOnlySpan<byte> Char => "Char"u8;
        public static ReadOnlySpan<byte> Double => "Double"u8;
        public static ReadOnlySpan<byte> Enum => "Enum"u8;
        public static ReadOnlySpan<byte> Int16 => "Int16"u8;
        public static ReadOnlySpan<byte> Int32 => "Int32"u8;
        public static ReadOnlySpan<byte> Int64 => "Int64"u8;
        public static ReadOnlySpan<byte> IntPtr => "IntPtr"u8;
        public static ReadOnlySpan<byte> Object => "Object"u8;
        public static ReadOnlySpan<byte> NullableT => "Nullable`1"u8;
        public static ReadOnlySpan<byte> SByte => "SByte"u8;
        public static ReadOnlySpan<byte> Single => "Single"u8;
        public static ReadOnlySpan<byte> String => "String"u8;
        public static ReadOnlySpan<byte> TypedReference => "TypedReference"u8;
        public static ReadOnlySpan<byte> UInt16 => "UInt16"u8;
        public static ReadOnlySpan<byte> UInt32 => "UInt32"u8;
        public static ReadOnlySpan<byte> UInt64 => "UInt64"u8;
        public static ReadOnlySpan<byte> UIntPtr => "UIntPtr"u8;
        public static ReadOnlySpan<byte> ValueType => "ValueType"u8;
        public static ReadOnlySpan<byte> Void => "Void"u8;
        public static ReadOnlySpan<byte> MulticastDelegate => "MulticastDelegate"u8;
        public static ReadOnlySpan<byte> IEnumerableT => "IEnumerable`1"u8;
        public static ReadOnlySpan<byte> ICollectionT => "ICollection`1"u8;
        public static ReadOnlySpan<byte> IListT => "IList`1"u8;
        public static ReadOnlySpan<byte> IReadOnlyListT => "IReadOnlyList`1"u8;
        public static ReadOnlySpan<byte> Type => "Type"u8;
        public static ReadOnlySpan<byte> DBNull => "DBNull"u8;
        public static ReadOnlySpan<byte> Decimal => "Decimal"u8;
        public static ReadOnlySpan<byte> DateTime => "DateTime"u8;
        public static ReadOnlySpan<byte> ComImportAttribute => "ComImportAttribute"u8;
        public static ReadOnlySpan<byte> DllImportAttribute => "DllImportAttribute"u8;
        public static ReadOnlySpan<byte> CallingConvention => "CallingConvention"u8;
        public static ReadOnlySpan<byte> CharSet => "CharSet"u8;
        public static ReadOnlySpan<byte> MarshalAsAttribute => "MarshalAsAttribute"u8;
        public static ReadOnlySpan<byte> UnmanagedType => "UnmanagedType"u8;
        public static ReadOnlySpan<byte> VarEnum => "VarEnum"u8;
        public static ReadOnlySpan<byte> InAttribute => "InAttribute"u8;
        public static ReadOnlySpan<byte> OutAttriubute => "OutAttribute"u8;
        public static ReadOnlySpan<byte> OptionalAttribute => "OptionalAttribute"u8;
        public static ReadOnlySpan<byte> PreserveSigAttribute => "PreserveSigAttribute"u8;
        public static ReadOnlySpan<byte> FieldOffsetAttribute => "FieldOffsetAttribute"u8;
        public static ReadOnlySpan<byte> IsByRefLikeAttribute => "IsByRefLikeAttribute"u8;
        public static ReadOnlySpan<byte> DecimalConstantAttribute => "DecimalConstantAttribute"u8;
        public static ReadOnlySpan<byte> CustomConstantAttribute => "CustomConstantAttribute"u8;
        public static ReadOnlySpan<byte> GuidAttribute => "GuidAttribute"u8;
        public static ReadOnlySpan<byte> DefaultMemberAttribute => "DefaultMemberAttribute"u8;
        public static ReadOnlySpan<byte> DateTimeConstantAttribute => "DateTimeConstantAttribute"u8;
    }
}
