// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["FusedMultiplySubtractBySelectedScalar.Vector128.Single.Vector128.Single.3"] = FusedMultiplySubtractBySelectedScalar_Vector128_Single_Vector128_Single_3,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Double.Vector128.Double.1"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Double_Vector128_Double_1,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Single.Vector64.Single.1"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Single.Vector128.Single.3"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["InsertSelectedScalar.Vector64.Byte.7.Vector64.Byte.7"] = InsertSelectedScalar_Vector64_Byte_7_Vector64_Byte_7,
                ["InsertSelectedScalar.Vector64.Byte.7.Vector128.Byte.15"] = InsertSelectedScalar_Vector64_Byte_7_Vector128_Byte_15,
                ["InsertSelectedScalar.Vector64.Int16.3.Vector64.Int16.3"] = InsertSelectedScalar_Vector64_Int16_3_Vector64_Int16_3,
                ["InsertSelectedScalar.Vector64.Int16.3.Vector128.Int16.7"] = InsertSelectedScalar_Vector64_Int16_3_Vector128_Int16_7,
                ["InsertSelectedScalar.Vector64.Int32.1.Vector64.Int32.1"] = InsertSelectedScalar_Vector64_Int32_1_Vector64_Int32_1,
                ["InsertSelectedScalar.Vector64.Int32.1.Vector128.Int32.3"] = InsertSelectedScalar_Vector64_Int32_1_Vector128_Int32_3,
                ["InsertSelectedScalar.Vector64.SByte.7.Vector64.SByte.7"] = InsertSelectedScalar_Vector64_SByte_7_Vector64_SByte_7,
                ["InsertSelectedScalar.Vector64.SByte.7.Vector128.SByte.15"] = InsertSelectedScalar_Vector64_SByte_7_Vector128_SByte_15,
                ["InsertSelectedScalar.Vector64.Single.1.Vector64.Single.1"] = InsertSelectedScalar_Vector64_Single_1_Vector64_Single_1,
                ["InsertSelectedScalar.Vector64.Single.1.Vector128.Single.3"] = InsertSelectedScalar_Vector64_Single_1_Vector128_Single_3,
                ["InsertSelectedScalar.Vector64.UInt16.3.Vector64.UInt16.3"] = InsertSelectedScalar_Vector64_UInt16_3_Vector64_UInt16_3,
                ["InsertSelectedScalar.Vector64.UInt16.3.Vector128.UInt16.7"] = InsertSelectedScalar_Vector64_UInt16_3_Vector128_UInt16_7,
                ["InsertSelectedScalar.Vector64.UInt32.1.Vector64.UInt32.1"] = InsertSelectedScalar_Vector64_UInt32_1_Vector64_UInt32_1,
                ["InsertSelectedScalar.Vector64.UInt32.1.Vector128.UInt32.3"] = InsertSelectedScalar_Vector64_UInt32_1_Vector128_UInt32_3,
                ["InsertSelectedScalar.Vector128.Byte.15.Vector64.Byte.7"] = InsertSelectedScalar_Vector128_Byte_15_Vector64_Byte_7,
                ["InsertSelectedScalar.Vector128.Byte.15.Vector128.Byte.15"] = InsertSelectedScalar_Vector128_Byte_15_Vector128_Byte_15,
                ["InsertSelectedScalar.Vector128.Double.1.Vector128.Double.1"] = InsertSelectedScalar_Vector128_Double_1_Vector128_Double_1,
                ["InsertSelectedScalar.Vector128.Int16.7.Vector64.Int16.3"] = InsertSelectedScalar_Vector128_Int16_7_Vector64_Int16_3,
                ["InsertSelectedScalar.Vector128.Int16.7.Vector128.Int16.7"] = InsertSelectedScalar_Vector128_Int16_7_Vector128_Int16_7,
                ["InsertSelectedScalar.Vector128.Int32.3.Vector64.Int32.1"] = InsertSelectedScalar_Vector128_Int32_3_Vector64_Int32_1,
                ["InsertSelectedScalar.Vector128.Int32.3.Vector128.Int32.3"] = InsertSelectedScalar_Vector128_Int32_3_Vector128_Int32_3,
                ["InsertSelectedScalar.Vector128.Int64.1.Vector128.Int64.1"] = InsertSelectedScalar_Vector128_Int64_1_Vector128_Int64_1,
                ["InsertSelectedScalar.Vector128.SByte.15.Vector64.SByte.7"] = InsertSelectedScalar_Vector128_SByte_15_Vector64_SByte_7,
                ["InsertSelectedScalar.Vector128.SByte.15.Vector128.SByte.15"] = InsertSelectedScalar_Vector128_SByte_15_Vector128_SByte_15,
                ["InsertSelectedScalar.Vector128.Single.3.Vector64.Single.1"] = InsertSelectedScalar_Vector128_Single_3_Vector64_Single_1,
                ["InsertSelectedScalar.Vector128.Single.3.Vector128.Single.3"] = InsertSelectedScalar_Vector128_Single_3_Vector128_Single_3,
                ["InsertSelectedScalar.Vector128.UInt16.7.Vector64.UInt16.3"] = InsertSelectedScalar_Vector128_UInt16_7_Vector64_UInt16_3,
                ["InsertSelectedScalar.Vector128.UInt16.7.Vector128.UInt16.7"] = InsertSelectedScalar_Vector128_UInt16_7_Vector128_UInt16_7,
                ["InsertSelectedScalar.Vector128.UInt32.3.Vector64.UInt32.1"] = InsertSelectedScalar_Vector128_UInt32_3_Vector64_UInt32_1,
                ["InsertSelectedScalar.Vector128.UInt32.3.Vector128.UInt32.3"] = InsertSelectedScalar_Vector128_UInt32_3_Vector128_UInt32_3,
                ["InsertSelectedScalar.Vector128.UInt64.1.Vector128.UInt64.1"] = InsertSelectedScalar_Vector128_UInt64_1_Vector128_UInt64_1,
                ["LoadAndReplicateToVector128.Double"] = LoadAndReplicateToVector128_Double,
                ["LoadAndReplicateToVector128.Int64"] = LoadAndReplicateToVector128_Int64,
                ["LoadAndReplicateToVector128.UInt64"] = LoadAndReplicateToVector128_UInt64,
                ["LoadPairScalarVector64.Int32"] = LoadPairScalarVector64_Int32,
                ["LoadPairScalarVector64.Single"] = LoadPairScalarVector64_Single,
                ["LoadPairScalarVector64.UInt32"] = LoadPairScalarVector64_UInt32,
                ["LoadPairScalarVector64NonTemporal.Int32"] = LoadPairScalarVector64NonTemporal_Int32,
                ["LoadPairScalarVector64NonTemporal.Single"] = LoadPairScalarVector64NonTemporal_Single,
                ["LoadPairScalarVector64NonTemporal.UInt32"] = LoadPairScalarVector64NonTemporal_UInt32,
                ["LoadPairVector64.Byte"] = LoadPairVector64_Byte,
                ["LoadPairVector64.Double"] = LoadPairVector64_Double,
                ["LoadPairVector64.Int16"] = LoadPairVector64_Int16,
                ["LoadPairVector64.Int32"] = LoadPairVector64_Int32,
                ["LoadPairVector64.Int64"] = LoadPairVector64_Int64,
                ["LoadPairVector64.SByte"] = LoadPairVector64_SByte,
                ["LoadPairVector64.Single"] = LoadPairVector64_Single,
                ["LoadPairVector64.UInt16"] = LoadPairVector64_UInt16,
                ["LoadPairVector64.UInt32"] = LoadPairVector64_UInt32,
                ["LoadPairVector64.UInt64"] = LoadPairVector64_UInt64,
                ["LoadPairVector64NonTemporal.Byte"] = LoadPairVector64NonTemporal_Byte,
                ["LoadPairVector64NonTemporal.Double"] = LoadPairVector64NonTemporal_Double,
                ["LoadPairVector64NonTemporal.Int16"] = LoadPairVector64NonTemporal_Int16,
                ["LoadPairVector64NonTemporal.Int32"] = LoadPairVector64NonTemporal_Int32,
                ["LoadPairVector64NonTemporal.Int64"] = LoadPairVector64NonTemporal_Int64,
                ["LoadPairVector64NonTemporal.SByte"] = LoadPairVector64NonTemporal_SByte,
                ["LoadPairVector64NonTemporal.Single"] = LoadPairVector64NonTemporal_Single,
                ["LoadPairVector64NonTemporal.UInt16"] = LoadPairVector64NonTemporal_UInt16,
                ["LoadPairVector64NonTemporal.UInt32"] = LoadPairVector64NonTemporal_UInt32,
                ["LoadPairVector64NonTemporal.UInt64"] = LoadPairVector64NonTemporal_UInt64,
                ["LoadPairVector128.Byte"] = LoadPairVector128_Byte,
                ["LoadPairVector128.Double"] = LoadPairVector128_Double,
                ["LoadPairVector128.Int16"] = LoadPairVector128_Int16,
                ["LoadPairVector128.Int32"] = LoadPairVector128_Int32,
                ["LoadPairVector128.Int64"] = LoadPairVector128_Int64,
                ["LoadPairVector128.SByte"] = LoadPairVector128_SByte,
                ["LoadPairVector128.Single"] = LoadPairVector128_Single,
                ["LoadPairVector128.UInt16"] = LoadPairVector128_UInt16,
                ["LoadPairVector128.UInt32"] = LoadPairVector128_UInt32,
                ["LoadPairVector128.UInt64"] = LoadPairVector128_UInt64,
                ["LoadPairVector128NonTemporal.Byte"] = LoadPairVector128NonTemporal_Byte,
                ["LoadPairVector128NonTemporal.Double"] = LoadPairVector128NonTemporal_Double,
                ["LoadPairVector128NonTemporal.Int16"] = LoadPairVector128NonTemporal_Int16,
                ["LoadPairVector128NonTemporal.Int32"] = LoadPairVector128NonTemporal_Int32,
                ["LoadPairVector128NonTemporal.Int64"] = LoadPairVector128NonTemporal_Int64,
                ["LoadPairVector128NonTemporal.SByte"] = LoadPairVector128NonTemporal_SByte,
                ["LoadPairVector128NonTemporal.Single"] = LoadPairVector128NonTemporal_Single,
                ["LoadPairVector128NonTemporal.UInt16"] = LoadPairVector128NonTemporal_UInt16,
                ["LoadPairVector128NonTemporal.UInt32"] = LoadPairVector128NonTemporal_UInt32,
                ["LoadPairVector128NonTemporal.UInt64"] = LoadPairVector128NonTemporal_UInt64,
                ["Max.Vector128.Double"] = Max_Vector128_Double,
                ["MaxAcross.Vector64.Byte"] = MaxAcross_Vector64_Byte,
                ["MaxAcross.Vector64.Int16"] = MaxAcross_Vector64_Int16,
                ["MaxAcross.Vector64.SByte"] = MaxAcross_Vector64_SByte,
                ["MaxAcross.Vector64.UInt16"] = MaxAcross_Vector64_UInt16,
                ["MaxAcross.Vector128.Byte"] = MaxAcross_Vector128_Byte,
                ["MaxAcross.Vector128.Int16"] = MaxAcross_Vector128_Int16,
                ["MaxAcross.Vector128.Int32"] = MaxAcross_Vector128_Int32,
                ["MaxAcross.Vector128.SByte"] = MaxAcross_Vector128_SByte,
                ["MaxAcross.Vector128.Single"] = MaxAcross_Vector128_Single,
                ["MaxAcross.Vector128.UInt16"] = MaxAcross_Vector128_UInt16,
                ["MaxAcross.Vector128.UInt32"] = MaxAcross_Vector128_UInt32,
                ["MaxNumber.Vector128.Double"] = MaxNumber_Vector128_Double,
                ["MaxNumberAcross.Vector128.Single"] = MaxNumberAcross_Vector128_Single,
                ["MaxNumberPairwise.Vector64.Single"] = MaxNumberPairwise_Vector64_Single,
                ["MaxNumberPairwise.Vector128.Double"] = MaxNumberPairwise_Vector128_Double,
            };
        }
    }
}
